/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.player;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketUseEntity;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.ItemDropData;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketState;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;

public final class InteractEntityPacketState
extends BasicPacketState {
    @Override
    public boolean ignoresItemPreMerging() {
        return true;
    }

    @Override
    public boolean isPacketIgnored(Packet<?> packetIn, EntityPlayerMP packetPlayer) {
        CPacketUseEntity useEntityPacket = (CPacketUseEntity)packetIn;
        Entity entity = useEntityPacket.func_149564_a(packetPlayer.field_70170_p);
        return entity == null;
    }

    @Override
    public void populateContext(EntityPlayerMP playerMP, Packet<?> packet, BasicPacketContext context) {
        CPacketUseEntity useEntityPacket = (CPacketUseEntity)packet;
        Entity entity = useEntityPacket.func_149564_a(playerMP.field_70170_p);
        if (entity != null) {
            ItemStack stack = ItemStackUtil.cloneDefensive(playerMP.func_184586_b(useEntityPacket.func_186994_b()));
            if (stack != null) {
                context.itemUsed(stack);
            }
            HandType handType = (HandType)useEntityPacket.func_186994_b();
            context.handUsed(handType);
        }
    }

    @Override
    public boolean doesCaptureEntityDrops(BasicPacketContext context) {
        return true;
    }

    @Override
    public void unwind(BasicPacketContext phaseContext) {
        EntityPlayerMP player = phaseContext.getPacketPlayer();
        CPacketUseEntity useEntityPacket = (CPacketUseEntity)phaseContext.getPacket();
        Entity entity = useEntityPacket.func_149564_a(player.field_70170_p);
        if (entity == null) {
            return;
        }
        World spongeWorld = EntityUtil.getSpongeWorld((Entity)player);
        EntityUtil.toMixin(entity).setNotifier(player.func_110124_au());
        phaseContext.getCapturedBlockSupplier().acceptAndClearIfNotEmpty(blocks -> {
            PrettyPrinter printer = new PrettyPrinter(80);
            printer.add("Processing Interact Entity").centre().hr();
            printer.add("The blocks captured are:");
            for (BlockSnapshot blockSnapshot : blocks) {
                printer.add("  Block: %s", blockSnapshot);
            }
            printer.trace(System.err);
        });
        phaseContext.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(entities -> {
            PrettyPrinter printer = new PrettyPrinter(80);
            printer.add("Processing Interact Entity").centre().hr();
            printer.add("The entities captured are:");
            for (org.spongepowered.api.entity.Entity capturedEntity : entities) {
                printer.add("  Entity: %s", capturedEntity);
            }
            printer.trace(System.err);
        });
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(player);
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.PLACEMENT);
            phaseContext.getCapturedItemsSupplier().acceptAndClearIfNotEmpty(entities -> {
                List<org.spongepowered.api.entity.Entity> items = entities.stream().map(EntityUtil::fromNative).collect(Collectors.toList());
                SpongeCommonEventFactory.callSpawnEntity(items, phaseContext);
            });
        }
        phaseContext.getPerEntityItemDropSupplier().acceptAndClearIfNotEmpty(map -> {
            PrettyPrinter printer = new PrettyPrinter(80);
            printer.add("Processing Interact Entity").centre().hr();
            printer.add("The item stacks captured are: ");
            for (Map.Entry entry : map.asMap().entrySet()) {
                printer.add("  - Entity with UUID: %s", entry.getKey());
                for (ItemDropData stack : (Collection)entry.getValue()) {
                    printer.add("    - %s", stack);
                }
            }
            printer.trace(System.err);
        });
        phaseContext.getCapturedBlockSupplier().acceptAndClearIfNotEmpty(snapshots -> TrackingUtil.processBlockCaptures(snapshots, this, phaseContext));
    }

    @Override
    public boolean tracksEntitySpecificDrops() {
        return true;
    }
}

