/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.player;

import com.flowpowered.math.vector.Vector3d;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.ItemDropData;
import org.spongepowered.common.event.tracking.phase.block.BlockPhase;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketState;
import org.spongepowered.common.interfaces.IMixinContainer;
import org.spongepowered.common.item.inventory.util.ContainerUtil;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.util.VecHelper;

public final class InteractionPacketState
extends BasicPacketState {
    @Override
    public boolean isInteraction() {
        return true;
    }

    @Override
    public void populateContext(EntityPlayerMP playerMP, Packet<?> packet, BasicPacketContext context) {
        ItemStack stack = ItemStackUtil.cloneDefensive(playerMP.func_184614_ca());
        if (stack != null) {
            context.itemUsed(stack);
        }
        context.targetBlock(new Location<World>(((Player)playerMP).getWorld(), VecHelper.toVector3d(((CPacketPlayerDigging)packet).func_179715_a())).createSnapshot());
        context.handUsed(HandTypes.MAIN_HAND);
    }

    @Override
    public boolean spawnEntityOrCapture(BasicPacketContext context, Entity entity, int chunkX, int chunkZ) {
        return context.captureEntity(entity);
    }

    @Override
    public boolean shouldCaptureEntity() {
        return true;
    }

    @Override
    public boolean doesCaptureEntityDrops(BasicPacketContext context) {
        return true;
    }

    @Override
    public boolean canSwitchTo(IPhaseState<?> state) {
        return state == BlockPhase.State.BLOCK_DECAY || state == BlockPhase.State.BLOCK_DROP_ITEMS;
    }

    @Override
    public boolean tracksBlockSpecificDrops(BasicPacketContext context) {
        return true;
    }

    @Override
    public boolean alreadyProcessingBlockItemDrops() {
        return true;
    }

    @Override
    public void unwind(BasicPacketContext phaseContext) {
        EntityPlayerMP player = phaseContext.getPacketPlayer();
        ItemStack usedStack = phaseContext.getItemUsed();
        HandType usedHand = phaseContext.getHandUsed();
        ItemStackSnapshot usedSnapshot = ItemStackUtil.snapshotOf(usedStack);
        Entity spongePlayer = EntityUtil.fromNative((net.minecraft.entity.Entity)player);
        BlockSnapshot targetBlock = phaseContext.getTargetBlock();
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            BlockSnapshot firstBlockChange;
            frame.pushCause(spongePlayer);
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
            frame.addContext(EventContextKeys.USED_ITEM, usedSnapshot);
            frame.addContext(EventContextKeys.USED_HAND, usedHand);
            frame.addContext(EventContextKeys.BLOCK_HIT, targetBlock);
            boolean hasBlocks = !phaseContext.getCapturedBlockSupplier().isEmpty();
            List<BlockSnapshot> capturedBlcoks = phaseContext.getCapturedBlocks();
            BlockSnapshot blockSnapshot = firstBlockChange = hasBlocks ? capturedBlcoks.get(0) : null;
            if (hasBlocks) {
                if (!TrackingUtil.processBlockCaptures(capturedBlcoks, this, phaseContext)) {
                    phaseContext.getBlockItemDropSupplier().get().clear();
                    phaseContext.getCapturedItems().clear();
                    phaseContext.getPerEntityItemDropSupplier().get().clear();
                    phaseContext.getCapturedEntities().clear();
                    return;
                }
            } else {
                phaseContext.getBlockItemDropSupplier().acceptAndClearIfNotEmpty(map -> {
                    if (ShouldFire.DROP_ITEM_EVENT_DESTRUCT) {
                        for (BlockSnapshot blockChange : capturedBlcoks) {
                            Location<World> location = blockChange.getLocation().get();
                            Vector3d position = location.getPosition();
                            BlockPos blockPos = VecHelper.toBlockPos(position);
                            List entityItems = map.get((Object)blockPos);
                            if (entityItems.isEmpty()) continue;
                            List items = entityItems.stream().map(EntityUtil::fromNative).collect(Collectors.toList());
                            DropItemEvent.Destruct event = SpongeEventFactory.createDropItemEventDestruct(Sponge.getCauseStackManager().getCurrentCause(), items);
                            SpongeImpl.postEvent(event);
                            if (event.isCancelled()) continue;
                            InteractionPacketState.processSpawnedEntities(player, event);
                        }
                    } else {
                        for (BlockSnapshot blockChange : capturedBlcoks) {
                            Location<World> location = blockChange.getLocation().get();
                            Vector3d position = location.getPosition();
                            BlockPos blockPos = VecHelper.toBlockPos(position);
                            List entityItems = map.get((Object)blockPos);
                            if (entityItems.isEmpty()) continue;
                            InteractionPacketState.processEntities(player, entityItems);
                        }
                    }
                });
            }
            phaseContext.getCapturedItemsSupplier().acceptAndClearIfNotEmpty(items -> {
                ArrayList<Entity> entities = new ArrayList<Entity>();
                for (EntityItem item : items) {
                    entities.add(EntityUtil.fromNative((net.minecraft.entity.Entity)item));
                }
                DropItemEvent.Dispense dispense = SpongeEventFactory.createDropItemEventDispense(Sponge.getCauseStackManager().getCurrentCause(), entities);
                SpongeImpl.postEvent(dispense);
                if (!dispense.isCancelled()) {
                    InteractionPacketState.processSpawnedEntities(player, dispense);
                }
            });
            phaseContext.getPerEntityItemDropSupplier().acceptAndClearIfNotEmpty(map -> {
                if (map.isEmpty()) {
                    return;
                }
                PrettyPrinter printer = new PrettyPrinter(80);
                printer.add("Processing Interaction").centre().hr();
                printer.add("The item stacks captured are: ");
                for (Map.Entry entry : map.asMap().entrySet()) {
                    printer.add("  - Entity with UUID: %s", entry.getKey());
                    for (ItemDropData stack : (Collection)entry.getValue()) {
                        printer.add("    - %s", stack);
                    }
                }
                printer.trace(System.err);
            });
            phaseContext.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(entities -> {
                CauseStackManager.StackFrame stackFrame;
                Throwable throwable;
                CauseStackManager.StackFrame frame2;
                ArrayList<Entity> projectiles = new ArrayList<Entity>(entities.size());
                ArrayList<Entity> spawnEggs = new ArrayList<Entity>(entities.size());
                ArrayList<Entity> xpOrbs = new ArrayList<Entity>(entities.size());
                ArrayList<Entity> normalPlacement = new ArrayList<Entity>(entities.size());
                ArrayList<Entity> items = new ArrayList<Entity>(entities.size());
                for (Entity entity : entities) {
                    if (entity instanceof Projectile || entity instanceof EntityThrowable) {
                        projectiles.add(entity);
                        continue;
                    }
                    if (usedSnapshot.getType() == ItemTypes.SPAWN_EGG) {
                        spawnEggs.add(entity);
                        continue;
                    }
                    if (entity instanceof EntityItem) {
                        items.add(entity);
                        continue;
                    }
                    if (entity instanceof EntityXPOrb) {
                        xpOrbs.add(entity);
                        continue;
                    }
                    normalPlacement.add(entity);
                }
                if (!projectiles.isEmpty()) {
                    if (ShouldFire.SPAWN_ENTITY_EVENT) {
                        frame2 = Sponge.getCauseStackManager().pushCauseFrame();
                        throwable = null;
                        try {
                            frame2.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.PROJECTILE);
                            frame2.pushCause(usedSnapshot);
                            SpongeCommonEventFactory.callSpawnEntity(projectiles, phaseContext);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (frame2 != null) {
                                if (throwable != null) {
                                    try {
                                        frame2.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    frame2.close();
                                }
                            }
                        }
                    } else {
                        InteractionPacketState.processEntities(player, projectiles);
                    }
                }
                if (!spawnEggs.isEmpty()) {
                    if (ShouldFire.SPAWN_ENTITY_EVENT) {
                        frame2 = Sponge.getCauseStackManager().pushCauseFrame();
                        throwable = null;
                        try {
                            frame2.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.SPAWN_EGG);
                            frame2.pushCause(usedSnapshot);
                            SpongeCommonEventFactory.callSpawnEntity(spawnEggs, phaseContext);
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (frame2 != null) {
                                if (throwable != null) {
                                    try {
                                        frame2.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    frame2.close();
                                }
                            }
                        }
                    } else {
                        InteractionPacketState.processEntities(player, spawnEggs);
                    }
                }
                if (!items.isEmpty()) {
                    if (ShouldFire.DROP_ITEM_EVENT_DISPENSE) {
                        DropItemEvent.Dispense dispense = SpongeEventFactory.createDropItemEventDispense(Sponge.getCauseStackManager().getCurrentCause(), items);
                        if (!SpongeImpl.postEvent(dispense)) {
                            InteractionPacketState.processSpawnedEntities(player, dispense);
                        }
                    } else {
                        InteractionPacketState.processEntities(player, items);
                    }
                }
                if (!xpOrbs.isEmpty()) {
                    if (ShouldFire.SPAWN_ENTITY_EVENT) {
                        stackFrame = Sponge.getCauseStackManager().pushCauseFrame();
                        throwable = null;
                        try {
                            if (firstBlockChange != null) {
                                stackFrame.pushCause(firstBlockChange);
                            }
                            stackFrame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.EXPERIENCE);
                            SpongeCommonEventFactory.callSpawnEntity(xpOrbs, phaseContext);
                        }
                        catch (Throwable throwable6) {
                            throwable = throwable6;
                            throw throwable6;
                        }
                        finally {
                            if (stackFrame != null) {
                                if (throwable != null) {
                                    try {
                                        stackFrame.close();
                                    }
                                    catch (Throwable throwable7) {
                                        throwable.addSuppressed(throwable7);
                                    }
                                } else {
                                    stackFrame.close();
                                }
                            }
                        }
                    } else {
                        InteractionPacketState.processEntities(player, xpOrbs);
                    }
                }
                if (!normalPlacement.isEmpty()) {
                    if (ShouldFire.SPAWN_ENTITY_EVENT) {
                        stackFrame = Sponge.getCauseStackManager().pushCauseFrame();
                        throwable = null;
                        try {
                            if (firstBlockChange != null) {
                                stackFrame.pushCause(firstBlockChange);
                            }
                            SpongeCommonEventFactory.callSpawnEntity(normalPlacement, phaseContext);
                        }
                        catch (Throwable throwable8) {
                            throwable = throwable8;
                            throw throwable8;
                        }
                        finally {
                            if (stackFrame != null) {
                                if (throwable != null) {
                                    try {
                                        stackFrame.close();
                                    }
                                    catch (Throwable throwable9) {
                                        throwable.addSuppressed(throwable9);
                                    }
                                } else {
                                    stackFrame.close();
                                }
                            }
                        }
                    } else {
                        InteractionPacketState.processEntities(player, normalPlacement);
                    }
                }
            });
            IMixinContainer mixinContainer = ContainerUtil.toMixin(player.field_71070_bA);
            mixinContainer.setCaptureInventory(false);
            mixinContainer.getCapturedTransactions().clear();
        }
    }

    @Override
    public boolean tracksEntitySpecificDrops() {
        return true;
    }
}

