/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.adapter.impl.comp;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.property.SlotIndex;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.api.item.inventory.type.OrderedInventory;
import org.spongepowered.common.item.inventory.adapter.impl.AdapterLogic;
import org.spongepowered.common.item.inventory.adapter.impl.VanillaAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.lens.comp.OrderedInventoryLens;
import org.spongepowered.common.item.inventory.lens.slots.SlotLens;

public class OrderedInventoryAdapter
extends VanillaAdapter
implements OrderedInventory {
    protected final OrderedInventoryLens orderedLens;

    public OrderedInventoryAdapter(Fabric inventory, OrderedInventoryLens root) {
        this(inventory, root, null);
    }

    public OrderedInventoryAdapter(Fabric inventory, OrderedInventoryLens root, Inventory parent) {
        super(inventory, (Lens)Preconditions.checkNotNull((Object)root), parent);
        this.orderedLens = root;
    }

    protected SlotLens getSlotLens(int index) {
        if (index < 0) {
            return null;
        }
        if (this.orderedLens.hasSlotRealIndex(index)) {
            return this.orderedLens.getSlot(index);
        }
        return null;
    }

    protected SlotLens getSlotLens(SlotIndex index) {
        return this.getSlotLens((Integer)index.getValue());
    }

    @Override
    public Optional<Slot> getSlot(SlotIndex index) {
        return VanillaAdapter.forSlot(this.inventory, this.getSlotLens(index), this);
    }

    @Override
    public Optional<ItemStack> poll(SlotIndex index) {
        return AdapterLogic.pollSequential(this.inventory, this.getSlotLens(index));
    }

    @Override
    public Optional<ItemStack> poll(SlotIndex index, int limit) {
        return AdapterLogic.pollSequential(this.inventory, this.getSlotLens(index), limit);
    }

    @Override
    public Optional<ItemStack> peek(SlotIndex index) {
        return AdapterLogic.peekSequential(this.inventory, this.getSlotLens(index));
    }

    @Override
    public Optional<ItemStack> peek(SlotIndex index, int limit) {
        return AdapterLogic.peekSequential(this.inventory, this.getSlotLens(index), limit);
    }

    @Override
    public InventoryTransactionResult set(SlotIndex index, ItemStack stack) {
        return AdapterLogic.insertSequential(this.inventory, this.getSlotLens(index), stack);
    }
}

