/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import co.aikar.timings.Timing;
import com.flowpowered.math.vector.Vector3d;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBeacon;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockEndGateway;
import net.minecraft.block.BlockEnderChest;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import org.apache.logging.log4j.Level;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSoundGroup;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.block.trait.BlockTrait;
import org.spongepowered.api.data.Property;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.ConstructEntityEvent;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.config.SpongeConfig;
import org.spongepowered.common.config.category.BlockTrackerCategory;
import org.spongepowered.common.config.category.BlockTrackerModCategory;
import org.spongepowered.common.config.type.TrackerConfig;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseData;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.block.BlockPhase;
import org.spongepowered.common.interfaces.block.IMixinBlock;
import org.spongepowered.common.interfaces.world.IMixinWorld;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.registry.type.BlockTypeRegistryModule;
import org.spongepowered.common.relocate.co.aikar.timings.SpongeTimings;
import org.spongepowered.common.text.translation.SpongeTranslation;

@NonnullByDefault
@Mixin(value={Block.class}, priority=999)
@Implements(value={@Interface(iface=BlockType.class, prefix="block$")})
public abstract class MixinBlock
implements BlockType,
IMixinBlock {
    private final boolean isVanilla = this.getClass().getName().startsWith("net.minecraft.");
    private boolean hasCollideLogic;
    private boolean hasCollideWithStateLogic;
    private boolean shouldFireBlockEvents = true;
    private static boolean canCaptureItems = true;
    private Timing timing;
    private boolean allowsBlockBulkCapture = true;
    private boolean allowsEntityBulkCapture = true;
    private boolean allowsBlockEventCreation = true;
    private boolean allowsEntityEventCreation = true;
    @Shadow
    private boolean field_149789_z;
    @Shadow
    protected SoundType field_149762_H;
    @Shadow
    @Final
    protected BlockStateContainer field_176227_L;
    @Shadow
    protected boolean field_149790_y;
    @Nullable
    private PhaseData data = null;

    @Shadow
    public abstract String func_149739_a();

    @Shadow
    public abstract Material func_149688_o(IBlockState var1);

    @Shadow
    public abstract IBlockState shadow$func_176223_P();

    @Shadow
    public abstract boolean shadow$func_149653_t();

    @Shadow
    public abstract void func_176226_b(net.minecraft.world.World var1, BlockPos var2, IBlockState var3, int var4);

    @Shadow
    public abstract BlockStateContainer func_176194_O();

    @Inject(method={"registerBlock(ILnet/minecraft/util/ResourceLocation;Lnet/minecraft/block/Block;)V"}, at={@At(value="RETURN")})
    private static void onRegisterBlock(int id, ResourceLocation location, Block block, CallbackInfo ci) {
        BlockTypeRegistryModule.getInstance().registerFromGameData(location.toString(), (BlockType)block);
    }

    @Override
    public String getId() {
        return this.getNameFromRegistry();
    }

    @Override
    public String getName() {
        return this.getNameFromRegistry();
    }

    private String getNameFromRegistry() {
        try {
            return ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)((Block)this))).toString();
        }
        catch (NullPointerException e) {
            throw new RuntimeException(String.format("Block '%s' (class '%s') is not registered with the block registry! This is likely a bug in the corresponding mod.", this, this.getClass().getName()), e);
        }
    }

    @Override
    public BlockState getDefaultState() {
        return (BlockState)this.shadow$func_176223_P();
    }

    @Override
    public Collection<BlockState> getAllBlockStates() {
        return this.field_176227_L.func_177619_a();
    }

    @Override
    public Optional<ItemType> getItem() {
        if (this == BlockTypes.AIR) {
            return Optional.of(ItemTypes.AIR);
        }
        ItemType itemType = (ItemType)Item.func_150898_a((Block)((Block)this));
        return Items.field_190931_a.equals(itemType) ? Optional.empty() : Optional.of(itemType);
    }

    @Override
    public Translation getTranslation() {
        return new SpongeTranslation(this.func_149739_a() + ".name");
    }

    @Intrinsic
    public boolean block$getTickRandomly() {
        return this.shadow$func_149653_t();
    }

    @Override
    public void setTickRandomly(boolean tickRandomly) {
        this.field_149789_z = tickRandomly;
    }

    @Override
    public boolean supports(Class<? extends ImmutableDataManipulator<?, ?>> immutable) {
        return false;
    }

    @Override
    public Optional<BlockState> getStateWithData(IBlockState blockState, ImmutableDataManipulator<?, ?> manipulator) {
        return Optional.empty();
    }

    @Override
    public <E> Optional<BlockState> getStateWithValue(IBlockState blockState, Key<? extends BaseValue<E>> key, E value) {
        return Optional.empty();
    }

    @Override
    public List<ImmutableDataManipulator<?, ?>> getManipulators(IBlockState blockState) {
        return ImmutableList.of();
    }

    @Override
    public ImmutableMap<Class<? extends Property<?, ?>>, Property<?, ?>> getProperties(IBlockState blockState) {
        return this.populateSpongeProperties(ImmutableMap.builder(), blockState).build();
    }

    private ImmutableMap.Builder<Class<? extends Property<?, ?>>, Property<?, ?>> populateSpongeProperties(ImmutableMap.Builder<Class<? extends Property<?, ?>>, Property<?, ?>> builder, IBlockState blockState) {
        for (Property<?, ?> property : SpongeImpl.getPropertyRegistry().getPropertiesFor((BlockState)blockState)) {
            builder.put(property.getClass(), property);
        }
        return builder;
    }

    @Override
    public BlockState getDefaultBlockState() {
        return this.getDefaultState();
    }

    @Override
    public Collection<BlockTrait<?>> getTraits() {
        return this.getDefaultBlockState().getTraits();
    }

    @Override
    public Optional<BlockTrait<?>> getTrait(String blockTrait) {
        return this.getDefaultBlockState().getTrait(blockTrait);
    }

    @Inject(method={"harvestBlock"}, at={@At(value="HEAD")})
    private void onHarvestBlockHead(net.minecraft.world.World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack, CallbackInfo ci) {
        if (stack != null && SpongeImplHooks.isFakePlayer((Entity)player) && player.func_184614_ca() != null && !player.func_184614_ca().func_190926_b()) {
            canCaptureItems = false;
        }
    }

    @Inject(method={"harvestBlock"}, at={@At(value="RETURN")})
    private void onHarvestBlockReturn(net.minecraft.world.World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack, CallbackInfo ci) {
        canCaptureItems = true;
    }

    @Overwrite
    public static void func_180635_a(net.minecraft.world.World worldIn, BlockPos pos, ItemStack stack) {
        boolean doTileDrops = worldIn.func_82736_K().func_82766_b("doTileDrops");
        if (worldIn.field_72995_K || !SpongeImplHooks.isMainThread() || stack.func_190926_b() || !doTileDrops || SpongeImplHooks.isRestoringBlocks(worldIn)) {
            return;
        }
        if (PhaseTracker.getInstance().getCurrentState() == BlockPhase.State.RESTORING_BLOCKS) {
            return;
        }
        double xOffset = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
        double yOffset = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
        double zOffset = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
        double xPos = (double)pos.func_177958_n() + xOffset;
        double yPos = (double)pos.func_177956_o() + yOffset;
        double zPos = (double)pos.func_177952_p() + zOffset;
        Transform<World> position = new Transform<World>((World)worldIn, new Vector3d(xPos, yPos, zPos));
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(worldIn.func_180495_p(pos));
            ConstructEntityEvent.Pre eventPre = SpongeEventFactory.createConstructEntityEventPre(frame.getCurrentCause(), EntityTypes.ITEM, position);
            SpongeImpl.postEvent(eventPre);
            if (eventPre.isCancelled()) {
                return;
            }
        }
        EntityItem entityitem = new EntityItem(worldIn, xPos, yPos, zPos, stack);
        entityitem.func_174869_p();
        PhaseContext<?> context = PhaseTracker.getInstance().getCurrentContext();
        if (context.allowsBulkEntityCaptures() && context.allowsBlockPosCapturing()) {
            context.getCaptureBlockPos().setPos(pos);
            worldIn.func_72838_d((Entity)entityitem);
            context.getCaptureBlockPos().setPos(null);
            return;
        }
        worldIn.func_72838_d((Entity)entityitem);
    }

    @Inject(method={"dropBlockAsItemWithChance"}, at={@At(value="HEAD")}, cancellable=true)
    private void onDropBlockAsItemWithChanceHead(net.minecraft.world.World worldIn, BlockPos pos, IBlockState state, float chance, int fortune, CallbackInfo ci) {
        if (!((IMixinWorld)worldIn).isFake() && !SpongeImplHooks.isRestoringBlocks(worldIn)) {
            boolean shouldEnterBlockDropPhase;
            if (PhaseTracker.getInstance().getCurrentState() == BlockPhase.State.RESTORING_BLOCKS) {
                ci.cancel();
                return;
            }
            IMixinWorldServer mixinWorld = (IMixinWorldServer)worldIn;
            PhaseTracker phaseTracker = PhaseTracker.getInstance();
            IPhaseState<?> currentState = phaseTracker.getCurrentState();
            PhaseContext<?> currentContext = phaseTracker.getCurrentContext();
            boolean bl = shouldEnterBlockDropPhase = !currentContext.isCapturingBlockItemDrops() && !currentState.alreadyProcessingBlockItemDrops() && !currentState.isWorldGeneration();
            if (shouldEnterBlockDropPhase) {
                Object context = ((PhaseContext)BlockPhase.State.BLOCK_DROP_ITEMS.createPhaseContext()).source(mixinWorld.createSpongeBlockSnapshot(state, state, pos, BlockChangeFlags.PHYSICS_OBSERVER));
                currentContext.applyNotifierIfAvailable(arg_0 -> context.notifier(arg_0));
                currentContext.applyOwnerIfAvailable(arg_0 -> context.owner(arg_0));
                ((PhaseContext)context).buildAndSwitch();
            }
        }
    }

    @Inject(method={"dropBlockAsItemWithChance"}, at={@At(value="RETURN")}, cancellable=true)
    private void onDropBlockAsItemWithChanceReturn(net.minecraft.world.World worldIn, BlockPos pos, IBlockState state, float chance, int fortune, CallbackInfo ci) {
        if (!((IMixinWorld)worldIn).isFake() && !SpongeImplHooks.isRestoringBlocks(worldIn)) {
            boolean shouldEnterBlockDropPhase;
            if (this.data == null) {
                return;
            }
            PhaseTracker phaseTracker = PhaseTracker.getInstance();
            if (phaseTracker.getCurrentPhaseData() != this.data) {
                this.data = null;
                return;
            }
            PhaseData data = this.data;
            IPhaseState<?> currentState = data.state;
            boolean bl = shouldEnterBlockDropPhase = !data.context.isCapturingBlockItemDrops() && !currentState.alreadyProcessingBlockItemDrops() && !currentState.isWorldGeneration();
            if (shouldEnterBlockDropPhase) {
                phaseTracker.getCurrentContext().close();
            }
            this.data = null;
        }
    }

    @Override
    public boolean isVanilla() {
        return this.isVanilla;
    }

    @Override
    public boolean hasCollideLogic() {
        return this.hasCollideLogic;
    }

    @Override
    public boolean hasCollideWithStateLogic() {
        return this.hasCollideWithStateLogic;
    }

    @Override
    public Timing getTimingsHandler() {
        if (this.timing == null) {
            this.timing = SpongeTimings.getBlockTiming((Block)this);
        }
        return this.timing;
    }

    @Override
    public BlockSoundGroup getSoundGroup() {
        return (BlockSoundGroup)this.field_149762_H;
    }

    @Override
    public boolean allowsBlockBulkCapture() {
        return this.allowsBlockBulkCapture;
    }

    @Override
    public boolean allowsEntityBulkCapture() {
        return this.allowsEntityBulkCapture;
    }

    @Override
    public boolean allowsBlockEventCreation() {
        return this.allowsBlockEventCreation;
    }

    @Override
    public boolean allowsEntityEventCreation() {
        return this.allowsEntityEventCreation;
    }

    @Override
    public void refreshCache() {
    }

    @Override
    public boolean shouldFireBlockEvents() {
        return this.shouldFireBlockEvents;
    }

    @Override
    public void initializeTrackerState() {
        Class<?> clazz;
        Class[] argTypes;
        String mapping2;
        Block thisBlock;
        SpongeConfig<TrackerConfig> trackerConfig = SpongeImpl.getTrackerConfig();
        BlockTrackerCategory blockTracker = trackerConfig.getConfig().getBlockTracker();
        Object[] ids = this.getId().split(":");
        if (ids.length != 2) {
            PrettyPrinter printer = new PrettyPrinter(60).add("Malformatted Block ID discovered!").centre().hr().addWrapped(60, "Sponge has found a malformatted block id when trying to load configurations for the block id. The printed out block idis not originally from sponge, and should be brought up with themod developer as the registration for this block is not likelyto work with other systems and assumptions of having a properlyformatted block id.", new Object[0]).add("%s : %s", "Malformed ID", this.getId()).add("%s : %s", "Discovered id array", ids).add();
            String id = ids[0];
            ids = new String[]{"unknown", id};
            printer.add("Sponge will attempt to work around this by using the provided generated id:").add("%s : %s", "Generated ID", Arrays.toString(ids)).log(SpongeImpl.getLogger(), Level.WARN);
        }
        String modId = ids[0];
        String name = ids[1];
        BlockTrackerModCategory modCapturing = blockTracker.getModMappings().get(modId);
        if (modCapturing == null) {
            modCapturing = new BlockTrackerModCategory();
            blockTracker.getModMappings().put(modId, modCapturing);
        }
        if ((thisBlock = (Block)this) instanceof BlockMobSpawner || thisBlock instanceof BlockEnderChest || thisBlock instanceof BlockChest || thisBlock instanceof BlockShulkerBox || thisBlock instanceof BlockEndGateway || thisBlock instanceof BlockBeacon) {
            this.shouldFireBlockEvents = false;
        }
        this.hasCollideLogic = true;
        this.hasCollideWithStateLogic = true;
        try {
            mapping2 = SpongeImplHooks.isDeobfuscatedEnvironment() ? "onEntityWalk" : "func_176199_a";
            argTypes = new Class[]{net.minecraft.world.World.class, BlockPos.class, Entity.class};
            clazz = this.getClass().getMethod(mapping2, argTypes).getDeclaringClass();
            if (clazz.equals(Block.class)) {
                this.hasCollideLogic = false;
            }
        }
        catch (Throwable mapping2) {
            // empty catch block
        }
        try {
            mapping2 = SpongeImplHooks.isDeobfuscatedEnvironment() ? "onEntityCollision" : "func_180634_a";
            argTypes = new Class[]{net.minecraft.world.World.class, BlockPos.class, IBlockState.class, Entity.class};
            clazz = this.getClass().getMethod(mapping2, argTypes).getDeclaringClass();
            if (clazz.equals(Block.class)) {
                this.hasCollideWithStateLogic = false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!modCapturing.isEnabled()) {
            this.allowsBlockBulkCapture = false;
            this.allowsEntityBulkCapture = false;
            this.allowsBlockEventCreation = false;
            this.allowsEntityEventCreation = false;
            modCapturing.getBlockBulkCaptureMap().computeIfAbsent(name.toLowerCase(), k -> this.allowsBlockBulkCapture);
            modCapturing.getEntityBulkCaptureMap().computeIfAbsent(name.toLowerCase(), k -> this.allowsEntityBulkCapture);
            modCapturing.getBlockEventCreationMap().computeIfAbsent(name.toLowerCase(), k -> this.allowsBlockEventCreation);
            modCapturing.getEntityEventCreationMap().computeIfAbsent(name.toLowerCase(), k -> this.allowsEntityEventCreation);
        } else {
            this.allowsBlockBulkCapture = modCapturing.getBlockBulkCaptureMap().computeIfAbsent(name.toLowerCase(), k -> true);
            this.allowsEntityBulkCapture = modCapturing.getEntityBulkCaptureMap().computeIfAbsent(name.toLowerCase(), k -> true);
            this.allowsBlockEventCreation = modCapturing.getBlockEventCreationMap().computeIfAbsent(name.toLowerCase(), k -> true);
            this.allowsEntityEventCreation = modCapturing.getEntityEventCreationMap().computeIfAbsent(name.toLowerCase(), k -> true);
        }
        if (blockTracker.autoPopulateData()) {
            trackerConfig.save();
        }
    }
}

