/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.IStringSerializable;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableConnectedDirectionData;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableRedstonePoweredData;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableWireAttachmentData;
import org.spongepowered.api.data.type.WireAttachmentType;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.util.Direction;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.data.ImmutableDataCachingUtil;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeConnectedDirectionData;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeRedstonePoweredData;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeWireAttachmentData;
import org.spongepowered.common.mixin.core.block.MixinBlock;

@Mixin(value={BlockRedstoneWire.class})
public abstract class MixinBlockRedstoneWire
extends MixinBlock {
    public ImmutableList<ImmutableDataManipulator<?, ?>> getManipulators(IBlockState blockState) {
        return ImmutableList.of((Object)this.getPowerFor(blockState), (Object)this.getConnectedDirectionData(blockState), (Object)this.getWireAttachmentData(blockState));
    }

    @Override
    public boolean supports(Class<? extends ImmutableDataManipulator<?, ?>> immutable) {
        return ImmutableRedstonePoweredData.class.isAssignableFrom(immutable) || ImmutableConnectedDirectionData.class.isAssignableFrom(immutable) || ImmutableWireAttachmentData.class.isAssignableFrom(immutable);
    }

    @Override
    public Optional<BlockState> getStateWithData(IBlockState blockState, ImmutableDataManipulator<?, ?> manipulator) {
        if (manipulator instanceof ImmutableRedstonePoweredData) {
            return Optional.of((BlockState)blockState);
        }
        if (manipulator instanceof ImmutableConnectedDirectionData) {
            return Optional.of((BlockState)blockState);
        }
        if (manipulator instanceof ImmutableWireAttachmentData) {
            return Optional.of((BlockState)blockState);
        }
        return super.getStateWithData(blockState, manipulator);
    }

    @Override
    public <E> Optional<BlockState> getStateWithValue(IBlockState blockState, Key<? extends BaseValue<E>> key, E value) {
        if (key.equals(Keys.POWER)) {
            return Optional.of((BlockState)blockState);
        }
        if (key.equals(Keys.CONNECTED_DIRECTIONS) || key.equals(Keys.CONNECTED_EAST) || key.equals(Keys.CONNECTED_NORTH) || key.equals(Keys.CONNECTED_SOUTH) || key.equals(Keys.CONNECTED_WEST) || key.equals(Keys.WIRE_ATTACHMENTS) || key.equals(Keys.WIRE_ATTACHMENT_NORTH) || key.equals(Keys.WIRE_ATTACHMENT_SOUTH) || key.equals(Keys.WIRE_ATTACHMENT_EAST) || key.equals(Keys.WIRE_ATTACHMENT_WEST)) {
            return Optional.of((BlockState)blockState);
        }
        return super.getStateWithValue(blockState, key, value);
    }

    private ImmutableRedstonePoweredData getPowerFor(IBlockState blockState) {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeRedstonePoweredData.class, blockState.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O));
    }

    private ImmutableConnectedDirectionData getConnectedDirectionData(IBlockState blockState) {
        HashSet<Direction> directions = new HashSet<Direction>();
        IStringSerializable north = (IStringSerializable)blockState.func_177229_b((IProperty)BlockRedstoneWire.field_176348_a);
        IStringSerializable east = (IStringSerializable)blockState.func_177229_b((IProperty)BlockRedstoneWire.field_176347_b);
        IStringSerializable west = (IStringSerializable)blockState.func_177229_b((IProperty)BlockRedstoneWire.field_176350_N);
        IStringSerializable south = (IStringSerializable)blockState.func_177229_b((IProperty)BlockRedstoneWire.field_176349_M);
        if (!north.func_176610_l().matches("none")) {
            directions.add(Direction.NORTH);
        }
        if (!east.func_176610_l().matches("none")) {
            directions.add(Direction.EAST);
        }
        if (!west.func_176610_l().matches("none")) {
            directions.add(Direction.WEST);
        }
        if (!south.func_176610_l().matches("none")) {
            directions.add(Direction.SOUTH);
        }
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeConnectedDirectionData.class, directions);
    }

    private ImmutableWireAttachmentData getWireAttachmentData(IBlockState blockState) {
        HashMap<Direction, WireAttachmentType> data = new HashMap<Direction, WireAttachmentType>();
        data.put(Direction.NORTH, (WireAttachmentType)((Object)blockState.func_177229_b((IProperty)BlockRedstoneWire.field_176348_a)));
        data.put(Direction.SOUTH, (WireAttachmentType)((Object)blockState.func_177229_b((IProperty)BlockRedstoneWire.field_176349_M)));
        data.put(Direction.EAST, (WireAttachmentType)((Object)blockState.func_177229_b((IProperty)BlockRedstoneWire.field_176347_b)));
        data.put(Direction.WEST, (WireAttachmentType)((Object)blockState.func_177229_b((IProperty)BlockRedstoneWire.field_176350_N)));
        return new ImmutableSpongeWireAttachmentData(data);
    }
}

