/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.block.BlockWall;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableConnectedDirectionData;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableWallData;
import org.spongepowered.api.data.type.WallType;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.api.util.Direction;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.data.ImmutableDataCachingUtil;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeConnectedDirectionData;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeWallData;
import org.spongepowered.common.mixin.core.block.MixinBlock;
import org.spongepowered.common.text.translation.SpongeTranslation;

@Mixin(value={BlockWall.class})
public abstract class MixinBlockWall
extends MixinBlock {
    public ImmutableList<ImmutableDataManipulator<?, ?>> getManipulators(IBlockState blockState) {
        return ImmutableList.of((Object)this.getWallTypeFor(blockState), (Object)this.getConnectedDirectionData(blockState));
    }

    @Override
    public boolean supports(Class<? extends ImmutableDataManipulator<?, ?>> immutable) {
        return ImmutableWallData.class.isAssignableFrom(immutable) || ImmutableConnectedDirectionData.class.isAssignableFrom(immutable);
    }

    @Override
    public Optional<BlockState> getStateWithData(IBlockState blockState, ImmutableDataManipulator<?, ?> manipulator) {
        if (manipulator instanceof ImmutableWallData) {
            BlockWall.EnumType wallType = (BlockWall.EnumType)((ImmutableWallData)manipulator).type().get();
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockWall.field_176255_P, (Comparable)wallType));
        }
        if (manipulator instanceof ImmutableConnectedDirectionData) {
            return Optional.of((BlockState)blockState);
        }
        return super.getStateWithData(blockState, manipulator);
    }

    @Override
    public <E> Optional<BlockState> getStateWithValue(IBlockState blockState, Key<? extends BaseValue<E>> key, E value) {
        if (key.equals(Keys.WALL_TYPE)) {
            BlockWall.EnumType wallType = (BlockWall.EnumType)value;
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockWall.field_176255_P, (Comparable)wallType));
        }
        if (key.equals(Keys.CONNECTED_DIRECTIONS) || key.equals(Keys.CONNECTED_EAST) || key.equals(Keys.CONNECTED_NORTH) || key.equals(Keys.CONNECTED_SOUTH) || key.equals(Keys.CONNECTED_WEST)) {
            return Optional.of((BlockState)blockState);
        }
        return super.getStateWithValue(blockState, key, value);
    }

    private ImmutableWallData getWallTypeFor(IBlockState blockState) {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeWallData.class, (WallType)((Object)blockState.func_177229_b((IProperty)BlockWall.field_176255_P)));
    }

    private ImmutableConnectedDirectionData getConnectedDirectionData(IBlockState blockState) {
        HashSet<Direction> directions = new HashSet<Direction>();
        Boolean north = (Boolean)blockState.func_177229_b((IProperty)BlockWall.field_176254_b);
        Boolean east = (Boolean)blockState.func_177229_b((IProperty)BlockWall.field_176257_M);
        Boolean west = (Boolean)blockState.func_177229_b((IProperty)BlockWall.field_176259_O);
        Boolean south = (Boolean)blockState.func_177229_b((IProperty)BlockWall.field_176258_N);
        Boolean up = (Boolean)blockState.func_177229_b((IProperty)BlockWall.field_176256_a);
        if (north.booleanValue()) {
            directions.add(Direction.NORTH);
        }
        if (south.booleanValue()) {
            directions.add(Direction.SOUTH);
        }
        if (west.booleanValue()) {
            directions.add(Direction.WEST);
        }
        if (east.booleanValue()) {
            directions.add(Direction.EAST);
        }
        if (up.booleanValue()) {
            directions.add(Direction.UP);
        }
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeConnectedDirectionData.class, directions);
    }

    @Override
    public Translation getTranslation() {
        return new SpongeTranslation(this.func_149739_a() + "." + BlockWall.EnumType.NORMAL.func_176659_c() + ".name");
    }
}

