/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.entitycollisions;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.config.SpongeConfig;
import org.spongepowered.common.config.category.CollisionModCategory;
import org.spongepowered.common.config.category.EntityCollisionCategory;
import org.spongepowered.common.config.type.GeneralConfigBase;
import org.spongepowered.common.config.type.GlobalConfig;
import org.spongepowered.common.config.type.WorldConfig;
import org.spongepowered.common.entity.SpongeEntityType;
import org.spongepowered.common.interfaces.world.IMixinWorld;
import org.spongepowered.common.interfaces.world.IMixinWorldInfo;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.mixin.plugin.entitycollisions.interfaces.IModData_Collisions;

@Mixin(value={Entity.class}, priority=1002)
public class MixinEntity_Collisions
implements IModData_Collisions {
    private int maxCollisions = 8;
    private boolean refreshCache = false;
    private SpongeEntityType spongeEntityType;
    private String entityName = "unknown";
    private String entityModId = "unknown";
    @Shadow
    public World field_70170_p;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void onEntityConstruction(World world, CallbackInfo ci) {
        if (world != null && !((IMixinWorld)world).isFake() && ((IMixinWorldInfo)world.func_72912_H()).isValid()) {
            EntityType entityType = ((org.spongepowered.api.entity.Entity)((Object)this)).getType();
            if (entityType == EntityTypes.UNKNOWN || !(entityType instanceof SpongeEntityType)) {
                return;
            }
            this.spongeEntityType = (SpongeEntityType)entityType;
            if (this instanceof EntityItem) {
                EntityItem item = (EntityItem)this;
                ItemStack itemstack = item.func_92059_d();
                if (!itemstack.func_190926_b()) {
                    this.entityName = itemstack.func_77977_a().replace("item.", "");
                }
            } else {
                this.entityName = this.spongeEntityType.getName();
            }
            this.entityModId = this.spongeEntityType.getModId();
            if (!this.field_70170_p.field_72995_K) {
                this.initializeCollisionState(this.field_70170_p);
            }
        }
    }

    @Override
    public int getMaxCollisions() {
        return this.maxCollisions;
    }

    @Override
    public void setMaxCollisions(int max) {
        this.maxCollisions = max;
    }

    @Override
    public void setModDataName(String name) {
        this.entityName = name;
    }

    @Override
    public String getModDataName() {
        return this.entityName;
    }

    @Override
    public String getModDataId() {
        return this.entityModId;
    }

    @Override
    public void setModDataId(String id) {
        this.entityModId = id;
    }

    @Override
    public void initializeCollisionState(World worldObj) {
        SpongeConfig<WorldConfig> worldConfig = ((IMixinWorldServer)worldObj).getWorldConfig();
        SpongeConfig<GlobalConfig> globalConfig = SpongeImpl.getGlobalConfig();
        EntityCollisionCategory worldCollCat = ((GeneralConfigBase)worldConfig.getConfig()).getEntityCollisionCategory();
        EntityCollisionCategory globalCollCat = ((GeneralConfigBase)globalConfig.getConfig()).getEntityCollisionCategory();
        this.setMaxCollisions(worldCollCat.getMaxEntitiesWithinAABB());
        boolean requiresSave = false;
        CollisionModCategory worldCollMod = worldCollCat.getModList().get(this.getModDataId());
        CollisionModCategory globalCollMod = globalCollCat.getModList().get(this.getModDataId());
        if (worldCollMod == null && worldCollCat.autoPopulateData()) {
            globalCollMod = new CollisionModCategory(this.getModDataId());
            globalCollCat.getModList().put(this.getModDataId(), globalCollMod);
            globalCollMod.getEntityList().put(this.getModDataName(), this.getMaxCollisions());
            globalConfig.save();
            return;
        }
        if (worldCollMod != null) {
            if (!worldCollMod.isEnabled()) {
                this.setMaxCollisions(-1);
                return;
            }
            Integer modCollisionMax = worldCollMod.getDefaultMaxCollisions().get("entities");
            if (modCollisionMax != null) {
                this.setMaxCollisions(modCollisionMax);
            }
            Integer entityMaxCollision = null;
            if (this instanceof EntityItem) {
                entityMaxCollision = worldCollMod.getEntityList().get(this.getModDataName());
            }
            if (entityMaxCollision == null) {
                entityMaxCollision = worldCollMod.getEntityList().get(this.getModDataName());
            }
            if (entityMaxCollision == null && worldCollCat.autoPopulateData()) {
                globalCollMod.getEntityList().put(this.getModDataName(), this.getMaxCollisions());
                requiresSave = true;
            } else if (entityMaxCollision != null) {
                this.setMaxCollisions(entityMaxCollision);
            }
        }
        if (this.getMaxCollisions() <= 0) {
            return;
        }
        if (requiresSave) {
            globalConfig.save();
        }
    }

    @Override
    public void requiresCollisionsCacheRefresh(boolean flag) {
        this.refreshCache = flag;
    }

    @Override
    public boolean requiresCollisionsCacheRefresh() {
        return this.refreshCache;
    }

    @Override
    public boolean isRunningCollideWithNearby() {
        return false;
    }
}

