/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.plugin.tileentityactivation;

import com.flowpowered.math.vector.Vector3i;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.api.block.tileentity.TileEntityType;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.config.SpongeConfig;
import org.spongepowered.common.config.category.TileEntityActivationCategory;
import org.spongepowered.common.config.category.TileEntityActivationModCategory;
import org.spongepowered.common.config.type.GeneralConfigBase;
import org.spongepowered.common.config.type.GlobalConfig;
import org.spongepowered.common.config.type.WorldConfig;
import org.spongepowered.common.data.type.SpongeTileEntityType;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.block.tile.IMixinTileEntity;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.mixin.plugin.entityactivation.interfaces.IModData_Activation;
import org.spongepowered.common.util.VecHelper;

public class TileEntityActivation {
    public static void initializeTileEntityActivationState(TileEntity tileEntity) {
        if (tileEntity.func_145831_w() == null || tileEntity.func_145831_w().field_72995_K || !(tileEntity instanceof ITickable)) {
            return;
        }
        TileEntityActivationCategory config = ((IMixinWorldServer)tileEntity.func_145831_w()).getWorldConfig().getConfig().getTileEntityActivationRange();
        TileEntityType type = ((org.spongepowered.api.block.tileentity.TileEntity)tileEntity).getType();
        IModData_Activation spongeTileEntity = (IModData_Activation)tileEntity;
        SpongeTileEntityType spongeType = (SpongeTileEntityType)type;
        if (spongeType == null || spongeType.getModId() == null) {
            return;
        }
        TileEntityActivationModCategory tileEntityMod = config.getModList().get(spongeType.getModId().toLowerCase());
        int defaultActivationRange = config.getDefaultBlockRange();
        int defaultTickRate = config.getDefaultTickRate();
        if (tileEntityMod == null) {
            spongeTileEntity.setActivationRange(defaultActivationRange);
            spongeTileEntity.setSpongeTickRate(defaultTickRate);
            if (defaultTickRate <= 0) {
                spongeTileEntity.setDefaultActivationState(false);
            }
            if (defaultActivationRange > 0) {
                spongeTileEntity.setDefaultActivationState(false);
            }
        } else {
            if (!tileEntityMod.isEnabled()) {
                spongeTileEntity.setDefaultActivationState(true);
                return;
            }
            Integer defaultModActivationRange = tileEntityMod.getDefaultBlockRange();
            Integer tileEntityActivationRange = tileEntityMod.getTileEntityRangeList().get(type.getName().toLowerCase());
            if (defaultModActivationRange != null && tileEntityActivationRange == null) {
                spongeTileEntity.setActivationRange(defaultModActivationRange);
                if (defaultModActivationRange > 0) {
                    spongeTileEntity.setDefaultActivationState(false);
                }
            } else if (tileEntityActivationRange != null) {
                spongeTileEntity.setActivationRange(tileEntityActivationRange);
                if (tileEntityActivationRange > 0) {
                    spongeTileEntity.setDefaultActivationState(false);
                }
            }
            Integer defaultModTickRate = tileEntityMod.getDefaultTickRate();
            Integer tileEntityTickRate = tileEntityMod.getTileEntityTickRateList().get(type.getName().toLowerCase());
            if (defaultModTickRate != null && tileEntityTickRate == null) {
                spongeTileEntity.setSpongeTickRate(defaultModTickRate);
                if (defaultModTickRate <= 0) {
                    spongeTileEntity.setDefaultActivationState(false);
                }
            } else if (tileEntityTickRate != null) {
                spongeTileEntity.setSpongeTickRate(tileEntityTickRate);
                if (tileEntityTickRate <= 0) {
                    spongeTileEntity.setDefaultActivationState(false);
                }
            }
        }
    }

    public static void activateTileEntities(WorldServer world) {
        PlayerChunkMap playerChunkMap = world.func_184164_w();
        for (PlayerChunkMapEntry playerChunkMapEntry : playerChunkMap.field_111193_e) {
            for (EntityPlayer player : playerChunkMapEntry.field_187283_c) {
                Chunk chunk = playerChunkMapEntry.field_187286_f;
                if (chunk == null || chunk.field_189550_d || ((IMixinChunk)chunk).isPersistedChunk()) continue;
                TileEntityActivation.activateChunkTileEntities(player, chunk);
            }
        }
    }

    private static void activateChunkTileEntities(EntityPlayer player, Chunk chunk) {
        Vector3i playerPos = VecHelper.toVector3i(player.func_180425_c());
        long currentTick = SpongeImpl.getServer().func_71259_af();
        for (Map.Entry mapEntry : chunk.func_177434_r().entrySet()) {
            TileEntity tileEntity = (TileEntity)mapEntry.getValue();
            IModData_Activation spongeTileEntity = (IModData_Activation)tileEntity;
            if (spongeTileEntity.getSpongeTickRate() <= 0 || !((IMixinTileEntity)tileEntity).shouldTick() || !(tileEntity instanceof ITickable) || spongeTileEntity.getActivatedTick() == currentTick) continue;
            Vector3i tilePos = VecHelper.toVector3i(tileEntity.func_174877_v());
            if (currentTick <= ((IModData_Activation)tileEntity).getActivatedTick()) continue;
            if (spongeTileEntity.getDefaultActivationState()) {
                ((IModData_Activation)tileEntity).setActivatedTick(currentTick);
                continue;
            }
            if (spongeTileEntity.requiresActivationCacheRefresh()) {
                TileEntityActivation.initializeTileEntityActivationState(tileEntity);
                spongeTileEntity.requiresActivationCacheRefresh(false);
            }
            int bbActivationRange = ((IModData_Activation)tileEntity).getActivationRange();
            int blockDistance = Math.round(tilePos.distance(playerPos));
            if (blockDistance > bbActivationRange) continue;
            ((IModData_Activation)tileEntity).setActivatedTick(currentTick);
        }
    }

    public static boolean checkIfActive(TileEntity tileEntity) {
        boolean isActive;
        if (tileEntity.func_145831_w() == null || tileEntity.func_145831_w().field_72995_K || !(tileEntity instanceof ITickable)) {
            return true;
        }
        World world = tileEntity.func_145831_w();
        IMixinChunk activeChunk = ((IMixinTileEntity)tileEntity).getActiveChunk();
        if (activeChunk == null) {
            return true;
        }
        if (!activeChunk.isActive()) {
            return false;
        }
        long currentTick = SpongeImpl.getServer().func_71259_af();
        IModData_Activation spongeTileEntity = (IModData_Activation)tileEntity;
        boolean bl = isActive = activeChunk.isPersistedChunk() || spongeTileEntity.getActivatedTick() >= currentTick || spongeTileEntity.getDefaultActivationState();
        if (!isActive && spongeTileEntity.getActivatedTick() == Integer.MIN_VALUE) {
            return false;
        }
        if (isActive && world.func_72912_H().func_82573_f() % (long)spongeTileEntity.getSpongeTickRate() != 0L) {
            isActive = false;
        }
        return isActive;
    }

    public static void addTileEntityToConfig(World world, SpongeTileEntityType type) {
        SpongeConfig<WorldConfig> worldConfig = ((IMixinWorldServer)world).getWorldConfig();
        SpongeConfig<GlobalConfig> globalConfig = SpongeImpl.getGlobalConfig();
        if (worldConfig == null || globalConfig == null || type == null || !((GeneralConfigBase)worldConfig.getConfig()).getTileEntityActivationRange().autoPopulateData()) {
            return;
        }
        boolean requiresSave = false;
        String tileModId = type.getModId().toLowerCase();
        TileEntityActivationCategory activationCategory = ((GeneralConfigBase)globalConfig.getConfig()).getTileEntityActivationRange();
        TileEntityActivationModCategory tileEntityMod = activationCategory.getModList().get(tileModId);
        int defaultRange = activationCategory.getDefaultBlockRange();
        int defaultTickRate = activationCategory.getDefaultTickRate();
        if (tileEntityMod == null) {
            tileEntityMod = new TileEntityActivationModCategory(tileModId);
            activationCategory.getModList().put(tileModId, tileEntityMod);
            requiresSave = true;
        }
        if (tileEntityMod != null) {
            Integer tileEntityActivationTickRate;
            Integer modDefaultTickRate;
            String tileId = type.getName().toLowerCase();
            Integer tileEntityActivationRange = tileEntityMod.getTileEntityRangeList().get(tileId);
            Integer modDefaultRange = tileEntityMod.getDefaultBlockRange();
            if (modDefaultRange == null) {
                modDefaultRange = defaultRange;
            }
            if (tileEntityActivationRange == null) {
                tileEntityMod.getTileEntityRangeList().put(tileId, modDefaultRange);
                requiresSave = true;
            }
            if ((modDefaultTickRate = tileEntityMod.getDefaultTickRate()) == null) {
                modDefaultTickRate = defaultTickRate;
            }
            if ((tileEntityActivationTickRate = tileEntityMod.getTileEntityTickRateList().get(tileId)) == null) {
                tileEntityMod.getTileEntityTickRateList().put(tileId, modDefaultTickRate);
                requiresSave = true;
            }
        }
        if (requiresSave) {
            globalConfig.save();
        }
    }
}

