/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Locale;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.util.ITickable;
import org.spongepowered.api.block.tileentity.TileEntityType;
import org.spongepowered.api.block.tileentity.TileEntityTypes;
import org.spongepowered.api.registry.ExtraClassCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.data.type.SpongeTileEntityType;
import org.spongepowered.common.registry.SpongeAdditionalCatalogRegistryModule;
import org.spongepowered.common.registry.type.AbstractPrefixAlternateCatalogTypeRegistryModule;

@RegisterCatalog(value=TileEntityTypes.class)
public final class TileEntityTypeRegistryModule
extends AbstractPrefixAlternateCatalogTypeRegistryModule<TileEntityType>
implements ExtraClassCatalogRegistryModule<TileEntityType, TileEntity>,
SpongeAdditionalCatalogRegistryModule<TileEntityType> {
    private static final Map<String, String> NAME_TO_ID_MAPPING = ImmutableMap.builder().put((Object)"enchanting_table", (Object)"enchantment_table").put((Object)"noteblock", (Object)"note").put((Object)"EndGateway", (Object)"end_gateway").build();
    private final Map<Class<? extends TileEntity>, TileEntityType> tileClassToTypeMappings = Maps.newHashMap();

    public static TileEntityTypeRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public boolean allowsApiRegistration() {
        return false;
    }

    @Override
    public void registerAdditionalCatalog(TileEntityType extraCatalog) {
        this.tileClassToTypeMappings.put(extraCatalog.getTileEntityType(), extraCatalog);
        this.catalogTypeMap.put(extraCatalog.getId().toLowerCase(Locale.ENGLISH), extraCatalog);
    }

    @Override
    public boolean hasRegistrationFor(Class<? extends TileEntity> mappedClass) {
        return this.tileClassToTypeMappings.containsKey(mappedClass);
    }

    @Override
    public TileEntityType getForClass(Class<? extends TileEntity> clazz) {
        return this.tileClassToTypeMappings.get(clazz);
    }

    @Override
    public void registerDefaults() {
        try {
            Class.forName("net.minecraft.tileentity.TileEntity");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public String getIdForName(String name) {
        String id = NAME_TO_ID_MAPPING.get(name);
        return id == null ? name : id;
    }

    public TileEntityType doTileEntityRegistration(Class<?> clazz, String name) {
        String id = TileEntityTypeRegistryModule.getInstance().getIdForName(name);
        boolean canTick = true;
        try {
            String mapping;
            Class<?> declaringClazz;
            if (ITickable.class.isAssignableFrom(clazz) && ((declaringClazz = clazz.getMethod(mapping = SpongeImplHooks.isDeobfuscatedEnvironment() ? "update" : "func_73660_a", new Class[0]).getDeclaringClass()).equals(TileEntityChest.class) || declaringClazz.equals(TileEntityEnderChest.class))) {
                canTick = false;
            }
        }
        catch (Throwable mapping) {
            // empty catch block
        }
        String modId = SpongeImplHooks.getModIdFromClass(clazz);
        String tileId = modId + ":" + id;
        SpongeTileEntityType tileEntityType = new SpongeTileEntityType(clazz, name, tileId, canTick, modId);
        TileEntityTypeRegistryModule.getInstance().registerAdditionalCatalog(tileEntityType);
        return tileEntityType;
    }

    TileEntityTypeRegistryModule() {
        super("minecraft", new String[]{"minecraft:"}, string -> string.equals("noteblock") ? "note" : (string.equals("enchanting_table") ? "enchantment_table" : (string.equals("structure_block") ? "structure" : string)));
    }

    private static final class Holder {
        static final TileEntityTypeRegistryModule INSTANCE = new TileEntityTypeRegistryModule();

        private Holder() {
        }
    }
}

