/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MapMaker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.Entity;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.registry.AdditionalCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.util.TypeTokens;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.data.SpongeKey;
import org.spongepowered.common.data.datasync.DataParameterConverter;
import org.spongepowered.common.data.datasync.entity.EntityAirConverter;
import org.spongepowered.common.data.datasync.entity.EntityBabyConverter;
import org.spongepowered.common.data.datasync.entity.EntityCustomNameConverter;
import org.spongepowered.common.data.datasync.entity.EntityCustomNameVisibleConverter;
import org.spongepowered.common.data.datasync.entity.EntityFlagsConverter;
import org.spongepowered.common.data.datasync.entity.EntityNoGravityConverter;
import org.spongepowered.common.data.datasync.entity.EntitySilentConverter;

public class KeyRegistryModule
implements AdditionalCatalogRegistryModule<Key<?>> {
    @RegisterCatalog(value=Keys.class)
    private final Map<String, Key<?>> fieldMap = new MapMaker().concurrencyLevel(4).makeMap();
    private final Map<String, Key<?>> keyMap = new MapMaker().concurrencyLevel(4).makeMap();
    private static final ConcurrentHashMap<Class<?>, List<DataParameterConverter<?>>> LOADED_CLASSES = new ConcurrentHashMap();
    private static final Map<Class<? extends Entity>, Callable<List<DataParameterConverter<?>>>> DATA_PARAMETER_FUNCTION_GETTERS = ImmutableMap.builder().put(Entity.class, () -> {
        ArrayList<DataParameterConverter> objects = new ArrayList<DataParameterConverter>();
        objects.add(new EntityFlagsConverter());
        objects.add(new EntityCustomNameVisibleConverter());
        objects.add(new EntitySilentConverter());
        objects.add(new EntityAirConverter());
        objects.add(new EntityCustomNameConverter());
        objects.add(new EntityNoGravityConverter());
        objects.add(new EntityBabyConverter());
        return objects;
    }).build();

    public static KeyRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public void registerDefaults() {
        Preconditions.checkState((!SpongeDataManager.areRegistrationsComplete() ? 1 : 0) != 0, (Object)"Attempting to register Keys illegally!");
        Sponge.getCauseStackManager().pushCause(SpongeImpl.getPlugin());
        this.register("axis", (Key<?>)Key.builder().type(TypeTokens.AXIS_VALUE_TOKEN).id("axis").name("Axis").query(DataQuery.of("Axis")).build());
        this.register("color", (Key<?>)Key.builder().type(TypeTokens.COLOR_VALUE_TOKEN).id("color").name("Color").query(DataQuery.of("Color")).build());
        this.register("health", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_DOUBLE_VALUE_TOKEN).id("health").name("Health").query(DataQuery.of("Health")).build());
        this.register("max_health", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_DOUBLE_VALUE_TOKEN).id("max_health").name("Max Health").query(DataQuery.of("MaxHealth")).build());
        this.register("display_name", (Key<?>)Key.builder().type(TypeTokens.TEXT_VALUE_TOKEN).id("display_name").name("Display Name").query(DataQuery.of("DisplayName")).build());
        this.register("career", (Key<?>)Key.builder().type(TypeTokens.CAREER_VALUE_TOKEN).id("career").name("Career").query(DataQuery.of("Career")).build());
        this.register("sign_lines", (Key<?>)Key.builder().type(TypeTokens.LIST_TEXT_VALUE_TOKEN).id("sign_lines").name("Sign Lines").query(DataQuery.of("SignLines")).build());
        this.register("skull_type", (Key<?>)Key.builder().type(TypeTokens.SKULL_VALUE_TOKEN).id("skull_type").name("Skull Type").query(DataQuery.of("SkullType")).build());
        this.register("is_sneaking", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("sneaking").name("Is Sneaking").query(DataQuery.of("IsSneaking")).build());
        this.register("velocity", (Key<?>)Key.builder().type(TypeTokens.VECTOR_3D_VALUE_TOKEN).id("velocity").name("Velocity").query(DataQuery.of("Velocity")).build());
        this.register("food_level", (Key<?>)Key.builder().type(TypeTokens.INTEGER_VALUE_TOKEN).id("food_level").name("Food Level").query(DataQuery.of("FoodLevel")).build());
        this.register("saturation", (Key<?>)Key.builder().type(TypeTokens.DOUBLE_VALUE_TOKEN).id("food_saturation_level").name("Food Saturation Level").query(DataQuery.of("FoodSaturationLevel")).build());
        this.register("exhaustion", (Key<?>)Key.builder().type(TypeTokens.DOUBLE_VALUE_TOKEN).id("food_exhaustion_level").name("Food Exhaustion Level").query(DataQuery.of("FoodExhaustionLevel")).build());
        this.register("max_air", (Key<?>)Key.builder().type(TypeTokens.INTEGER_VALUE_TOKEN).id("max_air").name("Max Air").query(DataQuery.of("MaxAir")).build());
        this.register("remaining_air", (Key<?>)Key.builder().type(TypeTokens.INTEGER_VALUE_TOKEN).id("remaining_air").name("Remaining Air").query(DataQuery.of("RemainingAir")).build());
        this.register("fire_ticks", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN).id("fire_ticks").name("Fire Ticks").query(DataQuery.of("FireTicks")).build());
        this.register("fire_damage_delay", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN).id("fire_damage_delay").name("Fire Damage Delay").query(DataQuery.of("FireDamageDelay")).build());
        this.register("game_mode", (Key<?>)Key.builder().type(TypeTokens.GAME_MODE_VALUE_TOKEN).id("game_mode").name("Game Mode").query(DataQuery.of("GameMode")).build());
        this.register("is_screaming", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("screaming").name("Is Screaming").query(DataQuery.of("IsScreaming")).build());
        this.register("can_fly", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("can_fly").name("Can Fly").query(DataQuery.of("CanFly")).build());
        this.register("can_grief", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("can_grief").name("Can Grief").query(DataQuery.of("CanGrief")).build());
        this.register("shrub_type", (Key<?>)Key.builder().type(TypeTokens.SHRUB_VALUE_TOKEN).id("shrub_type").name("Shrub Type").query(DataQuery.of("ShrubType")).build());
        this.register("plant_type", (Key<?>)Key.builder().type(TypeTokens.PLANT_VALUE_TOKEN).id("plant_type").name("Plant Type").query(DataQuery.of("PlantType")).build());
        this.register("tree_type", (Key<?>)Key.builder().type(TypeTokens.TREE_VALUE_TOKEN).id("tree_type").name("Tree Type").query(DataQuery.of("TreeType")).build());
        this.register("log_axis", (Key<?>)Key.builder().type(TypeTokens.LOG_AXIS_VALUE_TOKEN).id("log_axis").name("Log Axis").query(DataQuery.of("LogAxis")).build());
        this.register("invisible", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("invisible").name("Invisible").query(DataQuery.of("Invisible")).build());
        this.register("vanish", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("vanish").name("Vanish").query(DataQuery.of("Vanish")).build());
        this.register("invisible", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("invisible").name("Invisible").query(DataQuery.of("Invisible")).build());
        this.register("powered", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("powered").name("Powered").query(DataQuery.of("Powered")).build());
        this.register("layer", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN).id("layer").name("Layer").query(DataQuery.of("Layer")).build());
        this.register("represented_item", (Key<?>)Key.builder().type(TypeTokens.ITEM_SNAPSHOT_VALUE_TOKEN).id("item_stack_snapshot").name("Item Stack Snapshot").query(DataQuery.of("ItemStackSnapshot")).build());
        this.register("command", (Key<?>)Key.builder().type(TypeTokens.STRING_VALUE_TOKEN).id("command").name("Command").query(DataQuery.of("Command")).build());
        this.register("success_count", (Key<?>)Key.builder().type(TypeTokens.INTEGER_VALUE_TOKEN).id("success_count").name("SuccessCount").query(DataQuery.of("SuccessCount")).build());
        this.register("tracks_output", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("tracks_output").name("Tracks Output").query(DataQuery.of("TracksOutput")).build());
        this.register("last_command_output", (Key<?>)Key.builder().type(TypeTokens.OPTIONAL_TEXT_VALUE_TOKEN).id("last_command_output").name("Last Command Output").query(DataQuery.of("LastCommandOutput")).build());
        this.register("trade_offers", (Key<?>)Key.builder().type(TypeTokens.LIST_VALUE_TRADE_OFFER_TOKEN).id("trade_offers").name("Trade Offers").query(DataQuery.of("TradeOffers")).build());
        this.register("dye_color", (Key<?>)Key.builder().type(TypeTokens.DYE_COLOR_VALUE_TOKEN).id("dye_color").name("Dye Color").query(DataQuery.of("DyeColor")).build());
        this.register("firework_flight_modifier", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN).id("flight_modifier").name("Flight Modifier").query(DataQuery.of("FlightModifier")).build());
        this.register("firework_effects", (Key<?>)Key.builder().type(TypeTokens.LIST_VALUE_FIREWORK_TOKEN).id("firework_effects").name("Firework Effects").query(DataQuery.of("FireworkEffects")).build());
        this.register("spawner_entities", (Key<?>)Key.builder().type(TypeTokens.WEIGHTED_ENTITY_ARCHETYPE_COLLECTION_VALUE_TOKEN).id("spawner_entities").name("Spawner Entities").query(DataQuery.of("SpawnerEntities")).build());
        this.register("spawner_maximum_delay", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_SHORT_VALUE_TOKEN).id("spawner_maximum_delay").name("Spawner Maximum Delay").query(DataQuery.of("SpawnerMaximumDelay")).build());
        this.register("spawner_maximum_nearby_entities", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_SHORT_VALUE_TOKEN).id("spawner_maximum_nearby_entities").name("Spawner Maximum Nearby Entities").query(DataQuery.of("SpawnerMaximumNearbyEntities")).build());
        this.register("spawner_minimum_delay", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_SHORT_VALUE_TOKEN).id("spawner_minimum_delay").name("Spawner Minimum Delay").query(DataQuery.of("SpawnerMinimumDelay")).build());
        this.register("spawner_next_entity_to_spawn", (Key<?>)Key.builder().type(TypeTokens.WEIGHTED_ENTITY_ARCHETYPE_VALUE_TOKEN).id("spawner_next_entity_to_spawn").name("Spawner Next Entity To Spawn").query(DataQuery.of("SpawnerNextEntityToSpawn")).build());
        this.register("spawner_remaining_delay", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_SHORT_VALUE_TOKEN).id("spawner_remaining_delay").name("Spawner Remaining Delay").query(DataQuery.of("SpawnerRemainingDelay")).build());
        this.register("spawner_required_player_range", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_SHORT_VALUE_TOKEN).id("spawner_required_player_range").name("Spawner Required Player Range").query(DataQuery.of("SpawnerRequiredPlayerRange")).build());
        this.register("spawner_spawn_count", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_SHORT_VALUE_TOKEN).id("spawner_spawn_count").name("Spawner Spawn Count").query(DataQuery.of("SpawnerSpawnCount")).build());
        this.register("spawner_spawn_range", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_SHORT_VALUE_TOKEN).id("spawner_spawn_range").name("Spawner Spawn Range").query(DataQuery.of("SpawnerSpawnRange")).build());
        this.register("connected_directions", (Key<?>)Key.builder().type(TypeTokens.SET_DIRECTION_VALUE_TOKEN).id("connected_directions").name("Connected Directions").query(DataQuery.of("ConnectedDirections")).build());
        this.register("connected_north", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("connected_north").name("Connected North").query(DataQuery.of("ConnectedNorth")).build());
        this.register("connected_south", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("connected_south").name("Connected South").query(DataQuery.of("ConnectedSouth")).build());
        this.register("connected_east", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("connected_east").name("Connected East").query(DataQuery.of("ConnectedEast")).build());
        this.register("connected_west", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("connected_west").name("Connected West").query(DataQuery.of("ConnectedWest")).build());
        this.register("direction", (Key<?>)Key.builder().type(TypeTokens.DIRECTION_VALUE_TOKEN).id("direction").name("Direction").query(DataQuery.of("Direction")).build());
        this.register("dirt_type", (Key<?>)Key.builder().type(TypeTokens.DIRT_VALUE_TOKEN).id("dirt_type").name("Dirt Type").query(DataQuery.of("DirtType")).build());
        this.register("disguised_block_type", (Key<?>)Key.builder().type(TypeTokens.DISGUISED_BLOCK_VALUE_TOKEN).id("disguised_block_type").name("Disguised Block Type").query(DataQuery.of("DisguisedBlockType")).build());
        this.register("disarmed", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("disarmed").name("Disarmed").query(DataQuery.of("Disarmed")).build());
        this.register("item_enchantments", (Key<?>)Key.builder().type(TypeTokens.LIST_ENCHANTMENT_VALUE_TOKEN).id("item_enchantments").name("Item EnchantmentTypes").query(DataQuery.of("ItemEnchantments")).build());
        this.register("banner_patterns", (Key<?>)Key.builder().type(TypeTokens.LIST_PATTERN_VALUE_TOKEN).id("banner_patterns").name("Banner Patterns").query(DataQuery.of("BannerPatterns")).build());
        this.register("banner_base_color", (Key<?>)Key.builder().type(TypeTokens.LIST_DYE_COLOR_VALUE_TOKEN).id("banner_base_color").name("Banner Base Color").query(DataQuery.of("BannerBaseColor")).build());
        this.register("horse_color", (Key<?>)Key.builder().type(TypeTokens.HORSE_COLOR_VALUE_TOKEN).id("horse_color").name("Horse Color").query(DataQuery.of("HorseColor")).build());
        this.register("horse_style", (Key<?>)Key.builder().type(TypeTokens.HORSE_STYLE_VALUE_TOKEN).id("horse_style").name("Horse Style").query(DataQuery.of("HorseStyle")).build());
        this.register("item_lore", (Key<?>)Key.builder().type(TypeTokens.LIST_TEXT_VALUE_TOKEN).id("item_lore").name("Item Lore").query(DataQuery.of("ItemLore")).build());
        this.register("book_pages", (Key<?>)Key.builder().type(TypeTokens.LIST_TEXT_VALUE_TOKEN).id("book_pages").name("Book Pages").query(DataQuery.of("BookPages")).build());
        this.register("plain_book_pages", (Key<?>)Key.builder().type(TypeTokens.LIST_STRING_VALUE_TOKEN).id("plain_book_pages").name("Plain Book Pages").query(DataQuery.of("PlainBookPages")).build());
        this.register("golden_apple_type", (Key<?>)Key.builder().type(TypeTokens.GOLDEN_APPLE_VALUE_TOKEN).id("golden_apple_type").name("Golden Apple Type").query(DataQuery.of("GoldenAppleType")).build());
        this.register("is_flying", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("is_flying").name("Is Flying").query(DataQuery.of("IsFlying")).build());
        this.register("experience_level", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN).id("experience_level").name("Experience Level").query(DataQuery.of("ExperienceLevel")).build());
        this.register("total_experience", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN).id("total_experience").name("Total Experience").query(DataQuery.of("TotalExperience")).build());
        this.register("experience_since_level", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN).id("experience_since_level").name("Experience Since Level").query(DataQuery.of("ExperienceSinceLevel")).build());
        this.register("experience_from_start_of_level", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN).id("experience_from_start_of_level").name("Experience From Start Of Level").query(DataQuery.of("ExperienceFromStartOfLevel")).build());
        this.register("book_author", (Key<?>)Key.builder().type(TypeTokens.TEXT_VALUE_TOKEN).id("book_author").name("Book Author").query(DataQuery.of("BookAuthor")).build());
        this.register("breakable_block_types", (Key<?>)Key.builder().type(TypeTokens.SET_BLOCK_VALUE_TOKEN).id("can_destroy").name("Can Destroy").query(DataQuery.of("CanDestroy")).build());
        this.register("placeable_blocks", (Key<?>)Key.builder().type(TypeTokens.SET_BLOCK_VALUE_TOKEN).id("can_place_on").name("Can Place On").query(DataQuery.of("CanPlaceOn")).build());
        this.register("walking_speed", (Key<?>)Key.builder().type(TypeTokens.DOUBLE_VALUE_TOKEN).id("walking_speed").name("Walking Speed").query(DataQuery.of("WalkingSpeed")).build());
        this.register("flying_speed", (Key<?>)Key.builder().type(TypeTokens.DOUBLE_VALUE_TOKEN).id("flying_speed").name("Flying Speed").query(DataQuery.of("FlyingSpeed")).build());
        this.register("slime_size", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN).id("slime_size").name("Slime Size").query(DataQuery.of("SlimeSize")).build());
        this.register("villager_zombie_profession", (Key<?>)Key.builder().type(TypeTokens.OPTIONAL_PROFESSION_VALUE_TOKEN).id("villager_zombie_profession").name("Villager Zombie Profession").query(DataQuery.of("VillagerZombieProfession")).build());
        this.register("is_playing", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("is_playing").name("Is Playing").query(DataQuery.of("IsPlaying")).build());
        this.register("is_sitting", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("is_sitting").name("Is Sitting").query(DataQuery.of("IsSitting")).build());
        this.register("is_sheared", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("is_sheared").name("Is Sheared").query(DataQuery.of("IsSheared")).build());
        this.register("pig_saddle", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("is_pig_saddled").name("Is Pig Saddled").query(DataQuery.of("IsPigSaddled")).build());
        this.register("tamed_owner", (Key<?>)Key.builder().type(TypeTokens.OPTIONAL_UUID_VALUE_TOKEN).id("tamer_uuid").name("Tamer UUID").query(DataQuery.of("TamerUUID")).build());
        this.register("is_wet", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("is_wet").name("Is Wet").query(DataQuery.of("IsWet")).build());
        this.register("elder_guardian", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("elder").name("Elder").query(DataQuery.of("Elder")).build());
        this.register("coal_type", (Key<?>)Key.builder().type(TypeTokens.COAL_VALUE_TOKEN).id("coal_type").name("Coal Type").query(DataQuery.of("CoalType")).build());
        this.register("cooked_fish", (Key<?>)Key.builder().type(TypeTokens.COOKED_FISH_VALUE_TOKEN).id("cooked_fish_type").name("Cooked Fish Type").query(DataQuery.of("CookedFishType")).build());
        this.register("fish_type", (Key<?>)Key.builder().type(TypeTokens.FISH_VALUE_TOKEN).id("raw_fish_type").name("Raw Fish Type").query(DataQuery.of("RawFishType")).build());
        this.register("represented_player", (Key<?>)Key.builder().type(TypeTokens.GAME_PROFILE_VALUE_TOKEN).id("represented_player").name("Represented Player").query(DataQuery.of("RepresentedPlayer")).build());
        this.register("passed_burn_time", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN).id("passed_burn_time").name("Passed Burn Time").query(DataQuery.of("PassedBurnTime")).build());
        this.register("max_burn_time", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN).id("max_burn_time").name("Max Burn Time").query(DataQuery.of("MaxBurnTime")).build());
        this.register("passed_cook_time", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN).id("passed_cook_time").name("Passed Cook Time").query(DataQuery.of("PassedCookTime")).build());
        this.register("max_cook_time", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN).id("max_cook_time").name("Max Cook Time").query(DataQuery.of("MaxCookTime")).build());
        this.register("contained_experience", (Key<?>)Key.builder().type(TypeTokens.INTEGER_VALUE_TOKEN).id("contained_experience").name("Contained Experience").query(DataQuery.of("ContainedExperience")).build());
        this.register("remaining_brew_time", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN).id("remaining_brew_time").name("Remaining Brew Time").query(DataQuery.of("RemainingBrewTime")).build());
        this.register("stone_type", (Key<?>)Key.builder().type(TypeTokens.STONE_VALUE_TOKEN).id("stone_type").name("Stone Type").query(DataQuery.of("StoneType")).build());
        this.register("prismarine_type", (Key<?>)Key.builder().type(TypeTokens.PRISMARINE_VALUE_TOKEN).id("prismarine_type").name("Prismarine Type").query(DataQuery.of("PrismarineType")).build());
        this.register("brick_type", (Key<?>)Key.builder().type(TypeTokens.BRICK_VALUE_TOKEN).id("brick_type").name("Brick Type").query(DataQuery.of("BrickType")).build());
        this.register("quartz_type", (Key<?>)Key.builder().type(TypeTokens.QUARTZ_VALUE_TOKEN).id("quartz_type").name("Quartz Type").query(DataQuery.of("QuartzType")).build());
        this.register("sand_type", (Key<?>)Key.builder().type(TypeTokens.SAND_VALUE_TOKEN).id("sand_type").name("Sand Type").query(DataQuery.of("SandType")).build());
        this.register("sandstone_type", (Key<?>)Key.builder().type(TypeTokens.SAND_STONE_VALUE_TOKEN).id("sandstone_type").name("Sandstone Type").query(DataQuery.of("SandstoneType")).build());
        this.register("slab_type", (Key<?>)Key.builder().type(TypeTokens.SLAB_VALUE_TOKEN).id("slab_type").name("Slab Type").query(DataQuery.of("SlabType")).build());
        this.register("sandstone_type", (Key<?>)Key.builder().type(TypeTokens.SAND_STONE_VALUE_TOKEN).id("sandstone_type").name("Sandstone Type").query(DataQuery.of("SandstoneType")).build());
        this.register("comparator_type", (Key<?>)Key.builder().type(TypeTokens.COMPARATOR_VALUE_TOKEN).id("comparator_type").name("Comparator Type").query(DataQuery.of("ComparatorType")).build());
        this.register("hinge_position", (Key<?>)Key.builder().type(TypeTokens.HINGE_VALUE_TOKEN).id("hinge_position").name("Hinge Position").query(DataQuery.of("HingePosition")).build());
        this.register("piston_type", (Key<?>)Key.builder().type(TypeTokens.PISTON_VALUE_TOKEN).id("piston_type").name("Piston Type").query(DataQuery.of("PistonType")).build());
        this.register("portion_type", (Key<?>)Key.builder().type(TypeTokens.PORTION_VALUE_TOKEN).id("portion_type").name("Portion Type").query(DataQuery.of("PortionType")).build());
        this.register("rail_direction", (Key<?>)Key.builder().type(TypeTokens.RAIL_VALUE_TOKEN).id("rail_direction").name("Rail Direction").query(DataQuery.of("RailDirection")).build());
        this.register("stair_shape", (Key<?>)Key.builder().type(TypeTokens.STAIR_VALUE_TOKEN).id("stair_shape").name("Stair Shape").query(DataQuery.of("StairShape")).build());
        this.register("wall_type", (Key<?>)Key.builder().type(TypeTokens.WALL_VALUE_TOKEN).id("wall_type").name("Wall Type").query(DataQuery.of("WallType")).build());
        this.register("double_plant_type", (Key<?>)Key.builder().type(TypeTokens.DOUBLE_PLANT_VALUE_TOKEN).id("double_plant_type").name("Double Plant Type").query(DataQuery.of("DoublePlantType")).build());
        this.register("big_mushroom_type", (Key<?>)Key.builder().type(TypeTokens.MUSHROOM_VALUE_TOKEN).id("big_mushroom_type").name("Big Mushroom Type").query(DataQuery.of("BigMushroomType")).build());
        this.register("ai_enabled", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("is_ai_enabled").name("Is Ai Enabled").query(DataQuery.of("IsAiEnabled")).build());
        this.register("creeper_charged", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("is_creeper_charged").name("Is Creeper Charged").query(DataQuery.of("IsCreeperCharged")).build());
        this.register("item_durability", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN).id("item_durability").name("Item Durability").query(DataQuery.of("ItemDurability")).build());
        this.register("unbreakable", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("unbreakable").name("Unbreakable").query(DataQuery.of("Unbreakable")).build());
        this.register("spawnable_entity_type", (Key<?>)Key.builder().type(TypeTokens.ENTITY_TYPE_VALUE_TOKEN).id("spawnable_entity_type").name("Spawnable Entity Type").query(DataQuery.of("SpawnableEntityType")).build());
        this.register("fall_distance", (Key<?>)Key.builder().type(TypeTokens.FLOAT_VALUE_TOKEN).id("fall_distance").name("Fall Distance").query(DataQuery.of("FallDistance")).build());
        this.register("cooldown", (Key<?>)Key.builder().type(TypeTokens.INTEGER_VALUE_TOKEN).id("cooldown").name("Cooldown").query(DataQuery.of("Cooldown")).build());
        this.register("note_pitch", (Key<?>)Key.builder().type(TypeTokens.NOTE_VALUE_TOKEN).id("note").name("Note").query(DataQuery.of("Note")).build());
        this.register("vehicle", (Key<?>)Key.builder().type(TypeTokens.ENTITY_VALUE_TOKEN).id("vehicle").name("Vehicle").query(DataQuery.of("Vehicle")).build());
        this.register("base_vehicle", (Key<?>)Key.builder().type(TypeTokens.ENTITY_VALUE_TOKEN).id("base_vehicle").name("Base Vehicle").query(DataQuery.of("BaseVehicle")).build());
        this.register("art", (Key<?>)Key.builder().type(TypeTokens.ART_VALUE_TOKEN).id("art").name("Art").query(DataQuery.of("Art")).build());
        this.register("fall_damage_per_block", (Key<?>)Key.builder().type(TypeTokens.DOUBLE_VALUE_TOKEN).id("fall_damage_per_block").name("Fall Damage Per Block").query(DataQuery.of("FallDamagePerBlock")).build());
        this.register("max_fall_damage", (Key<?>)Key.builder().type(TypeTokens.DOUBLE_VALUE_TOKEN).id("max_fall_damage").name("Max Fall Damage").query(DataQuery.of("MaxFallDamage")).build());
        this.register("falling_block_state", (Key<?>)Key.builder().type(TypeTokens.BLOCK_VALUE_TOKEN).id("falling_block_state").name("Falling Block State").query(DataQuery.of("FallingBlockState")).build());
        this.register("can_place_as_block", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("can_place_as_block").name("Can Place As Block").query(DataQuery.of("CanPlaceAsBlock")).build());
        this.register("can_drop_as_item", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("can_drop_as_item").name("Can Drop As Item").query(DataQuery.of("CanDropAsItem")).build());
        this.register("fall_time", (Key<?>)Key.builder().type(TypeTokens.INTEGER_VALUE_TOKEN).id("fall_time").name("Fall Time").query(DataQuery.of("FallTime")).build());
        this.register("falling_block_can_hurt_entities", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("can_falling_block_hurt_entities").name("Can Falling Block Hurt Entities").query(DataQuery.of("CanFallingBlockHurtEntities")).build());
        this.register("represented_block", (Key<?>)Key.builder().type(TypeTokens.BLOCK_VALUE_TOKEN).id("represented_block").name("Represented Block").query(DataQuery.of("RepresentedBlock")).build());
        this.register("offset", (Key<?>)Key.builder().type(TypeTokens.INTEGER_VALUE_TOKEN).id("block_offset").name("Block Offset").query(DataQuery.of("BlockOffset")).build());
        this.register("attached", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("attached").name("Attached").query(DataQuery.of("Attached")).build());
        this.register("should_drop", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("should_drop").name("Should Drop").query(DataQuery.of("ShouldDrop")).build());
        this.register("extended", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("extended").name("Extended").query(DataQuery.of("Extended")).build());
        this.register("growth_stage", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN).id("growth_stage").name("Growth Stage").query(DataQuery.of("GrowthStage")).build());
        this.register("open", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("open").name("Open").query(DataQuery.of("Open")).build());
        this.register("power", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN).id("power").name("Power").query(DataQuery.of("Power")).build());
        this.register("seamless", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("seamless").name("Seamless").query(DataQuery.of("Seamless")).build());
        this.register("snowed", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("snowed").name("Snowed").query(DataQuery.of("Snowed")).build());
        this.register("suspended", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("suspended").name("Suspended").query(DataQuery.of("Suspended")).build());
        this.register("occupied", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("occupied").name("Occupied").query(DataQuery.of("Occupied")).build());
        this.register("decayable", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("decayable").name("Decayable").query(DataQuery.of("Decayable")).build());
        this.register("in_wall", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("in_wall").name("In Wall").query(DataQuery.of("InWall")).build());
        this.register("delay", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN).id("delay").name("Delay").query(DataQuery.of("Delay")).build());
        this.register("player_created", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("player_created").name("Player Created").query(DataQuery.of("PlayerCreated")).build());
        this.register("item_blockstate", (Key<?>)Key.builder().type(TypeTokens.BLOCK_VALUE_TOKEN).id("item_block_state").name("Item Block State").query(DataQuery.of("ItemBlockState")).build());
        this.register("ocelot_type", (Key<?>)Key.builder().type(TypeTokens.OCELOT_VALUE_TOKEN).id("ocelot_type").name("Ocelot Type").query(DataQuery.of("OcelotType")).build());
        this.register("rabbit_type", (Key<?>)Key.builder().type(TypeTokens.RABBIT_VALUE_TOKEN).id("rabbit_type").name("Rabbit Type").query(DataQuery.of("RabbitType")).build());
        this.register("parrot_variant", (Key<?>)Key.builder().type(TypeTokens.PARROT_VARIANT_VALUE_TOKEN).id("parrot_variant").name("Parrot Variant").query(DataQuery.of("ParrotVariant")).build());
        this.register("lock_token", (Key<?>)Key.builder().type(TypeTokens.STRING_VALUE_TOKEN).id("lock").name("Lock").query(DataQuery.of("Lock")).build());
        this.register("banner_base_color", (Key<?>)Key.builder().type(TypeTokens.DYE_COLOR_VALUE_TOKEN).id("banner_base_color").name("Banner Base Color").query(DataQuery.of("BannerBaseColor")).build());
        this.register("banner_patterns", (Key<?>)Key.builder().type(TypeTokens.PATTERN_LIST_VALUE_TOKEN).id("banner_patterns").name("Banner Patterns").query(DataQuery.of("BannerPatterns")).build());
        this.register("respawn_locations", (Key<?>)Key.builder().type(TypeTokens.MAP_UUID_VECTOR3D_VALUE_TOKEN).id("respawn_locations").name("Respawn Locations").query(DataQuery.of("RespawnLocations")).build());
        this.register("expiration_ticks", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN).id("expiration_ticks").name("Expiration Ticks").query(DataQuery.of("ExpirationTicks")).build());
        this.register("skin_unique_id", (Key<?>)Key.builder().type(TypeTokens.UUID_VALUE_TOKEN).id("skin_uuid").name("Skin UUID").query(DataQuery.of("SkinUUID")).build());
        this.register("moisture", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN).id("moisture").name("Moisture").query(DataQuery.of("Moisture")).build());
        this.register("angry", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("angry").name("Angry").query(DataQuery.of("Angry")).build());
        this.register("anger", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN).id("anger").name("Anger").query(DataQuery.of("Anger")).build());
        this.register("rotation", (Key<?>)Key.builder().type(TypeTokens.ROTATION_VALUE_TOKEN).id("rotation").name("Rotation").query(DataQuery.of("Rotation")).build());
        this.register("is_splash_potion", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("is_splash_potion").name("Is Splash Potion").query(DataQuery.of("IsSplashPotion")).build());
        this.register("affects_spawning", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("affects_spawning").name("Affects Spawning").query(DataQuery.of("AffectsSpawning")).build());
        this.register("critical_hit", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("critical_hit").name("Critical Hit").query(DataQuery.of("CriticalHit")).build());
        this.register("generation", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN).id("generation").name("Generation").query(DataQuery.of("Generation")).build());
        this.register("passengers", (Key<?>)Key.builder().type(TypeTokens.ENTITY_VALUE_TOKEN).id("passenger_snapshot").name("Passenger Snapshot").query(DataQuery.of("PassengerSnapshot")).build());
        this.register("knockback_strength", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN).id("knockback_strength").name("Knockback Strength").query(DataQuery.of("KnockbackStrength")).build());
        this.register("persists", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("persists").name("Persists").query(DataQuery.of("Persists")).build());
        this.register("stored_enchantments", (Key<?>)Key.builder().type(TypeTokens.LIST_ENCHANTMENT_VALUE_TOKEN).id("stored_enchantments").name("Stored Enchantments").query(DataQuery.of("StoredEnchantments")).build());
        this.register("is_sprinting", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("sprinting").name("Sprinting").query(DataQuery.of("Sprinting")).build());
        this.register("stuck_arrows", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN).id("stuck_arrows").name("Stuck Arrows").query(DataQuery.of("StuckArrows")).build());
        this.register("vanish_ignores_collision", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("vanish_ignores_collision").name("Vanish Ignores Collision").query(DataQuery.of("VanishIgnoresCollision")).build());
        this.register("vanish_prevents_targeting", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("vanish_prevents_targeting").name("Vanish Prevents Targeting").query(DataQuery.of("VanishPreventsTargeting")).build());
        this.register("is_aflame", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("is_aflame").name("Is Aflame").query(DataQuery.of("IsAflame")).build());
        this.register("can_breed", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("can_breed").name("Can Breed").query(DataQuery.of("CanBreed")).build());
        this.register("fluid_item_stack", (Key<?>)Key.builder().type(TypeTokens.FLUID_VALUE_TOKEN).id("fluid_item_container_snapshot").name("Fluid Item Container Snapshot").query(DataQuery.of("FluidItemContainerSnapshot")).build());
        this.register("fluid_tank_contents", (Key<?>)Key.builder().type(TypeTokens.MAP_DIRECTION_FLUID_VALUE_TOKEN).id("fluid_tank_contents").name("Fluid Tank Contents").query(DataQuery.of("FluidTankContents")).build());
        this.register("custom_name_visible", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("custom_name_visible").name("Custom Name Visible").query(DataQuery.of("CustomNameVisible")).build());
        this.register("first_date_played", (Key<?>)Key.builder().type(TypeTokens.INSTANT_VALUE_TOKEN).id("first_time_joined").name("First Time Joined").query(DataQuery.of("FirstTimeJoined")).build());
        this.register("last_date_played", (Key<?>)Key.builder().type(TypeTokens.INSTANT_VALUE_TOKEN).id("last_time_played").name("Last Time Played").query(DataQuery.of("LastTimePlayed")).build());
        this.register("hide_enchantments", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("hide_enchantments").name("Hide Enchantments").query(DataQuery.of("HideEnchantments")).build());
        this.register("hide_attributes", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("hide_attributes").name("Hide Attributes").query(DataQuery.of("HideAttributes")).build());
        this.register("hide_unbreakable", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("hide_unbreakable").name("Hide Unbreakable").query(DataQuery.of("HideUnbreakable")).build());
        this.register("hide_can_destroy", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("hide_can_destroy").name("Hide Can Destroy").query(DataQuery.of("HideCanDestroy")).build());
        this.register("hide_can_place", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("hide_can_place").name("Hide Can Place").query(DataQuery.of("HideCanPlace")).build());
        this.register("hide_miscellaneous", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("hide_miscellaneous").name("Hide Miscellaneous").query(DataQuery.of("HideMiscellaneous")).build());
        this.register("potion_effects", (Key<?>)Key.builder().type(TypeTokens.LIST_POTION_VALUE_TOKEN).id("potion_effects").name("Potion Effects").query(DataQuery.of("PotionEffects")).build());
        this.register("potion_type", (Key<?>)Key.builder().type(TypeTokens.POTION_VALUE_TOKEN).id("potion_type").name("Potion Type").query(DataQuery.of("PotionType")).build());
        this.register("body_rotations", (Key<?>)Key.builder().type(TypeTokens.MAP_BODY_VECTOR3D_VALUE_TOKEN).id("body_rotations").name("Body Rotations").query(DataQuery.of("BodyRotations")).build());
        this.register("head_rotation", (Key<?>)Key.builder().type(TypeTokens.VECTOR_3D_VALUE_TOKEN).id("head_rotation").name("Head Rotation").query(DataQuery.of("HeadRotation")).build());
        this.register("chest_rotation", (Key<?>)Key.builder().type(TypeTokens.VECTOR_3D_VALUE_TOKEN).id("chest_rotation").name("Chest Rotation").query(DataQuery.of("ChestRotation")).build());
        this.register("left_arm_rotation", (Key<?>)Key.builder().type(TypeTokens.VECTOR_3D_VALUE_TOKEN).id("left_arm_rotation").name("Left Arm Rotation").query(DataQuery.of("LeftArmRotation")).build());
        this.register("right_arm_rotation", (Key<?>)Key.builder().type(TypeTokens.VECTOR_3D_VALUE_TOKEN).id("right_arm_rotation").name("Right Arm Rotation").query(DataQuery.of("RightArmRotation")).build());
        this.register("left_leg_rotation", (Key<?>)Key.builder().type(TypeTokens.VECTOR_3D_VALUE_TOKEN).id("left_leg_rotation").name("Left Leg Rotation").query(DataQuery.of("LeftLegRotation")).build());
        this.register("right_leg_rotation", (Key<?>)Key.builder().type(TypeTokens.VECTOR_3D_VALUE_TOKEN).id("right_leg_rotation").name("Right Leg Rotation").query(DataQuery.of("RightLegRotation")).build());
        this.register("beacon_primary_effect", (Key<?>)Key.builder().type(TypeTokens.OPTIONAL_POTION_VALUE_TOKEN).id("beacon_primary_effect").name("Beacon Primary Effect").query(DataQuery.of("BeaconPrimaryEffect")).build());
        this.register("beacon_secondary_effect", (Key<?>)Key.builder().type(TypeTokens.OPTIONAL_POTION_VALUE_TOKEN).id("beacon_secondary_effect").name("Beacon Secondary Effect").query(DataQuery.of("BeaconSecondaryEffect")).build());
        this.register("targeted_location", (Key<?>)Key.builder().type(TypeTokens.VECTOR_3D_VALUE_TOKEN).id("targeted_vector_3d").name("Targeted Vector3d").query(DataQuery.of("TargetedVector3d")).build());
        this.register("fuse_duration", (Key<?>)Key.builder().type(TypeTokens.INTEGER_VALUE_TOKEN).id("fuse_duration").name("Fuse Duration").query(DataQuery.of("FuseDuration")).build());
        this.register("ticks_remaining", (Key<?>)Key.builder().type(TypeTokens.INTEGER_VALUE_TOKEN).id("ticks_remaining").name("Ticks Remaining").query(DataQuery.of("TicksRemaining")).build());
        this.register("explosion_radius", (Key<?>)Key.builder().type(TypeTokens.INTEGER_VALUE_TOKEN).id("explosion_radius").name("Explosion Radius").query(DataQuery.of("ExplosionRadius")).build());
        this.register("armor_stand_has_arms", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("has_arms").name("Has Arms").query(DataQuery.of("HasArms")).build());
        this.register("armor_stand_has_base_plate", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("has_base_plate").name("Has Base Plate").query(DataQuery.of("HasBasePlate")).build());
        this.register("armor_stand_marker", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("is_marker").name("Is Marker").query(DataQuery.of("IsMarker")).build());
        this.register("armor_stand_is_small", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("is_small").name("Is Small").query(DataQuery.of("IsSmall")).build());
        this.register("is_silent", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("is_silent").name("Is Silent").query(DataQuery.of("IsSilent")).build());
        this.register("glowing", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("glowing").name("Glowing").query(DataQuery.of("Glowing")).build());
        this.register("pickup_rule", (Key<?>)Key.builder().type(TypeTokens.PICKUP_VALUE_TOKEN).id("pickup_rule").name("Pickup Rule").query(DataQuery.of("PickupRule")).build());
        this.register("invulnerability_ticks", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN).id("invulnerability_ticks").name("Invulnerability Ticks").query(DataQuery.of("HurtTime")).build());
        this.register("invulnerable", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("invulnerable").name("Invulnerable").query(DataQuery.of("Invulnerable")).build());
        this.register("has_gravity", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("has_gravity").name("Has Gravity").query(DataQuery.of("HasGravity")).build());
        this.register("statistics", (Key<?>)Key.builder().type(TypeTokens.STATISTIC_MAP_VALUE_TOKEN).id("statistics").name("Statistics").query(DataQuery.of("Statistics")).build());
        this.register("infinite_despawn_delay", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("infinite_despawn_delay").name("Infinite Despawn Delay").query(DataQuery.of("InfiniteDespawnDelay")).build());
        this.register("infinite_pickup_delay", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("infinite_pickup_delay").name("Infinite Pickup Delay").query(DataQuery.of("InfinitePickupDelay")).build());
        this.register("despawn_delay", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN).id("despawn_delay").name("Despawn Delay").query(DataQuery.of("DespawnDelay")).build());
        this.register("pickup_delay", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN).id("pickup_delay").name("Pickup Delay").query(DataQuery.of("PickupDelay")).build());
        this.register("end_gateway_age", (Key<?>)Key.builder().type(TypeTokens.LONG_VALUE_TOKEN).id("end_gateway_age").name("End Gateway Age").query(DataQuery.of("EndGatewayAge")).build());
        this.register("end_gateway_teleport_cooldown", (Key<?>)Key.builder().type(TypeTokens.INTEGER_VALUE_TOKEN).id("end_gateway_teleport_cooldown").name("End Gateway Teleport Cooldown").query(DataQuery.of("EndGatewayTeleportCooldown")).build());
        this.register("exit_position", (Key<?>)Key.builder().type(TypeTokens.VECTOR_3I_VALUE_TOKEN).id("exit_position").name("Exit Position").query(DataQuery.of("ExitPosition")).build());
        this.register("exact_teleport", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("exact_teleport").name("Exact Teleport").query(DataQuery.of("ExactTeleport")).build());
        this.register("structure_author", (Key<?>)Key.builder().type(TypeTokens.STRING_VALUE_TOKEN).id("structure_author").name("Structure Author").query(DataQuery.of("StructureAuthor")).build());
        this.register("structure_ignore_entities", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("structure_ignore_entities").name("Structure Ignore Entities").query(DataQuery.of("StructureIgnoreEntities")).build());
        this.register("structure_integrity", (Key<?>)Key.builder().type(TypeTokens.FLOAT_VALUE_TOKEN).id("structure_integrity").name("Structure Integrity").query(DataQuery.of("StructureIntegrity")).build());
        this.register("structure_mode", (Key<?>)Key.builder().type(TypeTokens.STRUCTURE_MODE_VALUE_TOKEN).id("structure_mode").name("Structure Mode").query(DataQuery.of("StructureMode")).build());
        this.register("structure_position", (Key<?>)Key.builder().type(TypeTokens.STRING_VALUE_TOKEN).id("structure_position").name("Structure Position").query(DataQuery.of("StructurePosition")).build());
        this.register("structure_powered", (Key<?>)Key.builder().type(TypeTokens.STRING_VALUE_TOKEN).id("structure_powered").name("Structure Powered").query(DataQuery.of("StructurePowered")).build());
        this.register("structure_seed", (Key<?>)Key.builder().type(TypeTokens.LONG_VALUE_TOKEN).id("structure_seed").name("Structure Seed").query(DataQuery.of("StructureSeed")).build());
        this.register("structure_show_air", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("structure_show_air").name("Structure Show Air").query(DataQuery.of("StructureShowAir")).build());
        this.register("structure_show_bounding_box", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("structure_show_bounding_box").name("Structure Show Bounding Box").query(DataQuery.of("StructureShowBoundingBox")).build());
        this.register("structure_size", (Key<?>)Key.builder().type(TypeTokens.VECTOR_3I_VALUE_TOKEN).id("structure_size").name("Structure Size").query(DataQuery.of("StructureSize")).build());
        this.register("absorption", (Key<?>)Key.builder().type(TypeTokens.DOUBLE_VALUE_TOKEN).id("absorption").name("Absorption").query(DataQuery.of("Absorption")).build());
        this.register("area_effect_cloud_radius", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_DOUBLE_VALUE_TOKEN).id("area_effect_cloud_radius").name("AreaEffectCloud Radius").query(DataQuery.of("CloudRadius")).build());
        this.register("area_effect_cloud_radius_on_use", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_DOUBLE_VALUE_TOKEN).id("area_effect_cloud_radius_on_use").name("AreaEffectCloud Radius On Use").query(DataQuery.of("CloudRadiusOnUse")).build());
        this.register("area_effect_cloud_radius_per_tick", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_DOUBLE_VALUE_TOKEN).id("area_effect_cloud_radius_per_tick").name("AreaEffectCloud Radius Per Tick").query(DataQuery.of("CloudRadiusPerTick")).build());
        this.register("area_effect_cloud_color", (Key<?>)Key.builder().type(TypeTokens.COLOR_VALUE_TOKEN).id("area_effect_cloud_color").name("AreaEffectCloud Color").query(DataQuery.of("CloudColor")).build());
        this.register("area_effect_cloud_duration", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN).id("area_effect_cloud_duration").name("AreaEffectCloud Duration").query(DataQuery.of("CloudDuration")).build());
        this.register("area_effect_cloud_duration_on_use", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN).id("area_effect_cloud_duration_on_use").name("AreaEffectCloud Duration On Use").query(DataQuery.of("CloudDurationOnUse")).build());
        this.register("area_effect_cloud_wait_time", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN).id("area_effect_cloud_wait_time").name("AreaEffectCloud Wait Time").query(DataQuery.of("CloudWaitTime")).build());
        this.register("area_effect_cloud_reapplication_delay", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN).id("area_effect_cloud_wait_time").name("AreaEffectCloud Wait Time").query(DataQuery.of("CloudReapplicationDelay")).build());
        this.register("area_effect_cloud_age", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN).id("area_effect_cloud_age").name("AreaEffectCloud Age").query(DataQuery.of("CloudAge")).build());
        this.register("area_effect_cloud_particle_type", (Key<?>)Key.builder().type(TypeTokens.PARTICLE_TYPE_VALUE_TOKEN).id("area_effect_cloud_particle_type").name("AreaEffectCloud ParticleType").query(DataQuery.of("CloudParticleType")).build());
        this.register("age", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN).id("entity_age").name("Entity Age").query(DataQuery.of("EntityAge")).build());
        this.register("attack_damage", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_DOUBLE_VALUE_TOKEN).id("entity_attack_damage").name("Entity Attack Damage").query(DataQuery.of("EntityAttackDamage")).build());
        this.register("base_size", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_DOUBLE_VALUE_TOKEN).id("base_size").name("Entity Base Size").query(DataQuery.of("EntityBaseSize")).build());
        this.register("damage_entity_map", (Key<?>)Key.builder().type(TypeTokens.ENTITY_TYPE_DOUBLE_MAP_VALUE_TOKEN).id("entity_type_damage_map").name("Entity Type Damage Map").query(DataQuery.of("DamageEntityTypeMap")).build());
        this.register("dominant_hand", (Key<?>)Key.builder().type(TypeTokens.HAND_PREFERENCE_VALUE_TOKEN).id("hand_preference").name("Hand Preference").query(DataQuery.of("HandPreference")).build());
        this.register("filled", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("filled").name("Filled").query(DataQuery.of("Filled")).build());
        this.register("fluid_level", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN).id("fluid_level").name("Fluid Level").query(DataQuery.of("LiquidLevel")).build());
        this.register("health_scale", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_DOUBLE_VALUE_TOKEN).id("health_scale").name("Health Scale").query(DataQuery.of("HealthScale")).build());
        this.register("height", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_DOUBLE_VALUE_TOKEN).id("entity_height").name("Entity Height").query(DataQuery.of("EntityHeight")).build());
        this.register("held_experience", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN).id("held_experience").name("Held Experience").query(DataQuery.of("HeldExperience")).build());
        this.register("is_sleeping", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("is_sleeping").name("Is Sleeping").query(DataQuery.of("IsSleeping")).build());
        this.register("is_johnny", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("is_johnny").name("Is Johnny").query(DataQuery.of("IsJohnny")).build());
        this.register("johnny_vindicator", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("johnny_vindicator").name("Johnny Vindicator").query(DataQuery.of("JohnnyVindicator")).build());
        this.register("last_attacker", (Key<?>)Key.builder().type(TypeTokens.OPTIONAL_ENTITY_SNAPSHOT_VALUE_TOKEN).id("last_attacker").name("Last Attacker").query(DataQuery.of("LastAttacker")).build());
        this.register("last_damage", (Key<?>)Key.builder().type(TypeTokens.OPTIONAL_DOUBLE_VALUE_TOKEN).id("last_damage").name("Last Damage Taken").query(DataQuery.of("LastDamage")).build());
        this.register("llama_strength", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN).id("llama_strength").name("Llama Strength").query(DataQuery.of("LlamaStrength")).build());
        this.register("llama_variant", (Key<?>)Key.builder().type(TypeTokens.LLAMA_VARIANT_VALUE_TOKEN).id("llama_variant").name("Llama Variant").query(DataQuery.of("LlamaVariant")).build());
        this.register("scale", (Key<?>)Key.builder().type(TypeTokens.DOUBLE_VALUE_TOKEN).id("entity_scale").name("Entity Scale").query(DataQuery.of("EntityScale")).build());
        this.register("will_shatter", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("will_shatter").name("Will Shatter").query(DataQuery.of("WillShatter")).build());
        this.register("wire_attachments", (Key<?>)Key.builder().type(TypeTokens.WIRE_ATTACHMENT_MAP_VALUE_TOKEN).id("wire_attachment_map").name("Wire Attachment Map").query(DataQuery.of("WireAttachmentMap")).build());
        this.register("wire_attachment_east", (Key<?>)Key.builder().type(TypeTokens.WIRE_ATTACHMENT_TYPE_VALUE_TOKEN).id("wire_attachment_east").name("Wire Attachment East").query(DataQuery.of("WireAttachmentEast")).build());
        this.register("wire_attachment_south", (Key<?>)Key.builder().type(TypeTokens.WIRE_ATTACHMENT_TYPE_VALUE_TOKEN).id("wire_attachment_south").name("Wire Attachment South").query(DataQuery.of("WireAttachmentSouth")).build());
        this.register("wire_attachment_north", (Key<?>)Key.builder().type(TypeTokens.WIRE_ATTACHMENT_TYPE_VALUE_TOKEN).id("wire_attachment_north").name("Wire Attachment North").query(DataQuery.of("WireAttachmentNorth")).build());
        this.register("wire_attachment_west", (Key<?>)Key.builder().type(TypeTokens.WIRE_ATTACHMENT_TYPE_VALUE_TOKEN).id("wire_attachment_west").name("Wire Attachment West").query(DataQuery.of("WireAttachmentWest")).build());
        this.register("age", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN).id("age").name("Age").query(DataQuery.of("Age")).build());
        this.register("is_adult", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("is_adult").name("Is Adult").query(DataQuery.of("IsAdult")).build());
        this.register("is_baby", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("is_baby").name("Is Baby").query(DataQuery.of("IsBaby")).build());
        this.register("health_scale", (Key<?>)Key.builder().type(TypeTokens.BOUNDED_DOUBLE_VALUE_TOKEN).id("health_scale").name("Health Scale").query(DataQuery.of("HealthScale")).build());
        this.register("is_elytra_flying", (Key<?>)Key.builder().type(TypeTokens.BOOLEAN_VALUE_TOKEN).id("is_elytra_flying").name("Is Elytra Flying").query(DataQuery.of("ElytraFlying")).build());
        this.register("active_item", (Key<?>)Key.builder().type(TypeTokens.ITEM_SNAPSHOT_VALUE_TOKEN).id("active_item").name("Active Item").query(DataQuery.of("ActiveItem")).build());
        Sponge.getCauseStackManager().popCause();
    }

    private void register(String fieldName, Key<?> key) {
        this.fieldMap.put(fieldName, key);
        this.keyMap.put(key.getId().toLowerCase(Locale.ENGLISH), key);
    }

    @Override
    public void registerAdditionalCatalog(Key<?> extraCatalog) {
        Preconditions.checkState((!SpongeDataManager.areRegistrationsComplete() ? 1 : 0) != 0, (Object)"Cannot this.register new Keys after Data Registration has completed!");
        Preconditions.checkNotNull(extraCatalog, (Object)"Key cannot be null!");
        PluginContainer parent = ((SpongeKey)extraCatalog).getParent();
        String pluginId = parent.getId().toLowerCase(Locale.ENGLISH);
        String id = extraCatalog.getId().toLowerCase(Locale.ENGLISH);
        Object[] split = id.split(":");
        Preconditions.checkArgument((split.length == 2 ? 1 : 0) != 0, (Object)("Key id's have to be in two parts! The first part being the plugin id, the second part being the key's individual id. Currently you have: " + Arrays.toString(split)));
        Preconditions.checkArgument((boolean)((String)split[0]).equals(pluginId), (Object)("A plugin is trying to this.register custom keys under a different plugin id namespace! This is unsupported! The provided key: " + id));
        this.keyMap.put(id, extraCatalog);
    }

    @Override
    public Optional<Key<?>> getById(String id) {
        return Optional.ofNullable(this.keyMap.get(id.toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<Key<?>> getAll() {
        return Collections.unmodifiableCollection(this.keyMap.values());
    }

    private KeyRegistryModule() {
    }

    public void registerKeyListeners() {
        for (Key<?> key : this.keyMap.values()) {
            ((SpongeKey)key).registerListeners();
        }
    }

    public void registerForEntityClass(Class<? extends Entity> cls) {
        try {
            List converters = LOADED_CLASSES.computeIfAbsent(cls, k -> new ArrayList());
            Callable<List<DataParameterConverter<?>>> callable = DATA_PARAMETER_FUNCTION_GETTERS.get(cls);
            if (callable != null) {
                List<DataParameterConverter<?>> call = callable.call();
                converters.addAll(call);
            }
            Class<? extends Entity> clazz = cls.getSuperclass();
            do {
                List superConverters = LOADED_CLASSES.computeIfAbsent(clazz, k -> new ArrayList());
                Callable<List<DataParameterConverter<?>>> listCallable = DATA_PARAMETER_FUNCTION_GETTERS.get(clazz);
                if (listCallable == null) continue;
                List<DataParameterConverter<?>> call = listCallable.call();
                superConverters.addAll(call);
                converters.addAll(call);
            } while ((clazz = clazz.getSuperclass()).getSuperclass() != Object.class && !LOADED_CLASSES.containsKey(clazz));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static final class Holder {
        static final KeyRegistryModule INSTANCE = new KeyRegistryModule();

        Holder() {
        }
    }
}

