/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.pagination;

import com.flowpowered.math.GenericMath;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.PrimitiveIterator;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.HeaderMode;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.common.interfaces.text.IMixinTextComponent;
import org.spongepowered.common.text.SpongeTexts;

class PaginationCalculator {
    private static final String NON_UNICODE_CHARS;
    private static final int[] NON_UNICODE_CHAR_WIDTHS;
    private static final byte[] UNICODE_CHAR_WIDTHS;
    private static final int LINE_WIDTH = 320;
    private final int linesPerPage;

    PaginationCalculator(int linesPerPage) {
        this.linesPerPage = linesPerPage;
    }

    int getLinesPerPage(MessageReceiver source) {
        return this.linesPerPage;
    }

    int getLines(Text text) {
        return (int)Math.ceil((double)this.getWidth(text) / 320.0);
    }

    @VisibleForTesting
    int getWidth(int codePoint, boolean isBold) {
        int width;
        int nonUnicodeIdx = NON_UNICODE_CHARS.indexOf(codePoint);
        if (codePoint == 32) {
            width = 4;
        } else if (codePoint > 0 && nonUnicodeIdx != -1) {
            width = NON_UNICODE_CHAR_WIDTHS[nonUnicodeIdx];
        } else if (UNICODE_CHAR_WIDTHS[codePoint] != 0) {
            int temp = UNICODE_CHAR_WIDTHS[codePoint] & 0xFF;
            int startColumn = temp >>> 4;
            int endColumn = temp & 0xF;
            width = endColumn + 1 - startColumn;
            width = width / 2 + 1;
        } else {
            width = 0;
        }
        if (isBold && width > 0) {
            ++width;
        }
        return width;
    }

    @VisibleForTesting
    int getWidth(Text text) {
        ITextComponent component = SpongeTexts.toComponent(text);
        Iterable<ITextComponent> children = ((IMixinTextComponent)component).withChildren();
        int total = 0;
        for (ITextComponent child : children) {
            if (!(child instanceof TextComponentString) && !(child instanceof TextComponentTranslation)) continue;
            PrimitiveIterator.OfInt i_it = child.func_150261_e().codePoints().iterator();
            boolean bold = child.func_150256_b().func_150223_b();
            boolean newLine = false;
            while (i_it.hasNext()) {
                Integer cp = i_it.next();
                if (cp == 10) {
                    if (newLine) {
                        total += 320;
                        continue;
                    }
                    total = (int)Math.ceil((double)total / 320.0) * 320;
                    newLine = true;
                    continue;
                }
                int width = this.getWidth(cp, bold);
                total += width;
                newLine = false;
            }
        }
        return total;
    }

    Text center(Text text, Text padding) {
        int inputLength = this.getWidth(text);
        if (inputLength >= 320) {
            return text;
        }
        Text textWithSpaces = this.addSpaces(Text.of(" "), text);
        boolean addSpaces = this.getWidth(textWithSpaces) <= 320;
        Text styledPadding = this.withStyle(padding, text);
        int paddingLength = this.getWidth(styledPadding);
        Text.Builder output = Text.builder();
        if (paddingLength < 1) {
            padding = Text.of("=");
            styledPadding = this.withColor(this.withStyle(padding, text), text);
            paddingLength = this.getWidth(styledPadding);
        }
        if (inputLength == 0) {
            this.addPadding(padding, output, GenericMath.floor(320.0 / (double)paddingLength));
        } else {
            if (addSpaces) {
                text = textWithSpaces;
                inputLength = this.getWidth(textWithSpaces);
            }
            int paddingNecessary = 320 - inputLength;
            int paddingCount = GenericMath.floor(paddingNecessary / paddingLength);
            int beforePadding = GenericMath.floor((double)paddingCount / 2.0);
            int afterPadding = paddingCount - beforePadding;
            this.addPadding(styledPadding, output, beforePadding);
            output.append(text);
            this.addPadding(styledPadding, output, afterPadding);
        }
        return this.finalizeBuilder(text, output);
    }

    private Text withStyle(Text text, Text styled) {
        return text.toBuilder().style(styled.getStyle()).build();
    }

    private Text withColor(Text text, Text colored) {
        return text.toBuilder().color(colored.getColor()).build();
    }

    private Text finalizeBuilder(Text text, Text.Builder build) {
        return build.style(text.getStyle()).build();
    }

    private Text addSpaces(Text spaces, Text text) {
        return Text.builder().append(spaces).append(text).append(spaces).color(text.getColor()).style(text.getStyle()).build();
    }

    private void addPadding(Text padding, Text.Builder build, int count) {
        if (count > 0) {
            build.append((Collection<? extends Text>)Collections.nCopies(count, padding));
        }
    }

    static {
        HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setURL(PaginationCalculator.class.getResource("font-sizes.json"))).setHeaderMode(HeaderMode.NONE)).build();
        try {
            Object node = loader.load();
            NON_UNICODE_CHARS = node.getNode("non-unicode").getString();
            List<? extends ConfigurationNode> charWidths = node.getNode("char-widths").getChildrenList();
            int[] nonUnicodeCharWidths = new int[charWidths.size()];
            for (int i = 0; i < nonUnicodeCharWidths.length; ++i) {
                nonUnicodeCharWidths[i] = charWidths.get(i).getInt();
            }
            NON_UNICODE_CHAR_WIDTHS = nonUnicodeCharWidths;
            List<? extends ConfigurationNode> glyphWidths = node.getNode("glyph-widths").getChildrenList();
            byte[] unicodeCharWidths = new byte[glyphWidths.size()];
            for (int i = 0; i < unicodeCharWidths.length; ++i) {
                unicodeCharWidths[i] = (byte)glyphWidths.get(i).getInt();
            }
            UNICODE_CHAR_WIDTHS = unicodeCharWidths;
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

