/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.text.action;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.text.Text;
import org.spongepowered.common.util.SpongeCommonTranslationHelper;

public class SpongeCallbackHolder {
    public static final String CALLBACK_COMMAND = "callback";
    public static final String CALLBACK_COMMAND_QUALIFIED = "/sponge:callback";
    private static final SpongeCallbackHolder INSTANCE = new SpongeCallbackHolder();
    static final ConcurrentMap<UUID, Consumer<CommandSource>> reverseMap = new ConcurrentHashMap<UUID, Consumer<CommandSource>>();
    private static final LoadingCache<Consumer<CommandSource>, UUID> callbackCache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<Consumer<CommandSource>, UUID>(){

        public void onRemoval(RemovalNotification<Consumer<CommandSource>, UUID> notification) {
            reverseMap.remove(notification.getValue(), notification.getKey());
        }
    }).build((CacheLoader)new CacheLoader<Consumer<CommandSource>, UUID>(){

        public UUID load(Consumer<CommandSource> key) throws Exception {
            UUID ret = UUID.randomUUID();
            reverseMap.putIfAbsent(ret, key);
            return ret;
        }
    });

    public static SpongeCallbackHolder getInstance() {
        return INSTANCE;
    }

    public UUID getOrCreateIdForCallback(Consumer<CommandSource> callback) {
        return (UUID)callbackCache.getUnchecked(Preconditions.checkNotNull(callback, (Object)CALLBACK_COMMAND));
    }

    public Optional<Consumer<CommandSource>> getCallbackForUUID(UUID id) {
        return Optional.of(reverseMap.get(id));
    }

    public CommandSpec createCommand() {
        return CommandSpec.builder().description(SpongeCommonTranslationHelper.t("Execute a callback registered as part of a Text object. Primarily for internal use", new Object[0])).arguments((CommandElement)new CallbackCommandElement(SpongeCommonTranslationHelper.t(CALLBACK_COMMAND, new Object[0]))).executor((src, args) -> {
            ((Consumer)args.getOne(CALLBACK_COMMAND).get()).accept(src);
            return CommandResult.success();
        }).build();
    }

    private class CallbackCommandElement
    extends CommandElement {
        protected CallbackCommandElement(Text key) {
            super(key);
        }

        @Override
        @Nullable
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            String next = args.next();
            try {
                UUID id = UUID.fromString(next);
                Consumer ret = (Consumer)reverseMap.get(id);
                if (ret == null) {
                    throw args.createError(SpongeCommonTranslationHelper.t("The callback you provided was not valid. Keep in mind that callbacks will expire after 10 minutes, so you might want to consider clicking faster next time!", new Object[0]));
                }
                return ret;
            }
            catch (IllegalArgumentException ex) {
                throw args.createError(SpongeCommonTranslationHelper.t("Input %s was not a valid UUID", next));
            }
        }

        @Override
        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            return ImmutableList.of();
        }
    }
}

