/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world;

import com.google.common.base.MoreObjects;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.common.registry.type.world.BlockChangeFlagRegistryModule;

public final class SpongeBlockChangeFlag
implements BlockChangeFlag {
    private final boolean updateNeighbors;
    private final boolean performBlockPhysics;
    private final boolean notifyObservers;
    private final boolean notifyClients;
    private final boolean ignoreRender;
    private final boolean forceReRender;
    private final int rawFlag;
    private final String name;

    public SpongeBlockChangeFlag(String name, int flag) {
        this.updateNeighbors = (flag & 1) != 0;
        this.performBlockPhysics = (flag & 0x20) == 0;
        this.notifyObservers = (flag & 0x10) == 0;
        this.notifyClients = (flag & 2) != 0;
        this.ignoreRender = (flag & 4) != 0;
        this.forceReRender = (flag & 8) != 0 && !this.ignoreRender;
        this.rawFlag = flag;
        this.name = name;
    }

    @Override
    public boolean updateNeighbors() {
        return this.updateNeighbors;
    }

    @Override
    public boolean performBlockPhysics() {
        return this.performBlockPhysics;
    }

    @Override
    public boolean notifyObservers() {
        return this.notifyObservers;
    }

    @Override
    public SpongeBlockChangeFlag withUpdateNeighbors(boolean updateNeighbors) {
        if (this.updateNeighbors == updateNeighbors) {
            return this;
        }
        return updateNeighbors ? this.andFlag(BlockChangeFlags.NEIGHBOR) : this.andNotFlag(BlockChangeFlags.NEIGHBOR);
    }

    @Override
    public SpongeBlockChangeFlag withPhysics(boolean performBlockPhysics) {
        if (this.performBlockPhysics == performBlockPhysics) {
            return this;
        }
        return performBlockPhysics ? this.andFlag(BlockChangeFlags.PHYSICS) : this.andNotFlag(BlockChangeFlags.PHYSICS);
    }

    @Override
    public SpongeBlockChangeFlag withNotifyObservers(boolean notifyObservers) {
        if (this.notifyObservers == notifyObservers) {
            return this;
        }
        return notifyObservers ? this.andFlag(BlockChangeFlags.OBSERVER) : this.andNotFlag(BlockChangeFlags.OBSERVER);
    }

    @Override
    public BlockChangeFlag inverse() {
        int maskedFlag = (this.updateNeighbors ? 0 : 1) | (this.performBlockPhysics ? 32 : 0) | (this.notifyObservers ? 16 : 0) | (this.notifyClients ? 0 : 2) | (this.ignoreRender ? 0 : 4) | (this.forceReRender ? 0 : 8);
        return BlockChangeFlagRegistryModule.fromNativeInt(maskedFlag);
    }

    @Override
    public SpongeBlockChangeFlag andFlag(BlockChangeFlag flag) {
        SpongeBlockChangeFlag o = (SpongeBlockChangeFlag)flag;
        int maskedFlag = (this.updateNeighbors || o.updateNeighbors) | (this.performBlockPhysics || o.performBlockPhysics ? 0 : 32) | (this.notifyObservers || o.notifyObservers ? 0 : 16) | (this.notifyClients || o.notifyClients ? 2 : 0) | (this.ignoreRender || o.ignoreRender ? 4 : 0) | (this.forceReRender || o.forceReRender ? 8 : 0);
        return BlockChangeFlagRegistryModule.fromNativeInt(maskedFlag);
    }

    @Override
    public SpongeBlockChangeFlag andNotFlag(BlockChangeFlag flag) {
        SpongeBlockChangeFlag o = (SpongeBlockChangeFlag)flag;
        int maskedFlag = (this.updateNeighbors && !o.updateNeighbors ? 1 : 0) | (this.performBlockPhysics && !o.performBlockPhysics ? 0 : 32) | (this.notifyObservers && !o.notifyObservers ? 0 : 16) | (this.notifyClients && !o.notifyClients ? 2 : 0) | (this.ignoreRender && !o.ignoreRender ? 4 : 0) | (this.forceReRender && !o.forceReRender ? 8 : 0);
        return BlockChangeFlagRegistryModule.fromNativeInt(maskedFlag);
    }

    public boolean isNotifyClients() {
        return this.notifyClients;
    }

    public boolean isIgnoreRender() {
        return this.ignoreRender;
    }

    public boolean isForceReRender() {
        return this.forceReRender;
    }

    public String getName() {
        return this.name;
    }

    public int getRawFlag() {
        return this.rawFlag;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rawFlag", this.rawFlag).add("updateNeighbors", this.updateNeighbors).add("performBlockPhysics", this.performBlockPhysics).add("notifyObservers", this.notifyObservers).add("notifyClients", this.notifyClients).add("ignoreRender", this.ignoreRender).add("forceReRender", this.forceReRender).toString();
    }
}

