/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.core.forge.common;

import com.flowpowered.math.vector.Vector3d;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.message.MessageChannelEvent;
import org.spongepowered.api.event.message.MessageEvent;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.chat.ChatTypes;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseData;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.interfaces.entity.player.IMixinEntityPlayerMP;
import org.spongepowered.common.interfaces.world.IMixinWorld;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.text.SpongeTexts;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.mod.event.SpongeModEventManager;
import org.spongepowered.mod.event.SpongeToForgeEventData;
import org.spongepowered.mod.interfaces.IMixinEventBus;
import org.spongepowered.mod.interfaces.IMixinNetPlayHandler;

@Mixin(value={ForgeHooks.class}, remap=false)
public abstract class MixinForgeHooks {
    @Overwrite
    public static PlayerInteractEvent.LeftClickBlock onLeftClickBlock(EntityPlayer player, BlockPos pos, EnumFacing face, Vec3d hitVec) {
        Vector3d vec;
        PlayerInteractEvent.LeftClickBlock evt = new PlayerInteractEvent.LeftClickBlock(player, pos, face, hitVec);
        if (player.field_70170_p.field_72995_K) {
            ((IMixinEventBus)MinecraftForge.EVENT_BUS).post((Event)evt, true);
            return evt;
        }
        ItemStack stack = player.func_184614_ca();
        BlockSnapshot blockSnapshot = new Location<World>((World)player.field_70170_p, VecHelper.toVector3d(pos)).createSnapshot();
        RayTraceResult result = SpongeImplHooks.rayTraceEyes((EntityLivingBase)player, SpongeImplHooks.getBlockReachDistance((EntityPlayerMP)player));
        Vector3d vector3d = vec = result == null ? null : VecHelper.toVector3d(result.field_72307_f);
        if (SpongeCommonEventFactory.callInteractItemEventPrimary(player, stack, EnumHand.MAIN_HAND, vec, blockSnapshot).isCancelled()) {
            ((IMixinEntityPlayerMP)player).sendBlockChange(pos, player.field_70170_p.func_180495_p(pos));
            evt.setCanceled(true);
            return evt;
        }
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return evt;
    }

    @Inject(method={"onItemRightClick"}, at={@At(value="HEAD")}, cancellable=true)
    private static void onItemRightClickHead(EntityPlayer player, EnumHand hand, CallbackInfoReturnable<EnumActionResult> cir) {
        long packetDiff;
        if (!player.field_70170_p.field_72995_K && (packetDiff = System.currentTimeMillis() - SpongeCommonEventFactory.lastTryBlockPacketTimeStamp) < 100L) {
            cir.setReturnValue(null);
        }
    }

    @Redirect(method={"canToolHarvestBlock"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;isEmpty()Z", remap=true), remap=false)
    private static boolean isItemEmptyCheckThrowChangeBlockEvent(ItemStack stack, IBlockAccess access, BlockPos pos, ItemStack sameStack) {
        if (stack.func_190926_b()) {
            return true;
        }
        if (SpongeImplHooks.isMainThread() && access instanceof IMixinWorld && !((IMixinWorld)access).isFake()) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.USED_ITEM, ItemStackUtil.snapshotOf(stack));
                boolean bl = SpongeCommonEventFactory.callChangeBlockEventPre((IMixinWorldServer)access, pos).isCancelled();
                return bl;
            }
        }
        return false;
    }

    @Overwrite
    public static boolean canHarvestBlock(@Nonnull Block block, @Nonnull EntityPlayer player, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        int toolLevel;
        EntityPlayer source;
        IBlockState state = world.func_180495_p(pos);
        if ((state = state.func_177230_c().func_176221_a(state, world, pos)).func_185904_a().func_76229_l()) {
            return true;
        }
        ItemStack stack = player.func_184614_ca();
        String tool = block.getHarvestTool(state);
        if (stack.func_190926_b() || tool == null) {
            return player.func_184823_b(state);
        }
        PhaseTracker phaseTracker = PhaseTracker.getInstance();
        PhaseData peek = phaseTracker.getCurrentPhaseData();
        IPhaseState<?> phaseState = peek.state;
        Object object = source = peek.context.getSource() == null ? player : peek.context.getSource();
        if (!phaseState.isInteraction() && world instanceof IMixinWorldServer && !((IMixinWorld)world).isFake() && SpongeImplHooks.isMainThread()) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.USED_ITEM, ItemStackUtil.snapshotOf(player.func_184607_cu()));
                if (SpongeCommonEventFactory.callChangeBlockEventPre((IMixinWorldServer)world, pos, (Object)source).isCancelled()) {
                    boolean bl = false;
                    return bl;
                }
            }
        }
        if ((toolLevel = stack.func_77973_b().getHarvestLevel(stack, tool, player, state)) < 0) {
            return player.func_184823_b(state);
        }
        return toolLevel >= block.getHarvestLevel(state);
    }

    @Overwrite
    @Nullable
    public static ITextComponent onServerChatEvent(NetHandlerPlayServer net, String raw, ITextComponent comp) {
        ServerChatEvent forgeEvent;
        MessageChannel channel;
        MessageEvent.MessageFormatter formatter = new MessageEvent.MessageFormatter();
        EntityPlayerMP player = net.field_147369_b;
        Text[] chat = SpongeTexts.splitChatMessage(comp);
        if (chat[1] == null) {
            chat[1] = chat[0] != null ? chat[0] : SpongeTexts.toText(comp);
            chat[0] = null;
        }
        if (chat[0] != null) {
            formatter.getHeader().add(new MessageEvent.DefaultHeaderApplier(chat[0]));
        }
        formatter.getBody().add(new MessageEvent.DefaultBodyApplier(chat[1]));
        LiteralText rawSpongeMessage = Text.of(raw);
        MessageChannel originalChannel = channel = ((Player)player).getMessageChannel();
        MessageChannelEvent.Chat spongeEvent = SpongeEventFactory.createMessageChannelEventChat(Sponge.getCauseStackManager().getCurrentCause(), originalChannel, Optional.ofNullable(channel), formatter, rawSpongeMessage, false);
        SpongeToForgeEventData eventData = ((SpongeModEventManager)Sponge.getEventManager()).extendedPost(spongeEvent, true, false);
        ITextComponent spongeComponent = SpongeTexts.toComponent(spongeEvent.getMessage());
        if (eventData.getForgeEvent() != null && eventData.getForgeEvent() instanceof ServerChatEvent && !spongeComponent.equals((forgeEvent = (ServerChatEvent)eventData.getForgeEvent()).getComponent())) {
            forgeEvent.setComponent(spongeComponent);
        }
        if (!spongeEvent.isCancelled()) {
            Text message = spongeEvent.getMessage();
            if (!spongeEvent.isMessageCancelled()) {
                spongeEvent.getChannel().ifPresent(spongeChannel -> spongeChannel.send(player, message, ChatTypes.CHAT));
            }
        }
        int chatSpamThresholdCount = ((IMixinNetPlayHandler)player.field_71135_a).getChatSpamThresholdCount() + 20;
        ((IMixinNetPlayHandler)player.field_71135_a).setChatSpamThresholdCount(chatSpamThresholdCount);
        if (chatSpamThresholdCount > 200 && !SpongeImpl.getServer().func_184103_al().func_152596_g(player.func_146103_bH())) {
            player.field_71135_a.func_194028_b((ITextComponent)new TextComponentTranslation("disconnect.spam", new Object[0]));
        }
        return null;
    }
}

