/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.service.world;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.common.ForgeChunkManager;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.world.ChunkTicketManager;
import org.spongepowered.api.world.World;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.mod.mixin.core.forge.common.MixinForgeChunkManager$Ticket;

public class SpongeChunkTicketManager
implements ChunkTicketManager {
    @Override
    public void registerCallback(Object plugin, ChunkTicketManager.Callback callback) {
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)plugin, (ForgeChunkManager.LoadingCallback)new SpongeLoadingCallback(callback));
    }

    @Override
    public Optional<ChunkTicketManager.LoadingTicket> createTicket(Object plugin, World world) {
        ForgeChunkManager.Ticket forgeTicket = ForgeChunkManager.requestTicket((Object)plugin, (net.minecraft.world.World)((net.minecraft.world.World)world), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (forgeTicket == null) {
            return Optional.empty();
        }
        return Optional.of(new SpongeLoadingTicket(forgeTicket));
    }

    @Override
    public Optional<ChunkTicketManager.EntityLoadingTicket> createEntityTicket(Object plugin, World world) {
        ForgeChunkManager.Ticket forgeTicket = ForgeChunkManager.requestTicket((Object)plugin, (net.minecraft.world.World)((net.minecraft.world.World)world), (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY);
        if (forgeTicket == null) {
            return Optional.empty();
        }
        return Optional.of(new SpongeEntityLoadingTicket(forgeTicket));
    }

    @Override
    public Optional<ChunkTicketManager.PlayerLoadingTicket> createPlayerTicket(Object plugin, World world, UUID player) {
        Optional<Player> spongePlayer = SpongeImpl.getGame().getServer().getPlayer(player);
        if (!spongePlayer.isPresent()) {
            return Optional.empty();
        }
        ForgeChunkManager.Ticket forgeTicket = ForgeChunkManager.requestPlayerTicket((Object)plugin, (String)spongePlayer.get().getName(), (net.minecraft.world.World)((net.minecraft.world.World)world), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (forgeTicket == null) {
            return Optional.empty();
        }
        return Optional.of(new SpongePlayerLoadingTicket(forgeTicket));
    }

    @Override
    public Optional<ChunkTicketManager.PlayerEntityLoadingTicket> createPlayerEntityTicket(Object plugin, World world, UUID player) {
        Optional<Player> spongePlayer = SpongeImpl.getGame().getServer().getPlayer(player);
        if (!spongePlayer.isPresent()) {
            return Optional.empty();
        }
        ForgeChunkManager.Ticket forgeTicket = ForgeChunkManager.requestPlayerTicket((Object)plugin, (String)spongePlayer.get().getName(), (net.minecraft.world.World)((net.minecraft.world.World)world), (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY);
        if (forgeTicket == null) {
            return Optional.empty();
        }
        return Optional.of(new SpongePlayerEntityLoadingTicket(forgeTicket));
    }

    @Override
    public int getMaxTickets(Object plugin) {
        return ForgeChunkManager.getMaxTicketLengthFor((String)((PluginContainer)plugin).getId());
    }

    @Override
    public int getAvailableTickets(Object plugin, World world) {
        return ForgeChunkManager.ticketCountAvailableFor((Object)plugin, (net.minecraft.world.World)((net.minecraft.world.World)world));
    }

    @Override
    public int getAvailableTickets(UUID player) {
        Optional<Player> spongePlayer = SpongeImpl.getGame().getServer().getPlayer(player);
        return spongePlayer.map(player1 -> ForgeChunkManager.ticketCountAvailableFor((String)player1.getName())).orElse(0);
    }

    @Override
    public ImmutableSetMultimap<Vector3i, ChunkTicketManager.LoadingTicket> getForcedChunks(World world) {
        ImmutableSetMultimap forgeForcedChunks = ForgeChunkManager.getPersistentChunksFor((net.minecraft.world.World)((net.minecraft.world.World)world));
        ImmutableSetMultimap.Builder spongeForcedChunks = ImmutableSetMultimap.builder();
        for (Map.Entry ticketPair : forgeForcedChunks.entries()) {
            spongeForcedChunks.put((Object)new Vector3i(((ChunkPos)ticketPair.getKey()).field_77276_a, 0, ((ChunkPos)ticketPair.getKey()).field_77275_b), (Object)new SpongeLoadingTicket((ForgeChunkManager.Ticket)ticketPair.getValue()));
        }
        return spongeForcedChunks.build();
    }

    private class SpongePlayerOrderedCallback
    extends SpongeLoadingCallback
    implements ForgeChunkManager.PlayerOrderedLoadingCallback {
        public SpongePlayerOrderedCallback(Object plugin, ChunkTicketManager.Callback callback) {
            super(callback);
        }

        public ListMultimap<String, ForgeChunkManager.Ticket> playerTicketsLoaded(ListMultimap<String, ForgeChunkManager.Ticket> tickets, net.minecraft.world.World world) {
            ArrayListMultimap spongeLoadingTickets = ArrayListMultimap.create();
            for (Map.Entry mapEntry : tickets.entries()) {
                Optional<Player> player = SpongeImpl.getGame().getServer().getPlayer((String)mapEntry.getKey());
                player.ifPresent(arg_0 -> this.lambda$playerTicketsLoaded$0((ListMultimap)spongeLoadingTickets, mapEntry, arg_0));
            }
            ListMultimap<UUID, ChunkTicketManager.LoadingTicket> spongeKeptTickets = ((ChunkTicketManager.PlayerOrderedCallback)this.spongeLoadingCallback).onPlayerLoaded((ImmutableListMultimap<UUID, ChunkTicketManager.LoadingTicket>)ImmutableListMultimap.copyOf((Multimap)spongeLoadingTickets), (World)world);
            ArrayListMultimap forgeTickets = ArrayListMultimap.create();
            for (Map.Entry mapEntry : spongeKeptTickets.entries()) {
                Optional<Player> player = SpongeImpl.getGame().getServer().getPlayer((UUID)mapEntry.getKey());
                player.ifPresent(arg_0 -> SpongePlayerOrderedCallback.lambda$playerTicketsLoaded$1((ListMultimap)forgeTickets, mapEntry, arg_0));
            }
            return forgeTickets;
        }

        private static /* synthetic */ void lambda$playerTicketsLoaded$1(ListMultimap forgeTickets, Map.Entry mapEntry, Player player1) {
            forgeTickets.put((Object)player1.getName(), (Object)((SpongeLoadingTicket)mapEntry.getValue()).forgeTicket);
        }

        private /* synthetic */ void lambda$playerTicketsLoaded$0(ListMultimap spongeLoadingTickets, Map.Entry mapEntry, Player player1) {
            spongeLoadingTickets.put((Object)player1.getUniqueId(), (Object)new SpongePlayerLoadingTicket((ForgeChunkManager.Ticket)mapEntry.getValue()));
        }
    }

    private class SpongeOrderedCallback
    extends SpongeLoadingCallback
    implements ForgeChunkManager.OrderedLoadingCallback {
        public SpongeOrderedCallback(Object plugin, ChunkTicketManager.Callback callback) {
            super(callback);
        }

        public List<ForgeChunkManager.Ticket> ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, net.minecraft.world.World world, int maxTicketCount) {
            ArrayList<SpongeLoadingTicket> spongeLoadingTickets = new ArrayList<SpongeLoadingTicket>();
            for (ForgeChunkManager.Ticket ticket : tickets) {
                spongeLoadingTickets.add(new SpongeLoadingTicket(ticket));
            }
            ChunkTicketManager.OrderedCallback spongeOrderedCallback = (ChunkTicketManager.OrderedCallback)this.spongeLoadingCallback;
            List<ChunkTicketManager.LoadingTicket> spongeKeptTickets = spongeOrderedCallback.onLoaded((ImmutableList<ChunkTicketManager.LoadingTicket>)ImmutableList.copyOf(spongeLoadingTickets), (World)world, maxTicketCount);
            ArrayList<ForgeChunkManager.Ticket> forgeTickets = new ArrayList<ForgeChunkManager.Ticket>();
            for (ChunkTicketManager.LoadingTicket ticket : spongeKeptTickets) {
                forgeTickets.add(((SpongeLoadingTicket)ticket).forgeTicket);
            }
            return forgeTickets;
        }
    }

    private class SpongeLoadingCallback
    implements ForgeChunkManager.LoadingCallback {
        ChunkTicketManager.Callback spongeLoadingCallback;

        SpongeLoadingCallback(ChunkTicketManager.Callback callback) {
            this.spongeLoadingCallback = callback;
        }

        public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, net.minecraft.world.World world) {
            ArrayList<SpongeLoadingTicket> loadingTickets = new ArrayList<SpongeLoadingTicket>();
            for (ForgeChunkManager.Ticket ticket : tickets) {
                loadingTickets.add(new SpongeLoadingTicket(ticket));
            }
            this.spongeLoadingCallback.onLoaded((ImmutableList<ChunkTicketManager.LoadingTicket>)new ImmutableList.Builder().addAll(loadingTickets).build(), (World)world);
        }
    }

    private class SpongePlayerEntityLoadingTicket
    extends SpongePlayerLoadingTicket
    implements ChunkTicketManager.PlayerEntityLoadingTicket {
        SpongePlayerEntityLoadingTicket(ForgeChunkManager.Ticket ticket) {
            super(ticket);
        }

        @Override
        public void bindToEntity(Entity entity) {
            this.forgeTicket.bindEntity((net.minecraft.entity.Entity)entity);
        }

        @Override
        public Entity getBoundEntity() {
            return (Entity)this.forgeTicket.getEntity();
        }
    }

    private class SpongePlayerLoadingTicket
    extends SpongeLoadingTicket
    implements ChunkTicketManager.PlayerLoadingTicket {
        SpongePlayerLoadingTicket(ForgeChunkManager.Ticket ticket) {
            super(ticket);
        }

        @Override
        public UUID getPlayerUniqueId() {
            return SpongeImpl.getGame().getServer().getPlayer(this.forgeTicket.getPlayerName()).get().getUniqueId();
        }
    }

    private class SpongeEntityLoadingTicket
    extends SpongeLoadingTicket
    implements ChunkTicketManager.EntityLoadingTicket {
        SpongeEntityLoadingTicket(ForgeChunkManager.Ticket ticket) {
            super(ticket);
        }

        @Override
        public void bindToEntity(Entity entity) {
            this.forgeTicket.bindEntity((net.minecraft.entity.Entity)entity);
        }

        @Override
        public Entity getBoundEntity() {
            return (Entity)this.forgeTicket.getEntity();
        }
    }

    private class SpongeLoadingTicket
    implements ChunkTicketManager.LoadingTicket {
        ForgeChunkManager.Ticket forgeTicket;
        private final PluginContainer plugin;
        private final String pluginId;
        @Nullable
        private ImmutableSet<Vector3i> chunkList;
        private final World world;

        SpongeLoadingTicket(ForgeChunkManager.Ticket ticket) {
            this.forgeTicket = ticket;
            this.plugin = SpongeImpl.getGame().getPluginManager().getPlugin(ticket.getModId()).get();
            this.pluginId = this.plugin.getId();
            this.world = (World)ticket.world;
        }

        @Override
        public boolean setNumChunks(int numChunks) {
            if (numChunks > this.getMaxNumChunks() || numChunks <= 0 && this.getMaxNumChunks() > 0) {
                return false;
            }
            this.forgeTicket.setChunkListDepth(numChunks);
            return true;
        }

        @Override
        public int getNumChunks() {
            return this.forgeTicket.getChunkListDepth();
        }

        @Override
        public int getMaxNumChunks() {
            return this.forgeTicket.getMaxChunkListDepth();
        }

        @Override
        public World getWorld() {
            return this.world;
        }

        @Override
        public DataContainer getCompanionData() {
            return NbtTranslator.getInstance().translate(this.forgeTicket.getModData());
        }

        @Override
        public void setCompanionData(DataContainer container) {
            ((MixinForgeChunkManager$Ticket)this.forgeTicket).setModData(NbtTranslator.getInstance().translate(container));
        }

        @Override
        public String getPlugin() {
            return this.pluginId;
        }

        @Override
        public ImmutableSet<Vector3i> getChunkList() {
            if (this.chunkList != null) {
                return this.chunkList;
            }
            HashSet<Vector3i> forgeChunkList = new HashSet<Vector3i>();
            for (ChunkPos chunkCoord : this.forgeTicket.getChunkList()) {
                forgeChunkList.add(new Vector3i(chunkCoord.field_77276_a, 0, chunkCoord.field_77275_b));
            }
            this.chunkList = new ImmutableSet.Builder().addAll(forgeChunkList).build();
            return this.chunkList;
        }

        @Override
        public void forceChunk(Vector3i chunk) {
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.forgeTicket, (ChunkPos)VecHelper.toChunkPos(chunk));
        }

        @Override
        public void unforceChunk(Vector3i chunk) {
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.forgeTicket, (ChunkPos)VecHelper.toChunkPos(chunk));
        }

        @Override
        public void prioritizeChunk(Vector3i chunk) {
            ForgeChunkManager.reorderChunk((ForgeChunkManager.Ticket)this.forgeTicket, (ChunkPos)VecHelper.toChunkPos(chunk));
        }

        @Override
        public void release() {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.forgeTicket);
        }
    }
}

