/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import net.buycraft.plugin.client.ApiClient;
import net.buycraft.plugin.client.ApiException;
import net.buycraft.plugin.data.Coupon;
import net.buycraft.plugin.data.RecentPayment;
import net.buycraft.plugin.data.responses.BuycraftError;
import net.buycraft.plugin.data.responses.CheckoutUrlResponse;
import net.buycraft.plugin.data.responses.CouponListing;
import net.buycraft.plugin.data.responses.CouponSingleListing;
import net.buycraft.plugin.data.responses.DueQueueInformation;
import net.buycraft.plugin.data.responses.Listing;
import net.buycraft.plugin.data.responses.QueueInformation;
import net.buycraft.plugin.data.responses.ServerInformation;
import net.buycraft.plugin.internal.okhttp3.CacheControl;
import net.buycraft.plugin.internal.okhttp3.Call;
import net.buycraft.plugin.internal.okhttp3.Callback;
import net.buycraft.plugin.internal.okhttp3.FormBody;
import net.buycraft.plugin.internal.okhttp3.OkHttpClient;
import net.buycraft.plugin.internal.okhttp3.Request;
import net.buycraft.plugin.internal.okhttp3.Response;
import net.buycraft.plugin.internal.okhttp3.ResponseBody;

public class ProductionApiClient
implements ApiClient {
    private static final String API_URL = "https://plugin.buycraft.net";
    private static final String API_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssX";
    private final Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssX").create();
    private final OkHttpClient httpClient;
    private final String secret;
    private Logger logger;

    public ProductionApiClient(String secret) {
        this(secret, new OkHttpClient());
    }

    public ProductionApiClient(String secret, OkHttpClient client) {
        this.secret = Objects.requireNonNull(secret, "secret");
        this.httpClient = Objects.requireNonNull(client, "client");
    }

    public ProductionApiClient(String secret, OkHttpClient client, Logger logger) {
        this.secret = Objects.requireNonNull(secret, "secret");
        this.httpClient = Objects.requireNonNull(client, "client");
        this.logger = logger;
    }

    private Request.Builder getBuilder(String endpoint) {
        return new Request.Builder().url(API_URL + endpoint).addHeader("X-Buycraft-Secret", this.secret).addHeader("Accept", "application/json").addHeader("User-Agent", "BuycraftX");
    }

    private ApiException handleError(Response response, ResponseBody body) throws IOException {
        String in = body.string();
        if (!Objects.equals(response.header("Content-Type"), "application/json")) {
            return new ApiException("Unexpected content-type " + response.header("Content-Type"), response.request(), response, in);
        }
        BuycraftError error = (BuycraftError)this.gson.fromJson(in, BuycraftError.class);
        if (error != null) {
            return new ApiException(error.getErrorMessage(), response.request(), response, in);
        }
        return new ApiException("Unknown error occurred whilst deserializing error object.", response.request(), response, in);
    }

    private <T> T get(String endpoint, Type type) throws IOException, ApiException {
        return this.get(endpoint, null, type);
    }

    /*
     * Exception decompiling
     */
    private <T> T get(String endpoint, CacheControl control, Type type) throws IOException, ApiException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public ServerInformation getServerInformation() throws IOException, ApiException {
        return (ServerInformation)this.get("/information", CacheControl.FORCE_NETWORK, (Type)((Object)ServerInformation.class));
    }

    @Override
    public Listing retrieveListing() throws IOException, ApiException {
        Listing listing = (Listing)this.get("/listing", CacheControl.FORCE_NETWORK, (Type)((Object)Listing.class));
        if (listing != null) {
            listing.order();
        }
        return listing;
    }

    @Override
    public QueueInformation retrieveOfflineQueue() throws IOException, ApiException {
        return (QueueInformation)this.get("/queue/offline-commands", CacheControl.FORCE_NETWORK, (Type)((Object)QueueInformation.class));
    }

    @Override
    public DueQueueInformation retrieveDueQueue() throws IOException, ApiException {
        return (DueQueueInformation)this.get("/queue", CacheControl.FORCE_NETWORK, (Type)((Object)DueQueueInformation.class));
    }

    @Override
    public QueueInformation getPlayerQueue(int id) throws IOException, ApiException {
        return (QueueInformation)this.get("/queue/online-commands/" + id, CacheControl.FORCE_NETWORK, (Type)((Object)QueueInformation.class));
    }

    @Override
    public void deleteCommand(List<Integer> ids) throws IOException, ApiException {
        FormBody.Builder builder = new FormBody.Builder();
        for (Integer id : ids) {
            builder.add("ids[]", id.toString());
        }
        Request request = this.getBuilder("/queue").method("DELETE", builder.build()).build();
        this.httpClient.newBuilder().connectTimeout(6L, TimeUnit.SECONDS).writeTimeout(7L, TimeUnit.SECONDS).readTimeout(7L, TimeUnit.SECONDS).build().newCall(request).enqueue(new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
                System.out.println("Error when trying to mark commands as complete...");
                e.printStackTrace();
            }

            @Override
            public void onResponse(Call call, Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (!response.isSuccessful()) {
                        System.out.println("Error when trying to mark commands as complete...");
                        System.out.println(response.body());
                    }
                }
            }
        });
    }

    @Override
    public CheckoutUrlResponse getCheckoutUri(String username, int packageId) throws IOException, ApiException {
        FormBody body = new FormBody.Builder().add("username", username).add("package_id", Integer.toString(packageId)).build();
        Request request = this.getBuilder("/checkout").post(body).build();
        Response response = this.httpClient.newCall(request).execute();
        try (ResponseBody rspBody = response.body();){
            if (!response.isSuccessful()) {
                throw this.handleError(response, rspBody);
            }
            CheckoutUrlResponse checkoutUrlResponse = (CheckoutUrlResponse)this.gson.fromJson(rspBody.charStream(), CheckoutUrlResponse.class);
            return checkoutUrlResponse;
        }
    }

    @Override
    public CheckoutUrlResponse getCategoryUri(String username, int categoryId) throws IOException, ApiException {
        FormBody body = new FormBody.Builder().add("username", username).add("category", "true").add("category_id", Integer.toString(categoryId)).build();
        Request request = this.getBuilder("/checkout").post(body).build();
        Response response = this.httpClient.newCall(request).execute();
        try (ResponseBody rspBody = response.body();){
            if (!response.isSuccessful()) {
                throw this.handleError(response, rspBody);
            }
            CheckoutUrlResponse checkoutUrlResponse = (CheckoutUrlResponse)this.gson.fromJson(rspBody.charStream(), CheckoutUrlResponse.class);
            return checkoutUrlResponse;
        }
    }

    @Override
    public List<RecentPayment> getRecentPayments(int limit) throws IOException, ApiException {
        return (List)this.get("/payments?limit=" + limit, CacheControl.FORCE_NETWORK, new TypeToken<List<RecentPayment>>(){}.getType());
    }

    @Override
    public List<Coupon> getAllCoupons() throws IOException, ApiException {
        CouponListing listing = (CouponListing)this.get("/coupons", (Type)((Object)CouponListing.class));
        if (listing == null) {
            return null;
        }
        return listing.getData();
    }

    @Override
    public Coupon getCoupon(int id) throws IOException, ApiException {
        CouponSingleListing listing = (CouponSingleListing)this.get("/coupons/" + id, (Type)((Object)CouponSingleListing.class));
        return listing.getData();
    }

    @Override
    public void deleteCoupon(int id) throws IOException, ApiException {
        Request request = this.getBuilder("/coupons/" + id).delete().build();
        Response response = this.httpClient.newCall(request).execute();
        try (ResponseBody rspBody = response.body();){
            if (!response.isSuccessful()) {
                throw this.handleError(response, rspBody);
            }
        }
    }

    @Override
    public void deleteCoupon(String id) throws IOException, ApiException {
        Request request = this.getBuilder("/coupons/" + id + "/code").delete().build();
        Response response = this.httpClient.newCall(request).execute();
        try (ResponseBody rspBody = response.body();){
            if (!response.isSuccessful()) {
                throw this.handleError(response, rspBody);
            }
        }
    }

    @Override
    public Coupon createCoupon(Coupon coupon) throws IOException, ApiException {
        FormBody.Builder build = new FormBody.Builder().add("code", coupon.getCode()).add("effective_on", coupon.getEffective().getType());
        switch (coupon.getEffective().getType()) {
            case "packages": {
                for (Integer id1 : coupon.getEffective().getPackages()) {
                    build.add("packages[]", Integer.toString(id1));
                }
                break;
            }
            case "categories": {
                for (Integer id2 : coupon.getEffective().getCategories()) {
                    build.add("categories[]", Integer.toString(id2));
                }
                break;
            }
        }
        FormBody body = build.add("discount_type", coupon.getDiscount().getType()).add("discount_amount", coupon.getDiscount().getValue().toPlainString()).add("discount_percentage", coupon.getDiscount().getPercentage().toPlainString()).add("expire_type", coupon.getExpire().getType()).add("expire_limit", Integer.toString(coupon.getExpire().getLimit())).add("expire_date", new SimpleDateFormat(API_DATE_FORMAT).format(coupon.getExpire().getDate())).add("start_date", new SimpleDateFormat(API_DATE_FORMAT).format(coupon.getStartDate())).add("basket_type", coupon.getBasketType()).add("minimum", coupon.getMinimum().toPlainString()).add("redeem_limit", Integer.toString(coupon.getUserLimit())).add("discount_application_method", Integer.toString(coupon.getDiscountMethod())).add("redeem_unlimited", coupon.getRedeemUnlimited() == 1 ? "true" : "false").add("expire_never", coupon.getExpireNever() == 1 ? "true" : "false").add("username", coupon.getUsername() == null ? "" : coupon.getUsername()).add("note", coupon.getNote() == null ? "" : coupon.getNote()).build();
        Request request = this.getBuilder("/coupons").post(body).build();
        Response response = this.httpClient.newCall(request).execute();
        try (ResponseBody rspBody = response.body();){
            if (!response.isSuccessful()) {
                throw this.handleError(response, rspBody);
            }
            Coupon coupon2 = ((CouponSingleListing)this.gson.fromJson(rspBody.charStream(), CouponSingleListing.class)).getData();
            return coupon2;
        }
    }
}

