/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.data;

import com.google.common.collect.ImmutableList;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.buycraft.plugin.data.Package;

public final class Category
implements Comparable<Category> {
    private final int id;
    private final int order;
    private final String name;
    private final List<Package> packages;
    private final List<Category> subcategories;
    private final String gui_item;

    @Override
    public int compareTo(Category o) {
        Objects.requireNonNull(o, "category");
        return Integer.compare(this.order, o.getOrder());
    }

    public List<Category> getSubcategories() {
        return this.subcategories == null ? ImmutableList.of() : this.subcategories;
    }

    public void order() {
        Collections.sort(this.packages);
        if (this.subcategories != null) {
            Collections.sort(this.subcategories);
            for (Category category : this.subcategories) {
                category.order();
            }
        }
    }

    @ConstructorProperties(value={"id", "order", "name", "packages", "subcategories", "gui_item"})
    public Category(int id, int order, String name, List<Package> packages, List<Category> subcategories, String gui_item) {
        this.id = id;
        this.order = order;
        this.name = name;
        this.packages = packages;
        this.subcategories = subcategories;
        this.gui_item = gui_item;
    }

    public int getId() {
        return this.id;
    }

    public int getOrder() {
        return this.order;
    }

    public String getName() {
        return this.name;
    }

    public List<Package> getPackages() {
        return this.packages;
    }

    public String getGui_item() {
        return this.gui_item;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Category)) {
            return false;
        }
        Category other = (Category)o;
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getOrder() != other.getOrder()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<Package> this$packages = this.getPackages();
        List<Package> other$packages = other.getPackages();
        if (this$packages == null ? other$packages != null : !((Object)this$packages).equals(other$packages)) {
            return false;
        }
        List<Category> this$subcategories = this.getSubcategories();
        List<Category> other$subcategories = other.getSubcategories();
        if (this$subcategories == null ? other$subcategories != null : !((Object)this$subcategories).equals(other$subcategories)) {
            return false;
        }
        String this$gui_item = this.getGui_item();
        String other$gui_item = other.getGui_item();
        return !(this$gui_item == null ? other$gui_item != null : !this$gui_item.equals(other$gui_item));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        result = result * 59 + this.getOrder();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 0 : $name.hashCode());
        List<Package> $packages = this.getPackages();
        result = result * 59 + ($packages == null ? 0 : ((Object)$packages).hashCode());
        List<Category> $subcategories = this.getSubcategories();
        result = result * 59 + ($subcategories == null ? 0 : ((Object)$subcategories).hashCode());
        String $gui_item = this.getGui_item();
        result = result * 59 + ($gui_item == null ? 0 : $gui_item.hashCode());
        return result;
    }

    public String toString() {
        return "Category(id=" + this.getId() + ", order=" + this.getOrder() + ", name=" + this.getName() + ", packages=" + this.getPackages() + ", subcategories=" + this.getSubcategories() + ", gui_item=" + this.getGui_item() + ")";
    }
}

