/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.data;

import com.google.gson.annotations.SerializedName;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

public final class Coupon {
    private final int id;
    private final String code;
    private final Effective effective;
    private final Discount discount;
    private final Expire expire;
    @SerializedName(value="basket_type")
    private final String basketType;
    @SerializedName(value="start_date")
    private final Date startDate;
    @SerializedName(value="user_limit")
    private final int userLimit;
    @SerializedName(value="discount_application_method")
    private final int discountMethod;
    @SerializedName(value="expire_never")
    private final int expireNever;
    @SerializedName(value="redeem_unlimited")
    private final int redeemUnlimited;
    private final BigDecimal minimum;
    @SerializedName(value="username")
    private final String username;
    @SerializedName(value="note")
    private final String note;

    Coupon(int id, String code, Effective effective, Discount discount, Expire expire, String basketType, Date startDate, int userLimit, int discountMethod, int expireNever, int redeemUnlimited, BigDecimal minimum, String username, String note) {
        this.id = id;
        this.code = code;
        this.effective = effective;
        this.discount = discount;
        this.expire = expire;
        this.basketType = basketType;
        this.startDate = startDate;
        this.userLimit = userLimit;
        this.discountMethod = discountMethod;
        this.expireNever = expireNever;
        this.redeemUnlimited = redeemUnlimited;
        this.minimum = minimum;
        this.username = username;
        this.note = note;
    }

    public static CouponBuilder builder() {
        return new CouponBuilder();
    }

    public int getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public Effective getEffective() {
        return this.effective;
    }

    public Discount getDiscount() {
        return this.discount;
    }

    public Expire getExpire() {
        return this.expire;
    }

    public String getBasketType() {
        return this.basketType;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public int getUserLimit() {
        return this.userLimit;
    }

    public int getDiscountMethod() {
        return this.discountMethod;
    }

    public int getExpireNever() {
        return this.expireNever;
    }

    public int getRedeemUnlimited() {
        return this.redeemUnlimited;
    }

    public BigDecimal getMinimum() {
        return this.minimum;
    }

    public String getUsername() {
        return this.username;
    }

    public String getNote() {
        return this.note;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Coupon)) {
            return false;
        }
        Coupon other = (Coupon)o;
        if (this.getId() != other.getId()) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        Effective this$effective = this.getEffective();
        Effective other$effective = other.getEffective();
        if (this$effective == null ? other$effective != null : !((Object)this$effective).equals(other$effective)) {
            return false;
        }
        Discount this$discount = this.getDiscount();
        Discount other$discount = other.getDiscount();
        if (this$discount == null ? other$discount != null : !((Object)this$discount).equals(other$discount)) {
            return false;
        }
        Expire this$expire = this.getExpire();
        Expire other$expire = other.getExpire();
        if (this$expire == null ? other$expire != null : !((Object)this$expire).equals(other$expire)) {
            return false;
        }
        String this$basketType = this.getBasketType();
        String other$basketType = other.getBasketType();
        if (this$basketType == null ? other$basketType != null : !this$basketType.equals(other$basketType)) {
            return false;
        }
        Date this$startDate = this.getStartDate();
        Date other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        if (this.getUserLimit() != other.getUserLimit()) {
            return false;
        }
        if (this.getDiscountMethod() != other.getDiscountMethod()) {
            return false;
        }
        if (this.getExpireNever() != other.getExpireNever()) {
            return false;
        }
        if (this.getRedeemUnlimited() != other.getRedeemUnlimited()) {
            return false;
        }
        BigDecimal this$minimum = this.getMinimum();
        BigDecimal other$minimum = other.getMinimum();
        if (this$minimum == null ? other$minimum != null : !((Object)this$minimum).equals(other$minimum)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$note = this.getNote();
        String other$note = other.getNote();
        return !(this$note == null ? other$note != null : !this$note.equals(other$note));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 0 : $code.hashCode());
        Effective $effective = this.getEffective();
        result = result * 59 + ($effective == null ? 0 : ((Object)$effective).hashCode());
        Discount $discount = this.getDiscount();
        result = result * 59 + ($discount == null ? 0 : ((Object)$discount).hashCode());
        Expire $expire = this.getExpire();
        result = result * 59 + ($expire == null ? 0 : ((Object)$expire).hashCode());
        String $basketType = this.getBasketType();
        result = result * 59 + ($basketType == null ? 0 : $basketType.hashCode());
        Date $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 0 : ((Object)$startDate).hashCode());
        result = result * 59 + this.getUserLimit();
        result = result * 59 + this.getDiscountMethod();
        result = result * 59 + this.getExpireNever();
        result = result * 59 + this.getRedeemUnlimited();
        BigDecimal $minimum = this.getMinimum();
        result = result * 59 + ($minimum == null ? 0 : ((Object)$minimum).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 0 : $username.hashCode());
        String $note = this.getNote();
        result = result * 59 + ($note == null ? 0 : $note.hashCode());
        return result;
    }

    public String toString() {
        return "Coupon(id=" + this.getId() + ", code=" + this.getCode() + ", effective=" + this.getEffective() + ", discount=" + this.getDiscount() + ", expire=" + this.getExpire() + ", basketType=" + this.getBasketType() + ", startDate=" + this.getStartDate() + ", userLimit=" + this.getUserLimit() + ", discountMethod=" + this.getDiscountMethod() + ", expireNever=" + this.getExpireNever() + ", redeemUnlimited=" + this.getRedeemUnlimited() + ", minimum=" + this.getMinimum() + ", username=" + this.getUsername() + ", note=" + this.getNote() + ")";
    }

    public static class CouponBuilder {
        private int id;
        private String code;
        private Effective effective;
        private Discount discount;
        private Expire expire;
        private String basketType;
        private Date startDate;
        private int userLimit;
        private int discountMethod;
        private int expireNever;
        private int redeemUnlimited;
        private BigDecimal minimum;
        private String username;
        private String note;

        CouponBuilder() {
        }

        public CouponBuilder id(int id) {
            this.id = id;
            return this;
        }

        public CouponBuilder code(String code) {
            this.code = code;
            return this;
        }

        public CouponBuilder effective(Effective effective) {
            this.effective = effective;
            return this;
        }

        public CouponBuilder discount(Discount discount) {
            this.discount = discount;
            return this;
        }

        public CouponBuilder expire(Expire expire) {
            this.expire = expire;
            return this;
        }

        public CouponBuilder basketType(String basketType) {
            this.basketType = basketType;
            return this;
        }

        public CouponBuilder startDate(Date startDate) {
            this.startDate = startDate;
            return this;
        }

        public CouponBuilder userLimit(int userLimit) {
            this.userLimit = userLimit;
            return this;
        }

        public CouponBuilder discountMethod(int discountMethod) {
            this.discountMethod = discountMethod;
            return this;
        }

        public CouponBuilder expireNever(int expireNever) {
            this.expireNever = expireNever;
            return this;
        }

        public CouponBuilder redeemUnlimited(int redeemUnlimited) {
            this.redeemUnlimited = redeemUnlimited;
            return this;
        }

        public CouponBuilder minimum(BigDecimal minimum) {
            this.minimum = minimum;
            return this;
        }

        public CouponBuilder username(String username) {
            this.username = username;
            return this;
        }

        public CouponBuilder note(String note) {
            this.note = note;
            return this;
        }

        public Coupon build() {
            return new Coupon(this.id, this.code, this.effective, this.discount, this.expire, this.basketType, this.startDate, this.userLimit, this.discountMethod, this.expireNever, this.redeemUnlimited, this.minimum, this.username, this.note);
        }

        public String toString() {
            return "Coupon.CouponBuilder(id=" + this.id + ", code=" + this.code + ", effective=" + this.effective + ", discount=" + this.discount + ", expire=" + this.expire + ", basketType=" + this.basketType + ", startDate=" + this.startDate + ", userLimit=" + this.userLimit + ", discountMethod=" + this.discountMethod + ", expireNever=" + this.expireNever + ", redeemUnlimited=" + this.redeemUnlimited + ", minimum=" + this.minimum + ", username=" + this.username + ", note=" + this.note + ")";
        }
    }

    public static final class Expire {
        private final String type;
        private final int limit;
        private final Date date;

        @ConstructorProperties(value={"type", "limit", "date"})
        public Expire(String type, int limit, Date date) {
            this.type = type;
            this.limit = limit;
            this.date = date;
        }

        public String getType() {
            return this.type;
        }

        public int getLimit() {
            return this.limit;
        }

        public Date getDate() {
            return this.date;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Expire)) {
                return false;
            }
            Expire other = (Expire)o;
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            if (this.getLimit() != other.getLimit()) {
                return false;
            }
            Date this$date = this.getDate();
            Date other$date = other.getDate();
            return !(this$date == null ? other$date != null : !((Object)this$date).equals(other$date));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 0 : $type.hashCode());
            result = result * 59 + this.getLimit();
            Date $date = this.getDate();
            result = result * 59 + ($date == null ? 0 : ((Object)$date).hashCode());
            return result;
        }

        public String toString() {
            return "Coupon.Expire(type=" + this.getType() + ", limit=" + this.getLimit() + ", date=" + this.getDate() + ")";
        }
    }

    public static final class Discount {
        private final String type;
        private final BigDecimal percentage;
        private final BigDecimal value;

        @ConstructorProperties(value={"type", "percentage", "value"})
        public Discount(String type, BigDecimal percentage, BigDecimal value) {
            this.type = type;
            this.percentage = percentage;
            this.value = value;
        }

        public String getType() {
            return this.type;
        }

        public BigDecimal getPercentage() {
            return this.percentage;
        }

        public BigDecimal getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Discount)) {
                return false;
            }
            Discount other = (Discount)o;
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            BigDecimal this$percentage = this.getPercentage();
            BigDecimal other$percentage = other.getPercentage();
            if (this$percentage == null ? other$percentage != null : !((Object)this$percentage).equals(other$percentage)) {
                return false;
            }
            BigDecimal this$value = this.getValue();
            BigDecimal other$value = other.getValue();
            return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 0 : $type.hashCode());
            BigDecimal $percentage = this.getPercentage();
            result = result * 59 + ($percentage == null ? 0 : ((Object)$percentage).hashCode());
            BigDecimal $value = this.getValue();
            result = result * 59 + ($value == null ? 0 : ((Object)$value).hashCode());
            return result;
        }

        public String toString() {
            return "Coupon.Discount(type=" + this.getType() + ", percentage=" + this.getPercentage() + ", value=" + this.getValue() + ")";
        }
    }

    public static final class Effective {
        private final String type;
        private final List<Integer> packages;
        private final List<Integer> categories;

        @ConstructorProperties(value={"type", "packages", "categories"})
        public Effective(String type, List<Integer> packages, List<Integer> categories) {
            this.type = type;
            this.packages = packages;
            this.categories = categories;
        }

        public String getType() {
            return this.type;
        }

        public List<Integer> getPackages() {
            return this.packages;
        }

        public List<Integer> getCategories() {
            return this.categories;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Effective)) {
                return false;
            }
            Effective other = (Effective)o;
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            List<Integer> this$packages = this.getPackages();
            List<Integer> other$packages = other.getPackages();
            if (this$packages == null ? other$packages != null : !((Object)this$packages).equals(other$packages)) {
                return false;
            }
            List<Integer> this$categories = this.getCategories();
            List<Integer> other$categories = other.getCategories();
            return !(this$categories == null ? other$categories != null : !((Object)this$categories).equals(other$categories));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 0 : $type.hashCode());
            List<Integer> $packages = this.getPackages();
            result = result * 59 + ($packages == null ? 0 : ((Object)$packages).hashCode());
            List<Integer> $categories = this.getCategories();
            result = result * 59 + ($categories == null ? 0 : ((Object)$categories).hashCode());
            return result;
        }

        public String toString() {
            return "Coupon.Effective(type=" + this.getType() + ", packages=" + this.getPackages() + ", categories=" + this.getCategories() + ")";
        }
    }
}

