/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.data;

import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.Objects;

public final class Package
implements Comparable<Package> {
    private final int id;
    private final int order;
    private final String name;
    private final BigDecimal price;
    private final Sale sale;
    private final String gui_item;

    @Override
    public int compareTo(Package o) {
        Objects.requireNonNull(o, "package");
        return Integer.compare(this.order, o.getOrder());
    }

    public BigDecimal getEffectivePrice() {
        BigDecimal rounded = this.price.setScale(2, 4);
        if (this.sale == null) {
            return rounded;
        }
        return rounded.subtract(this.sale.getDiscount().setScale(2, 4));
    }

    @ConstructorProperties(value={"id", "order", "name", "price", "sale", "gui_item"})
    public Package(int id, int order, String name, BigDecimal price, Sale sale, String gui_item) {
        this.id = id;
        this.order = order;
        this.name = name;
        this.price = price;
        this.sale = sale;
        this.gui_item = gui_item;
    }

    public int getId() {
        return this.id;
    }

    public int getOrder() {
        return this.order;
    }

    public String getName() {
        return this.name;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public Sale getSale() {
        return this.sale;
    }

    public String getGui_item() {
        return this.gui_item;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Package)) {
            return false;
        }
        Package other = (Package)o;
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getOrder() != other.getOrder()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        BigDecimal this$price = this.getPrice();
        BigDecimal other$price = other.getPrice();
        if (this$price == null ? other$price != null : !((Object)this$price).equals(other$price)) {
            return false;
        }
        Sale this$sale = this.getSale();
        Sale other$sale = other.getSale();
        if (this$sale == null ? other$sale != null : !((Object)this$sale).equals(other$sale)) {
            return false;
        }
        String this$gui_item = this.getGui_item();
        String other$gui_item = other.getGui_item();
        return !(this$gui_item == null ? other$gui_item != null : !this$gui_item.equals(other$gui_item));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        result = result * 59 + this.getOrder();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 0 : $name.hashCode());
        BigDecimal $price = this.getPrice();
        result = result * 59 + ($price == null ? 0 : ((Object)$price).hashCode());
        Sale $sale = this.getSale();
        result = result * 59 + ($sale == null ? 0 : ((Object)$sale).hashCode());
        String $gui_item = this.getGui_item();
        result = result * 59 + ($gui_item == null ? 0 : $gui_item.hashCode());
        return result;
    }

    public String toString() {
        return "Package(id=" + this.getId() + ", order=" + this.getOrder() + ", name=" + this.getName() + ", price=" + this.getPrice() + ", sale=" + this.getSale() + ", gui_item=" + this.getGui_item() + ")";
    }

    public static final class Sale {
        private final boolean active;
        private final BigDecimal discount;

        @ConstructorProperties(value={"active", "discount"})
        public Sale(boolean active, BigDecimal discount) {
            this.active = active;
            this.discount = discount;
        }

        public boolean isActive() {
            return this.active;
        }

        public BigDecimal getDiscount() {
            return this.discount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Sale)) {
                return false;
            }
            Sale other = (Sale)o;
            if (this.isActive() != other.isActive()) {
                return false;
            }
            BigDecimal this$discount = this.getDiscount();
            BigDecimal other$discount = other.getDiscount();
            return !(this$discount == null ? other$discount != null : !((Object)this$discount).equals(other$discount));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isActive() ? 79 : 97);
            BigDecimal $discount = this.getDiscount();
            result = result * 59 + ($discount == null ? 0 : ((Object)$discount).hashCode());
            return result;
        }

        public String toString() {
            return "Package.Sale(active=" + this.isActive() + ", discount=" + this.getDiscount() + ")";
        }
    }
}

