/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.execution;

import com.google.common.collect.ImmutableList;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import net.buycraft.plugin.IBuycraftPlatform;
import net.buycraft.plugin.client.ApiException;
import net.buycraft.plugin.data.QueuedPlayer;
import net.buycraft.plugin.data.responses.DueQueueInformation;
import net.buycraft.plugin.execution.ImmediateCommandExecutor;
import net.buycraft.plugin.execution.PlayerCommandExecutor;

public class DuePlayerFetcher
implements Runnable {
    private static final int FALLBACK_CHECK_BACK_SECS = 300;
    private static final int MAXIMUM_ONLINE_PLAYERS_TO_EXECUTE = 60;
    private static final int DELAY_BETWEEN_PLAYERS = 500;
    private final IBuycraftPlatform platform;
    private final Map<String, QueuedPlayer> due = new HashMap<String, QueuedPlayer>();
    private final Lock lock = new ReentrantLock();
    private final AtomicBoolean inProgress = new AtomicBoolean(false);
    private final boolean verbose;
    private final Random random = new Random();

    public boolean inProgress() {
        return this.inProgress.get();
    }

    @Override
    public void run() {
        this.run(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(boolean scheduleAgain) {
        if (this.platform.getApiClient() == null) {
            return;
        }
        if (!this.inProgress.compareAndSet(false, true)) {
            this.platform.log(Level.INFO, "Already fetching due player information!");
            return;
        }
        int nextCheck = 300;
        try {
            DueQueueInformation information;
            if (this.verbose) {
                this.platform.log(Level.INFO, "Fetching all due players...");
            }
            HashMap<String, QueuedPlayer> allDue = new HashMap<String, QueuedPlayer>();
            do {
                block21: {
                    information = this.platform.getApiClient().retrieveDueQueue();
                    if (information != null) break block21;
                    return;
                }
                try {
                    nextCheck = information.getMeta().getNextCheck();
                }
                catch (IOException | ApiException e) {
                    this.platform.log(Level.SEVERE, "Could not fetch due players queue", e);
                    this.inProgress.set(false);
                    if (scheduleAgain) {
                        this.platform.executeAsyncLater(this, nextCheck, TimeUnit.SECONDS);
                    }
                    return;
                }
                for (QueuedPlayer player : information.getPlayers()) {
                    allDue.put(player.getName().toLowerCase(Locale.US), player);
                }
            } while (information.getMeta().isMore());
            if (this.verbose) {
                this.platform.log(Level.INFO, String.format("Fetched due players (%d found).", allDue.size()));
            }
            if (information.getMeta().isExecuteOffline()) {
                if (this.verbose) {
                    this.platform.log(Level.INFO, "Executing commands that can be completed now...");
                }
                this.platform.executeAsync(new ImmediateCommandExecutor(this.platform));
            }
            this.lock.lock();
            try {
                this.due.clear();
                this.due.putAll(allDue);
            }
            finally {
                this.lock.unlock();
            }
            this.processOnlinePlayers();
        }
        finally {
            this.inProgress.set(false);
            if (scheduleAgain) {
                this.platform.executeAsyncLater(this, nextCheck, TimeUnit.SECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processOnlinePlayers() {
        QueuedPlayer qp;
        ArrayList<QueuedPlayer> processNow = new ArrayList<QueuedPlayer>();
        this.lock.lock();
        try {
            Iterator<QueuedPlayer> it = this.due.values().iterator();
            while (it.hasNext()) {
                qp = it.next();
                if (!this.platform.isPlayerOnline(qp) || processNow.size() >= 60) continue;
                processNow.add(qp);
                it.remove();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (!processNow.isEmpty()) {
            if (this.verbose) {
                this.platform.log(Level.INFO, String.format("Executing commands for %d online players...", processNow.size()));
            }
            for (int i = 0; i < processNow.size(); ++i) {
                qp = (QueuedPlayer)processNow.get(i);
                this.platform.executeAsyncLater(new PlayerCommandExecutor(qp, this.platform), 500 * (i + 1), TimeUnit.MILLISECONDS);
            }
        }
    }

    public Collection<QueuedPlayer> getDuePlayers() {
        this.lock.lock();
        try {
            ImmutableList immutableList = ImmutableList.copyOf(this.due.values());
            return immutableList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public QueuedPlayer fetchAndRemoveDuePlayer(String name) {
        this.lock.lock();
        try {
            QueuedPlayer queuedPlayer = this.due.remove(name.toLowerCase(Locale.US));
            return queuedPlayer;
        }
        finally {
            this.lock.unlock();
        }
    }

    @ConstructorProperties(value={"platform", "verbose"})
    public DuePlayerFetcher(IBuycraftPlatform platform, boolean verbose) {
        this.platform = platform;
        this.verbose = verbose;
    }
}

