/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.execution.strategy;

import com.google.common.collect.Lists;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import net.buycraft.plugin.IBuycraftPlatform;
import net.buycraft.plugin.client.ApiException;

public class PostCompletedCommandsTask
implements Runnable {
    private static final int MAXIMUM_COMMANDS_TO_POST = 50;
    private final Queue<Integer> completed = new ConcurrentLinkedQueue<Integer>();
    private final ArrayList<Integer> retainedCompleted = new ArrayList();
    private final IBuycraftPlatform platform;

    @Override
    public void run() {
        Integer posted;
        ArrayList<Integer> commandsToPost = new ArrayList<Integer>();
        while (commandsToPost.size() < 50 && (posted = this.completed.poll()) != null) {
            commandsToPost.add(posted);
        }
        if (!commandsToPost.isEmpty()) {
            try {
                this.platform.getApiClient().deleteCommand(commandsToPost);
            }
            catch (IOException | ApiException e) {
                this.platform.log(Level.SEVERE, "Unable to mark commands as completed", e);
            }
        }
    }

    public void add(Integer id) {
        this.completed.add(id);
        this.retainedCompleted.add(id);
    }

    public ArrayList getRetained() {
        return this.retainedCompleted;
    }

    public void flush() {
        if (!this.completed.isEmpty()) {
            for (List list : Lists.partition(new ArrayList<Integer>(this.completed), (int)50)) {
                try {
                    this.platform.getApiClient().deleteCommand(list);
                }
                catch (IOException | ApiException e) {
                    this.platform.log(Level.SEVERE, "Unable to mark commands as completed", e);
                    break;
                }
            }
        }
    }

    @ConstructorProperties(value={"platform"})
    public PostCompletedCommandsTask(IBuycraftPlatform platform) {
        this.platform = platform;
    }
}

