/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.execution.strategy;

import java.beans.ConstructorProperties;
import java.util.concurrent.TimeUnit;
import net.buycraft.plugin.IBuycraftPlatform;
import net.buycraft.plugin.data.QueuedCommand;
import net.buycraft.plugin.data.QueuedPlayer;

public final class ToRunQueuedCommand {
    private final QueuedPlayer player;
    private final QueuedCommand command;
    private final boolean requireOnline;
    private final long queueTime = System.currentTimeMillis();

    public boolean canExecute(IBuycraftPlatform platform) {
        int free;
        Integer requiredSlots = this.command.getConditions().get("slots");
        if ((requiredSlots != null || this.requireOnline) && !platform.isPlayerOnline(this.player)) {
            return false;
        }
        if (requiredSlots != null && (free = platform.getFreeSlots(this.player)) < requiredSlots) {
            return false;
        }
        Integer delay = this.command.getConditions().get("delay");
        return delay == null || delay <= 0 || System.currentTimeMillis() - this.queueTime >= TimeUnit.SECONDS.toMillis(delay.intValue());
    }

    @ConstructorProperties(value={"player", "command", "requireOnline"})
    public ToRunQueuedCommand(QueuedPlayer player, QueuedCommand command, boolean requireOnline) {
        this.player = player;
        this.command = command;
        this.requireOnline = requireOnline;
    }

    public QueuedPlayer getPlayer() {
        return this.player;
    }

    public QueuedCommand getCommand() {
        return this.command;
    }

    public boolean isRequireOnline() {
        return this.requireOnline;
    }

    public long getQueueTime() {
        return this.queueTime;
    }

    public String toString() {
        return "ToRunQueuedCommand(player=" + this.getPlayer() + ", command=" + this.getCommand() + ", requireOnline=" + this.isRequireOnline() + ", queueTime=" + this.getQueueTime() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ToRunQueuedCommand)) {
            return false;
        }
        ToRunQueuedCommand other = (ToRunQueuedCommand)o;
        QueuedPlayer this$player = this.getPlayer();
        QueuedPlayer other$player = other.getPlayer();
        if (this$player == null ? other$player != null : !((Object)this$player).equals(other$player)) {
            return false;
        }
        QueuedCommand this$command = this.getCommand();
        QueuedCommand other$command = other.getCommand();
        if (this$command == null ? other$command != null : !((Object)this$command).equals(other$command)) {
            return false;
        }
        return this.isRequireOnline() == other.isRequireOnline();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        QueuedPlayer $player = this.getPlayer();
        result = result * 59 + ($player == null ? 0 : ((Object)$player).hashCode());
        QueuedCommand $command = this.getCommand();
        result = result * 59 + ($command == null ? 0 : ((Object)$command).hashCode());
        result = result * 59 + (this.isRequireOnline() ? 79 : 97);
        return result;
    }
}

