/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.internal.okio;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.buycraft.plugin.internal.okio.Buffer;
import net.buycraft.plugin.internal.okio.ByteString;
import net.buycraft.plugin.internal.okio.ForwardingSink;
import net.buycraft.plugin.internal.okio.Segment;
import net.buycraft.plugin.internal.okio.Sink;
import net.buycraft.plugin.internal.okio.Util;

public final class HashingSink
extends ForwardingSink {
    private final MessageDigest messageDigest;

    public static HashingSink md5(Sink sink) {
        return new HashingSink(sink, "MD5");
    }

    public static HashingSink sha1(Sink sink) {
        return new HashingSink(sink, "SHA-1");
    }

    public static HashingSink sha256(Sink sink) {
        return new HashingSink(sink, "SHA-256");
    }

    private HashingSink(Sink sink, String algorithm) {
        super(sink);
        try {
            this.messageDigest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError();
        }
    }

    @Override
    public void write(Buffer source, long byteCount) throws IOException {
        int toHash;
        Util.checkOffsetAndCount(source.size, 0L, byteCount);
        Segment s = source.head;
        for (long hashedCount = 0L; hashedCount < byteCount; hashedCount += (long)toHash) {
            toHash = (int)Math.min(byteCount - hashedCount, (long)(s.limit - s.pos));
            this.messageDigest.update(s.data, s.pos, toHash);
            s = s.next;
        }
        super.write(source, byteCount);
    }

    public ByteString hash() {
        byte[] result = this.messageDigest.digest();
        return ByteString.of(result);
    }
}

