/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.platform.standalone.runner;

import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Logger;
import lombok.NonNull;
import net.buycraft.plugin.platform.standalone.runner.CommandDispatcher;
import net.buycraft.plugin.platform.standalone.runner.PlayerDeterminer;
import net.buycraft.plugin.platform.standalone.runner.StandaloneBuycraftRunner;

public class StandaloneBuycraftRunnerBuilder {
    @NonNull
    private final CommandDispatcher dispatcher;
    @NonNull
    private final PlayerDeterminer determiner;
    @NonNull
    private final String apiKey;
    @NonNull
    private final Logger logger;
    @NonNull
    private final ScheduledExecutorService executorService;
    @NonNull
    private boolean verbose = true;

    public StandaloneBuycraftRunner start() {
        StandaloneBuycraftRunner runner = new StandaloneBuycraftRunner(this.dispatcher, this.determiner, this.apiKey, this.logger, this.executorService, this.verbose);
        runner.initializeTasks();
        return runner;
    }

    StandaloneBuycraftRunnerBuilder(@NonNull CommandDispatcher dispatcher, @NonNull PlayerDeterminer determiner, @NonNull String apiKey, @NonNull Logger logger, @NonNull ScheduledExecutorService executorService, @NonNull boolean verbose) {
        if (dispatcher == null) {
            throw new NullPointerException("dispatcher");
        }
        if (determiner == null) {
            throw new NullPointerException("determiner");
        }
        if (apiKey == null) {
            throw new NullPointerException("apiKey");
        }
        if (logger == null) {
            throw new NullPointerException("logger");
        }
        if (executorService == null) {
            throw new NullPointerException("executorService");
        }
        this.dispatcher = dispatcher;
        this.determiner = determiner;
        this.apiKey = apiKey;
        this.logger = logger;
        this.executorService = executorService;
        this.verbose = verbose;
    }

    public static StandaloneBuycraftRunnerBuilderBuilder builder() {
        return new StandaloneBuycraftRunnerBuilderBuilder();
    }

    public static class StandaloneBuycraftRunnerBuilderBuilder {
        private CommandDispatcher dispatcher;
        private PlayerDeterminer determiner;
        private String apiKey;
        private Logger logger;
        private ScheduledExecutorService executorService;
        private boolean verbose;

        StandaloneBuycraftRunnerBuilderBuilder() {
        }

        public StandaloneBuycraftRunnerBuilderBuilder dispatcher(CommandDispatcher dispatcher) {
            this.dispatcher = dispatcher;
            return this;
        }

        public StandaloneBuycraftRunnerBuilderBuilder determiner(PlayerDeterminer determiner) {
            this.determiner = determiner;
            return this;
        }

        public StandaloneBuycraftRunnerBuilderBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public StandaloneBuycraftRunnerBuilderBuilder logger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public StandaloneBuycraftRunnerBuilderBuilder executorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public StandaloneBuycraftRunnerBuilderBuilder verbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public StandaloneBuycraftRunnerBuilder build() {
            return new StandaloneBuycraftRunnerBuilder(this.dispatcher, this.determiner, this.apiKey, this.logger, this.executorService, this.verbose);
        }

        public String toString() {
            return "StandaloneBuycraftRunnerBuilder.StandaloneBuycraftRunnerBuilderBuilder(dispatcher=" + this.dispatcher + ", determiner=" + this.determiner + ", apiKey=" + this.apiKey + ", logger=" + this.logger + ", executorService=" + this.executorService + ", verbose=" + this.verbose + ")";
        }
    }
}

