/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.shared.config;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import net.buycraft.plugin.shared.config.BuycraftI18n;

public class BuycraftConfiguration {
    private final Properties properties = new Properties();

    private static String join(String separator, Collection<String> elements) {
        StringBuilder builder = new StringBuilder();
        for (String element : elements) {
            builder.append(element).append(separator);
        }
        builder.delete(builder.length() - separator.length(), builder.length());
        return builder.toString();
    }

    private void defaultSet(String key, String value) {
        if (this.properties.getProperty(key) == null) {
            this.properties.setProperty(key, value);
        }
    }

    public void load(Path path) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            this.properties.load(reader);
        }
    }

    public void save(Path path) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            this.properties.store(writer, "BuycraftX configuration file");
        }
    }

    public String getServerKey() {
        return this.properties.getProperty("server-key", null);
    }

    public boolean isPushCommandsEnabled() {
        return this.getBoolean("push-commands", false);
    }

    public Integer getPushCommandsPort() {
        String value = this.properties.getProperty("push-commands", "8282");
        if (value == null || value.equalsIgnoreCase("false")) {
            return null;
        }
        return Integer.valueOf(value);
    }

    public void setServerKey(String key) {
        this.properties.setProperty("server-key", key);
    }

    public List<String> getBuyCommandName() {
        return Arrays.asList(this.properties.getProperty("buy-command-name", "buy").split(","));
    }

    public void setBuyCommandName(List<String> keys) {
        this.properties.setProperty("buy-command-name", BuycraftConfiguration.join(",", keys));
    }

    public boolean isVerbose() {
        return this.getBoolean("verbose", true);
    }

    public void setVerbose(boolean verbose) {
        this.properties.setProperty("verbose", Boolean.toString(verbose));
    }

    private boolean getBoolean(String key, boolean val) {
        if (!this.properties.containsKey(key)) {
            return val;
        }
        return Boolean.parseBoolean(this.properties.getProperty(key));
    }

    public boolean isBungeeCord() {
        return this.getBoolean("is-bungeecord", false);
    }

    public boolean isCheckForUpdates() {
        return this.getBoolean("check-for-updates", true);
    }

    public boolean isDisableBuyCommand() {
        return this.getBoolean("disable-buy-command", false);
    }

    private Locale getLocale() {
        return Locale.forLanguageTag(this.properties.getProperty("language", "en_US"));
    }

    public BuycraftI18n createI18n() {
        return new BuycraftI18n(this.getLocale());
    }

    public int getCommandsPerTick() {
        return Integer.parseInt(this.properties.getProperty("commands-per-tick", "10"));
    }

    public void fillDefaults() {
        this.defaultSet("server-key", "INVALID");
        this.defaultSet("is-bungeecord", "false");
        this.defaultSet("check-for-updates", "true");
        this.defaultSet("disable-buy-command", "false");
        this.defaultSet("buy-command-name", "buy");
        this.defaultSet("language", Locale.getDefault().toLanguageTag());
        this.defaultSet("verbose", "true");
        this.defaultSet("push-commands", "false");
    }
}

