/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.shared.config;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class BuycraftI18n {
    private ResourceBundle bundle;
    private ResourceBundle userBundle;

    public BuycraftI18n(Locale locale) {
        this.bundle = ResourceBundle.getBundle("buycraftx_messages", locale);
    }

    public void loadUserBundle(Path resource) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(resource, StandardCharsets.UTF_8);){
            this.userBundle = new PropertyResourceBundle(reader);
        }
    }

    public String get(String message, Object ... params) {
        return MessageFormat.format(this.getBundleFor(message).getString(message), params);
    }

    public ResourceBundle getBundleFor(String message) {
        return this.userBundle != null && this.userBundle.containsKey(message) ? this.userBundle : this.bundle;
    }

    public ResourceBundle getBundle() {
        return this.bundle;
    }

    public ResourceBundle getUserBundle() {
        return this.userBundle;
    }
}

