/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.shared.tasks;

import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import net.buycraft.plugin.IBuycraftPlatform;
import net.buycraft.plugin.client.ApiException;
import net.buycraft.plugin.data.Category;
import net.buycraft.plugin.data.Package;
import net.buycraft.plugin.data.responses.Listing;

public class ListingUpdateTask
implements Runnable {
    private final IBuycraftPlatform platform;
    private final AtomicReference<Listing> listing = new AtomicReference();
    private final AtomicReference<Date> lastUpdate = new AtomicReference();
    private final Runnable updateTask;

    @Override
    public void run() {
        if (this.platform.getApiClient() == null) {
            return;
        }
        try {
            this.listing.set(this.platform.getApiClient().retrieveListing());
        }
        catch (IOException | ApiException e) {
            this.platform.log(Level.SEVERE, "Error whilst retrieving listing", e);
            return;
        }
        this.lastUpdate.set(new Date());
        if (this.updateTask != null) {
            this.updateTask.run();
        }
    }

    public Listing getListing() {
        return this.listing.get();
    }

    public Date getLastUpdate() {
        return this.lastUpdate.get();
    }

    public Package getPackageById(int id) {
        for (Category category : this.getListing().getCategories()) {
            Package p = this.doSearch(id, category);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    private Package doSearch(int id, Category category) {
        for (Package aPackage : category.getPackages()) {
            if (aPackage.getId() != id) continue;
            return aPackage;
        }
        for (Category sub : category.getSubcategories()) {
            Package p = this.doSearch(id, sub);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    @ConstructorProperties(value={"platform", "updateTask"})
    public ListingUpdateTask(IBuycraftPlatform platform, Runnable updateTask) {
        this.platform = platform;
        this.updateTask = updateTask;
    }
}

