/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.shared.tasks;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.buycraft.plugin.IBuycraftPlatform;
import net.buycraft.plugin.data.QueuedPlayer;
import net.buycraft.plugin.execution.PlayerCommandExecutor;

public class PlayerJoinCheckTask
implements Runnable {
    private final IBuycraftPlatform platform;
    private final Queue<QueuedPlayer> queuedPlayers = new ConcurrentLinkedQueue<QueuedPlayer>();

    public PlayerJoinCheckTask(IBuycraftPlatform platform) {
        this.platform = platform;
    }

    @Override
    public void run() {
        QueuedPlayer qp = this.queuedPlayers.poll();
        if (qp != null) {
            this.platform.executeAsync(new PlayerCommandExecutor(qp, this.platform));
        }
    }

    public void queue(QueuedPlayer player) {
        this.queuedPlayers.add(player);
    }
}

