/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.shared.util;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import net.buycraft.plugin.data.Coupon;

public class CouponUtil {
    private static final String ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final Random RANDOM = new Random();

    public static long parseDuration(String text) {
        long result = 0L;
        int numIdx = 0;
        for (int i = 0; i < text.length(); ++i) {
            char at = text.charAt(i);
            if (at == 'd' || at == 'w' || at == 'm' || at == 'h') {
                String ns = text.substring(numIdx, i);
                numIdx = i + 1;
                if (ns.isEmpty()) continue;
                int n = Integer.parseInt(ns);
                switch (at) {
                    case 'd': {
                        result += TimeUnit.DAYS.toMillis(n);
                        break;
                    }
                    case 'w': {
                        result += TimeUnit.DAYS.toMillis(n * 7);
                        break;
                    }
                    case 'h': {
                        result += TimeUnit.HOURS.toMillis(n);
                        break;
                    }
                    case 'm': {
                        result += TimeUnit.MINUTES.toMillis(n);
                    }
                }
                continue;
            }
            if (Character.isDigit(at)) continue;
            throw new IllegalArgumentException("Character " + at + " in position " + (i + 1) + " not valid");
        }
        return result;
    }

    public static String generateCode() {
        char[] cs = new char[10];
        for (int i = 0; i < cs.length; ++i) {
            cs[i] = ALPHABET.charAt(RANDOM.nextInt(ALPHABET.length()));
        }
        return new String(cs);
    }

    public static Coupon parseArguments(String[] args) {
        String discountMethod;
        HashMap<String, String> kv = new HashMap<String, String>();
        String k = null;
        for (String arg : args) {
            if (k == null) {
                k = arg;
                continue;
            }
            kv.put(k, arg);
            k = null;
        }
        Coupon.CouponBuilder builder = Coupon.builder().code(CouponUtil.generateCode()).effective(new Coupon.Effective("cart", (List<Integer>)ImmutableList.of(), (List<Integer>)ImmutableList.of())).basketType("both").startDate(new Date());
        String percentageStr = (String)kv.get("percentage");
        String valueStr = (String)kv.get("value");
        if (percentageStr == null && valueStr == null) {
            throw new IllegalArgumentException("percentage or value discount not found");
        }
        if (percentageStr != null && valueStr != null) {
            throw new IllegalArgumentException("percentage and value discounts are mutually exclusive");
        }
        if (percentageStr != null) {
            try {
                builder.discount(new Coupon.Discount("percentage", new BigDecimal(percentageStr), BigDecimal.ZERO));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("percentage is not valid (must be a number)");
            }
        }
        try {
            builder.discount(new Coupon.Discount("value", BigDecimal.ZERO, new BigDecimal(valueStr)));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("value is not valid (must be a number)");
        }
        String expiresStr = (String)kv.get("expires");
        String limitStr = (String)kv.get("limit");
        String neverExpire = "1";
        String unlimitedRedeem = "1";
        if (expiresStr != null) {
            neverExpire = "0";
            long ms = CouponUtil.parseDuration(expiresStr);
            if (ms == 0L) {
                throw new IllegalArgumentException("Invalid duration!");
            }
            builder.expire(new Coupon.Expire("timestamp", 0, new Date(System.currentTimeMillis() + ms)));
        }
        if (limitStr != null) {
            unlimitedRedeem = "0";
            try {
                builder.expire(new Coupon.Expire("limit", Integer.parseInt(limitStr), new Date()));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("limit is not valid (must be a number)");
            }
        }
        if (limitStr == null && expiresStr == null) {
            builder.expire(new Coupon.Expire("timestamp", 0, new Date(System.currentTimeMillis() + 1L)));
        }
        builder.expireNever(Integer.parseInt(neverExpire));
        builder.redeemUnlimited(Integer.parseInt(unlimitedRedeem));
        String minimumBasket = (String)kv.get("min_value");
        if (minimumBasket != null) {
            try {
                builder.minimum(new BigDecimal(minimumBasket));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("min_value is not valid (must be a number)");
            }
        } else {
            builder.minimum(BigDecimal.ZERO);
        }
        String perUserUses = (String)kv.get("user_limit");
        if (perUserUses != null) {
            try {
                builder.userLimit(Integer.parseInt(perUserUses));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("user_limit is not valid (must be a number)");
            }
        }
        if ((discountMethod = (String)kv.get("discount_application_method")) == null) {
            discountMethod = "0";
        }
        if (discountMethod.equals("0") || discountMethod.equals("1") || discountMethod.equals("2")) {
            try {
                builder.discountMethod(Integer.parseInt(discountMethod));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("discount_application_method is not valid (must be 0, 1 or 2)");
            }
        } else {
            throw new IllegalArgumentException("discount_application_method must be 0, 1 or 2");
        }
        String username = (String)kv.get("username");
        if (username == null) {
            username = "";
        }
        try {
            builder.username(String.valueOf(username));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("username must be a string");
        }
        if (kv.containsKey("note")) {
            String note = (String)kv.get("note");
            builder.note(String.valueOf(note));
        }
        return builder.build();
    }
}

