/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.sponge;

import com.google.gson.JsonParseException;
import com.google.inject.Inject;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import net.buycraft.plugin.IBuycraftPlatform;
import net.buycraft.plugin.client.ApiClient;
import net.buycraft.plugin.client.ApiException;
import net.buycraft.plugin.client.ProductionApiClient;
import net.buycraft.plugin.data.responses.ServerInformation;
import net.buycraft.plugin.execution.DuePlayerFetcher;
import net.buycraft.plugin.execution.placeholder.NamePlaceholder;
import net.buycraft.plugin.execution.placeholder.PlaceholderManager;
import net.buycraft.plugin.execution.placeholder.UuidPlaceholder;
import net.buycraft.plugin.execution.strategy.CommandExecutor;
import net.buycraft.plugin.execution.strategy.PostCompletedCommandsTask;
import net.buycraft.plugin.execution.strategy.QueuedCommandExecutor;
import net.buycraft.plugin.internal.okhttp3.OkHttpClient;
import net.buycraft.plugin.shared.Setup;
import net.buycraft.plugin.shared.config.BuycraftConfiguration;
import net.buycraft.plugin.shared.config.BuycraftI18n;
import net.buycraft.plugin.shared.config.signs.BuyNowSignLayout;
import net.buycraft.plugin.shared.config.signs.RecentPurchaseSignLayout;
import net.buycraft.plugin.shared.config.signs.storage.BuyNowSignStorage;
import net.buycraft.plugin.shared.config.signs.storage.RecentPurchaseSignStorage;
import net.buycraft.plugin.shared.tasks.ListingUpdateTask;
import net.buycraft.plugin.shared.tasks.PlayerJoinCheckTask;
import net.buycraft.plugin.shared.util.AnalyticsSend;
import net.buycraft.plugin.sponge.BuycraftListener;
import net.buycraft.plugin.sponge.SpongeBuycraftPlatform;
import net.buycraft.plugin.sponge.command.CouponCmd;
import net.buycraft.plugin.sponge.command.ForceCheckCmd;
import net.buycraft.plugin.sponge.command.InfoCmd;
import net.buycraft.plugin.sponge.command.ListPackagesCmd;
import net.buycraft.plugin.sponge.command.RefreshCmd;
import net.buycraft.plugin.sponge.command.ReportCmd;
import net.buycraft.plugin.sponge.command.SecretCmd;
import net.buycraft.plugin.sponge.httplistener.Handler;
import net.buycraft.plugin.sponge.logging.LoggerUtils;
import net.buycraft.plugin.sponge.signs.buynow.BuyNowSignListener;
import net.buycraft.plugin.sponge.signs.purchases.RecentPurchaseSignListener;
import net.buycraft.plugin.sponge.tasks.BuyNowSignUpdater;
import net.buycraft.plugin.sponge.tasks.SignUpdater;
import net.buycraft.plugin.sponge.util.VersionCheck;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.state.GamePreInitializationEvent;
import org.spongepowered.api.event.game.state.GameStoppingServerEvent;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.text.Text;

@Plugin(id="buycraft", name="Buycraft", version="11.0.0")
public class BuycraftPlugin {
    static final String MAGIC_VERSION = "SET_BY_MAGIC";
    private final PlaceholderManager placeholderManager = new PlaceholderManager();
    private final BuycraftConfiguration configuration = new BuycraftConfiguration();
    private ApiClient apiClient;
    private DuePlayerFetcher duePlayerFetcher;
    private ListingUpdateTask listingUpdateTask;
    private ServerInformation serverInformation;
    private RecentPurchaseSignStorage recentPurchaseSignStorage;
    private BuyNowSignStorage buyNowSignStorage;
    private OkHttpClient httpClient;
    private IBuycraftPlatform platform;
    private CommandExecutor commandExecutor;
    @Inject
    private Logger logger;
    private LoggerUtils loggerUtils;
    @Inject
    @ConfigDir(sharedRoot=false)
    private Path baseDirectory;
    private RecentPurchaseSignLayout recentPurchaseSignLayout = RecentPurchaseSignLayout.DEFAULT;
    private BuyNowSignLayout buyNowSignLayout = BuyNowSignLayout.DEFAULT;
    private BuycraftI18n i18n;
    private PostCompletedCommandsTask completedCommandsTask;
    private PlayerJoinCheckTask playerJoinCheckTask;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__org_kitteh_craftirc_sponge_util_versioning_Transform = true;

    @Listener
    public void onGamePreInitializationEvent(GamePreInitializationEvent event) {
        String serverKey;
        this.platform = new SpongeBuycraftPlatform(this);
        try {
            try {
                Files.createDirectory(this.baseDirectory, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
            Path configPath = this.baseDirectory.resolve("config.properties");
            try {
                this.configuration.load(configPath);
            }
            catch (NoSuchFileException e) {
                this.configuration.fillDefaults();
                this.configuration.save(configPath);
            }
        }
        catch (IOException e) {
            this.getLogger().error("Unable to load configuration! The plugin will disable itself now.", (Throwable)e);
            return;
        }
        this.i18n = this.configuration.createI18n();
        this.httpClient = Setup.okhttp(this.baseDirectory.resolve("cache").toFile());
        String curVersion = this.getClass().getAnnotation(Plugin.class).version();
        if (this.configuration.isCheckForUpdates()) {
            VersionCheck check = new VersionCheck(this, curVersion, this.configuration.getServerKey());
            try {
                check.verify();
            }
            catch (IOException e) {
                this.getLogger().error("Can't check for updates", (Throwable)e);
            }
            Sponge.getEventManager().registerListeners((Object)this, (Object)check);
        }
        if ((serverKey = this.configuration.getServerKey()) == null || serverKey.equals("INVALID")) {
            this.getLogger().info("Looks like this is a fresh setup. Get started by using 'buycraft secret <key>' in the console.");
        } else {
            this.getLogger().info("Validating your server key...");
            ProductionApiClient client = new ProductionApiClient(this.configuration.getServerKey(), this.httpClient);
            try {
                this.updateInformation(client);
            }
            catch (IOException | ApiException e) {
                this.getLogger().error(String.format("We can't check if your server can connect to Buycraft: %s", e.getMessage()));
            }
            this.apiClient = client;
        }
        Integer pushCommandsPort = this.configuration.getPushCommandsPort();
        if (pushCommandsPort != null) {
            this.initializeHttpListener(pushCommandsPort);
        }
        this.placeholderManager.addPlaceholder(new NamePlaceholder());
        this.placeholderManager.addPlaceholder(new UuidPlaceholder());
        this.duePlayerFetcher = new DuePlayerFetcher(this.platform, this.configuration.isVerbose());
        this.platform.executeAsyncLater(this.duePlayerFetcher, 1L, TimeUnit.SECONDS);
        this.completedCommandsTask = new PostCompletedCommandsTask(this.platform);
        this.commandExecutor = new QueuedCommandExecutor(this.platform, this.completedCommandsTask);
        Sponge.getScheduler().createTaskBuilder().intervalTicks(1L).delayTicks(1L).execute((Runnable)((Object)this.commandExecutor)).submit((Object)this);
        Sponge.getScheduler().createTaskBuilder().intervalTicks(20L).delayTicks(20L).async().execute((Runnable)this.completedCommandsTask).submit((Object)this);
        this.playerJoinCheckTask = new PlayerJoinCheckTask(this.platform);
        Sponge.getScheduler().createTaskBuilder().intervalTicks(20L).delayTicks(20L).execute((Runnable)this.playerJoinCheckTask).submit((Object)this);
        this.listingUpdateTask = new ListingUpdateTask(this.platform, null);
        if (this.apiClient != null) {
            this.getLogger().info("Fetching all server packages...");
            this.listingUpdateTask.run();
        }
        Sponge.getScheduler().createTaskBuilder().delayTicks(24000L).intervalTicks(24000L).execute((Runnable)this.listingUpdateTask).async().submit((Object)this);
        this.recentPurchaseSignStorage = new RecentPurchaseSignStorage();
        try {
            this.recentPurchaseSignStorage.load(this.baseDirectory.resolve("purchase_signs.json"));
        }
        catch (JsonParseException | IOException e) {
            this.logger.warn("Can't load purchase signs, continuing anyway", e);
        }
        this.buyNowSignStorage = new BuyNowSignStorage();
        try {
            this.buyNowSignStorage.load(this.baseDirectory.resolve("buy_now_signs.json"));
        }
        catch (JsonParseException | IOException e) {
            this.logger.warn("Can't load purchase signs, continuing anyway", e);
        }
        try {
            Path signLayoutDirectory = this.baseDirectory.resolve("sign_layouts");
            try {
                Files.createDirectory(signLayoutDirectory, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
            Path rpPath = signLayoutDirectory.resolve("recentpurchase.txt");
            Path bnPath = signLayoutDirectory.resolve("buynow.txt");
            try {
                Files.copy(this.getClass().getClassLoader().getResourceAsStream("sign_layouts/recentpurchase.txt"), rpPath, new CopyOption[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
            try {
                Files.copy(this.getClass().getClassLoader().getResourceAsStream("sign_layouts/buynow.txt"), bnPath, new CopyOption[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
            this.recentPurchaseSignLayout = new RecentPurchaseSignLayout(Files.readAllLines(rpPath, StandardCharsets.UTF_8));
            this.buyNowSignLayout = new BuyNowSignLayout(Files.readAllLines(bnPath, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            this.getLogger().error("Unable to load sign layouts", (Throwable)e);
        }
        Sponge.getScheduler().createTaskBuilder().delay(1L, TimeUnit.SECONDS).interval(15L, TimeUnit.MINUTES).execute((Runnable)new SignUpdater(this)).submit((Object)this);
        Sponge.getScheduler().createTaskBuilder().delay(1L, TimeUnit.SECONDS).interval(15L, TimeUnit.MINUTES).execute((Runnable)new BuyNowSignUpdater(this)).submit((Object)this);
        if (this.serverInformation != null) {
            Sponge.getScheduler().createTaskBuilder().delay(0L, TimeUnit.SECONDS).interval(1L, TimeUnit.DAYS).execute(() -> {
                try {
                    AnalyticsSend.postServerInformation(this.httpClient, this.configuration.getServerKey(), this.platform, Sponge.getServer().getOnlineMode());
                }
                catch (IOException e) {
                    this.getLogger().warn("Can't send analytics", (Throwable)e);
                }
            }).submit((Object)this);
        }
        Sponge.getEventManager().registerListeners((Object)this, (Object)new BuycraftListener(this));
        Sponge.getEventManager().registerListeners((Object)this, (Object)new RecentPurchaseSignListener(this));
        Sponge.getEventManager().registerListeners((Object)this, (Object)new BuyNowSignListener(this));
        Sponge.getCommandManager().register((Object)this, (CommandCallable)this.buildCommands(), new String[]{"buycraft"});
        Sponge.getCommandManager().register((Object)this, (CommandCallable)CommandSpec.builder().description((Text)Text.of((String)this.i18n.get("usage_sponge_listing", new Object[0]))).executor((org.spongepowered.api.command.spec.CommandExecutor)new ListPackagesCmd(this)).build(), this.configuration.getBuyCommandName());
    }

    @Listener
    public void onGameStoppingServerEvent(GameStoppingServerEvent event) {
        try {
            this.recentPurchaseSignStorage.save(this.baseDirectory.resolve("purchase_signs.json"));
        }
        catch (IOException e) {
            this.logger.error("Can't save purchase signs, continuing anyway");
        }
        try {
            this.buyNowSignStorage.save(this.baseDirectory.resolve("buy_now_signs.json"));
        }
        catch (IOException e) {
            this.logger.error("Can't save purchase signs, continuing anyway");
        }
        this.completedCommandsTask.flush();
    }

    private void initializeHttpListener(Integer port) {
        try {
            HttpServer server = HttpServer.create(new InetSocketAddress(port), 50);
            server.createContext("/", new Handler(this));
            server.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private CommandSpec buildCommands() {
        CommandSpec refresh = CommandSpec.builder().description((Text)Text.of((String)this.i18n.get("usage_refresh", new Object[0]))).permission("buycraft.admin").executor((org.spongepowered.api.command.spec.CommandExecutor)new RefreshCmd(this)).build();
        CommandSpec secret = CommandSpec.builder().description((Text)Text.of((String)this.i18n.get("usage_secret", new Object[0]))).permission("buycraft.admin").arguments(GenericArguments.onlyOne((CommandElement)GenericArguments.string((Text)Text.of((String)"secret")))).executor((org.spongepowered.api.command.spec.CommandExecutor)new SecretCmd(this)).build();
        CommandSpec report = CommandSpec.builder().description((Text)Text.of((String)this.i18n.get("usage_report", new Object[0]))).executor((org.spongepowered.api.command.spec.CommandExecutor)new ReportCmd(this)).permission("buycraft.admin").build();
        CommandSpec info = CommandSpec.builder().description((Text)Text.of((String)this.i18n.get("usage_information", new Object[0]))).executor((org.spongepowered.api.command.spec.CommandExecutor)new InfoCmd(this)).build();
        CommandSpec forcecheck = CommandSpec.builder().description((Text)Text.of((String)this.i18n.get("usage_forcecheck", new Object[0]))).executor((org.spongepowered.api.command.spec.CommandExecutor)new ForceCheckCmd(this)).permission("buycraft.admin").build();
        CommandSpec coupon = this.buildCouponCommands();
        return CommandSpec.builder().description((Text)Text.of((String)"Main command for the Buycraft plugin.")).child((CommandCallable)report, new String[]{"report"}).child((CommandCallable)secret, new String[]{"secret"}).child((CommandCallable)refresh, new String[]{"refresh"}).child((CommandCallable)info, new String[]{"info"}).child((CommandCallable)forcecheck, new String[]{"forcecheck"}).child((CommandCallable)coupon, new String[]{"coupon"}).build();
    }

    private CommandSpec buildCouponCommands() {
        CouponCmd cmd = new CouponCmd(this);
        CommandSpec create = CommandSpec.builder().executor(cmd::createCoupon).arguments(GenericArguments.allOf((CommandElement)GenericArguments.string((Text)Text.of((String)"args")))).build();
        CommandSpec delete = CommandSpec.builder().executor(cmd::deleteCoupon).arguments(GenericArguments.onlyOne((CommandElement)GenericArguments.string((Text)Text.of((String)"code")))).build();
        return CommandSpec.builder().description((Text)Text.of((String)this.i18n.get("usage_coupon", new Object[0]))).permission("buycraft.admin").child((CommandCallable)create, new String[]{"create"}).child((CommandCallable)delete, new String[]{"delete"}).build();
    }

    public void saveConfiguration() throws IOException {
        this.configuration.save(this.baseDirectory.resolve("config.properties"));
    }

    public void updateInformation(ApiClient client) throws IOException, ApiException {
        this.serverInformation = client.getServerInformation();
        if (!this.configuration.isBungeeCord() && Sponge.getServer().getOnlineMode() != this.serverInformation.getAccount().isOnlineMode()) {
            this.getLogger().warn("Your server and webstore online mode settings are mismatched. Unless you are using a proxy and server combination (such as BungeeCord/Spigot or LilyPad/Connect) that corrects UUIDs, then you may experience issues with packages not applying.");
            this.getLogger().warn("If you have verified that your set up is correct, you can suppress this message by setting is-bungeecord=true in your BuycraftX config.properties.");
        }
    }

    public PlaceholderManager getPlaceholderManager() {
        return this.placeholderManager;
    }

    public BuycraftConfiguration getConfiguration() {
        return this.configuration;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public DuePlayerFetcher getDuePlayerFetcher() {
        return this.duePlayerFetcher;
    }

    public ListingUpdateTask getListingUpdateTask() {
        return this.listingUpdateTask;
    }

    public ServerInformation getServerInformation() {
        return this.serverInformation;
    }

    public RecentPurchaseSignStorage getRecentPurchaseSignStorage() {
        return this.recentPurchaseSignStorage;
    }

    public BuyNowSignStorage getBuyNowSignStorage() {
        return this.buyNowSignStorage;
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public IBuycraftPlatform getPlatform() {
        return this.platform;
    }

    public CommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public LoggerUtils getLoggerUtils() {
        return this.loggerUtils;
    }

    public Path getBaseDirectory() {
        return this.baseDirectory;
    }

    public RecentPurchaseSignLayout getRecentPurchaseSignLayout() {
        return this.recentPurchaseSignLayout;
    }

    public BuyNowSignLayout getBuyNowSignLayout() {
        return this.buyNowSignLayout;
    }

    public BuycraftI18n getI18n() {
        return this.i18n;
    }

    public PlayerJoinCheckTask getPlayerJoinCheckTask() {
        return this.playerJoinCheckTask;
    }
}

