/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.sponge.command;

import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import net.buycraft.plugin.client.ApiException;
import net.buycraft.plugin.data.Coupon;
import net.buycraft.plugin.shared.util.CouponUtil;
import net.buycraft.plugin.sponge.BuycraftPlugin;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class CouponCmd {
    private static final int COUPON_PAGE_LIMIT = 10;
    private final BuycraftPlugin plugin;

    public CommandResult createCoupon(final CommandSource source, CommandContext ctx) throws CommandException {
        Coupon coupon;
        Collection argsList = ctx.getAll("args");
        String[] argsArray = argsList.toArray(new String[argsList.size()]);
        try {
            coupon = CouponUtil.parseArguments(argsArray);
        }
        catch (Exception e) {
            source.sendMessage((Text)Text.builder((String)this.plugin.getI18n().get("coupon_creation_arg_parse_failure", e.getMessage())).color(TextColors.RED).build());
            return CommandResult.empty();
        }
        this.plugin.getPlatform().executeAsync(new Runnable(){

            @Override
            public void run() {
                try {
                    CouponCmd.this.plugin.getApiClient().createCoupon(coupon);
                    source.sendMessage((Text)Text.builder((String)CouponCmd.this.plugin.getI18n().get("coupon_creation_success", coupon.getCode())).color(TextColors.GREEN).build());
                }
                catch (IOException | ApiException e) {
                    source.sendMessage((Text)Text.builder((String)CouponCmd.this.plugin.getI18n().get("generic_api_operation_error", new Object[0])).color(TextColors.RED).build());
                }
            }
        });
        return CommandResult.empty();
    }

    public CommandResult deleteCoupon(final CommandSource source, CommandContext ctx) throws CommandException {
        Optional codeOptional = ctx.getOne("code");
        if (!codeOptional.isPresent()) {
            source.sendMessage((Text)Text.builder((String)this.plugin.getI18n().get("no_coupon_specified", new Object[0])).color(TextColors.RED).build());
            return CommandResult.empty();
        }
        final String code = (String)codeOptional.get();
        this.plugin.getPlatform().executeAsync(new Runnable(){

            @Override
            public void run() {
                try {
                    CouponCmd.this.plugin.getApiClient().deleteCoupon(code);
                    source.sendMessage((Text)Text.builder((String)CouponCmd.this.plugin.getI18n().get("coupon_deleted", new Object[0])).color(TextColors.GREEN).build());
                }
                catch (IOException | ApiException e) {
                    source.sendMessage((Text)Text.builder((String)e.getMessage()).color(TextColors.RED).build());
                }
            }
        });
        return CommandResult.empty();
    }

    @ConstructorProperties(value={"plugin"})
    public CouponCmd(BuycraftPlugin plugin) {
        this.plugin = plugin;
    }
}

