/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.sponge.command;

import java.beans.ConstructorProperties;
import java.net.MalformedURLException;
import java.net.URL;
import net.buycraft.plugin.sponge.BuycraftPlugin;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;

public class InfoCmd
implements CommandExecutor {
    private final BuycraftPlugin plugin;

    public CommandResult execute(CommandSource sender, CommandContext args) throws CommandException {
        if (this.plugin.getApiClient() == null) {
            sender.sendMessage((Text)Text.builder((String)this.plugin.getI18n().get("generic_api_operation_error", new Object[0])).color(TextColors.RED).build());
            return CommandResult.success();
        }
        if (this.plugin.getServerInformation() == null) {
            sender.sendMessage((Text)Text.builder((String)this.plugin.getI18n().get("information_no_server", new Object[0])).color(TextColors.RED).build());
            return CommandResult.success();
        }
        String webstoreURL = this.plugin.getServerInformation().getAccount().getDomain();
        try {
            LiteralText webstore = Text.builder((String)webstoreURL).color(TextColors.GREEN).onClick((ClickAction)TextActions.openUrl((URL)new URL(webstoreURL))).onHover((HoverAction)TextActions.showText((Text)Text.of((String)webstoreURL))).build();
            LiteralText server = Text.builder((String)this.plugin.getServerInformation().getServer().getName()).color(TextColors.GREEN).build();
            sender.sendMessages(new Text[]{Text.builder((String)(this.plugin.getI18n().get("information_title", new Object[0]) + " ")).color(TextColors.GRAY).build(), Text.builder((String)(this.plugin.getI18n().get("information_sponge_server", new Object[0]) + " ")).color(TextColors.GRAY).append(new Text[]{server}).build(), Text.builder((String)this.plugin.getI18n().get("information_currency", this.plugin.getServerInformation().getAccount().getCurrency().getIso4217())).color(TextColors.GRAY).build(), Text.builder((String)this.plugin.getI18n().get("information_domain", "")).color(TextColors.GRAY).append(new Text[]{webstore}).build()});
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return CommandResult.success();
    }

    @ConstructorProperties(value={"plugin"})
    public InfoCmd(BuycraftPlugin plugin) {
        this.plugin = plugin;
    }
}

