/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.sponge.command;

import com.google.common.collect.ImmutableList;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.stream.Collectors;
import net.buycraft.plugin.data.Category;
import net.buycraft.plugin.data.Package;
import net.buycraft.plugin.shared.util.Node;
import net.buycraft.plugin.sponge.BuycraftPlugin;
import net.buycraft.plugin.sponge.tasks.SendCheckoutLinkTask;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;

public class ListPackagesCmd
implements CommandExecutor {
    private final BuycraftPlugin plugin;

    public CommandResult execute(CommandSource sender, CommandContext args) throws CommandException {
        if (this.plugin.getApiClient() == null) {
            sender.sendMessage((Text)Text.builder((String)this.plugin.getI18n().get("generic_api_operation_error", new Object[0])).color(TextColors.RED).build());
            return CommandResult.success();
        }
        if (this.plugin.getListingUpdateTask().getListing() == null) {
            sender.sendMessage((Text)Text.builder((String)"We're currently retrieving the listing. Sit tight!").color(TextColors.RED).build());
            return CommandResult.success();
        }
        this.sendPaginatedMessage(new Node(this.plugin.getListingUpdateTask().getListing().getCategories(), (List<Package>)ImmutableList.of(), this.plugin.getI18n().get("categories", new Object[0]), null), sender);
        return CommandResult.success();
    }

    private void sendPaginatedMessage(Node node, CommandSource source) {
        PaginationService paginationService = (PaginationService)Sponge.getServiceManager().provide(PaginationService.class).get();
        PaginationList.Builder builder = paginationService.builder();
        List contents = node.getSubcategories().stream().map(category -> Text.builder((String)("> " + category.getName())).color(TextColors.GRAY).onClick((ClickAction)TextActions.executeCallback(commandSource -> {
            if (commandSource instanceof Player) {
                this.sendPaginatedMessage(node.getChild((Category)category), source);
            }
        })).build()).collect(Collectors.toList());
        for (Package p : node.getPackages()) {
            contents.add(Text.builder((String)p.getName()).color(TextColors.WHITE).append(new Text[]{Text.builder((String)" - ").color(TextColors.GRAY).build()}).append(new Text[]{Text.builder((String)"$x".replace("$", this.plugin.getServerInformation().getAccount().getCurrency().getSymbol()).replace("x", "" + p.getEffectivePrice())).color(TextColors.GREEN).build()}).onClick((ClickAction)TextActions.executeCallback(commandSource -> {
                if (commandSource instanceof Player) {
                    this.plugin.getPlatform().executeAsync(new SendCheckoutLinkTask(this.plugin, p.getId(), (Player)commandSource));
                }
            })).build());
        }
        builder.title((Text)Text.builder((String)this.plugin.getI18n().get("sponge_listing", new Object[0])).color(TextColors.AQUA).build()).contents(contents).padding((Text)Text.of((String)"-")).sendTo((MessageReceiver)source);
    }

    @ConstructorProperties(value={"plugin"})
    public ListPackagesCmd(BuycraftPlugin plugin) {
        this.plugin = plugin;
    }
}

