/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.sponge.command;

import java.beans.ConstructorProperties;
import java.io.IOException;
import net.buycraft.plugin.client.ApiException;
import net.buycraft.plugin.client.ProductionApiClient;
import net.buycraft.plugin.data.responses.ServerInformation;
import net.buycraft.plugin.sponge.BuycraftPlugin;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.source.ConsoleSource;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class SecretCmd
implements CommandExecutor {
    private final BuycraftPlugin plugin;

    public CommandResult execute(final CommandSource src, final CommandContext args) throws CommandException {
        if (!(src instanceof ConsoleSource)) {
            src.sendMessage((Text)Text.builder((String)this.plugin.getI18n().get("secret_console_only", new Object[0])).color(TextColors.RED).build());
        } else if (!args.getOne("secret").isPresent()) {
            src.sendMessage((Text)Text.builder((String)this.plugin.getI18n().get("secret_need_key", new Object[0])).color(TextColors.RED).build());
        } else {
            this.plugin.getPlatform().executeAsync(new Runnable(){

                @Override
                public void run() {
                    String currentKey = SecretCmd.this.plugin.getConfiguration().getServerKey();
                    ProductionApiClient client = new ProductionApiClient((String)args.getOne("secret").get(), SecretCmd.this.plugin.getHttpClient());
                    try {
                        SecretCmd.this.plugin.updateInformation(client);
                    }
                    catch (IOException | ApiException e) {
                        SecretCmd.this.plugin.getLogger().error("Unable to verify secret", (Throwable)e);
                        src.sendMessage((Text)Text.builder((String)SecretCmd.this.plugin.getI18n().get("secret_does_not_work", new Object[0])).color(TextColors.RED).build());
                        return;
                    }
                    ServerInformation information = SecretCmd.this.plugin.getServerInformation();
                    SecretCmd.this.plugin.setApiClient(client);
                    SecretCmd.this.plugin.getListingUpdateTask().run();
                    SecretCmd.this.plugin.getConfiguration().setServerKey((String)args.getOne("secret").get());
                    try {
                        SecretCmd.this.plugin.saveConfiguration();
                    }
                    catch (IOException e) {
                        src.sendMessage((Text)Text.builder((String)SecretCmd.this.plugin.getI18n().get("secret_cant_be_saved", new Object[0])).color(TextColors.RED).build());
                    }
                    src.sendMessage((Text)Text.builder((String)SecretCmd.this.plugin.getI18n().get("secret_success", information.getServer().getName(), information.getAccount().getName())).color(TextColors.GREEN).build());
                    boolean repeatChecks = false;
                    if (currentKey == "INVALID") {
                        repeatChecks = true;
                    }
                    SecretCmd.this.plugin.getDuePlayerFetcher().run(repeatChecks);
                }
            });
        }
        return CommandResult.success();
    }

    @ConstructorProperties(value={"plugin"})
    public SecretCmd(BuycraftPlugin plugin) {
        this.plugin = plugin;
    }
}

