/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.sponge.tasks;

import java.beans.ConstructorProperties;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import lombok.NonNull;
import net.buycraft.plugin.client.ApiException;
import net.buycraft.plugin.data.responses.CheckoutUrlResponse;
import net.buycraft.plugin.sponge.BuycraftPlugin;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.format.TextStyles;

public class SendCheckoutLinkTask
implements Runnable {
    @NonNull
    private final BuycraftPlugin plugin;
    private final int pkgId;
    @NonNull
    private final Player player;

    @Override
    public void run() {
        CheckoutUrlResponse response;
        try {
            response = this.plugin.getApiClient().getCheckoutUri(this.player.getName(), this.pkgId);
        }
        catch (IOException | ApiException e) {
            this.player.sendMessage((Text)Text.builder((String)this.plugin.getI18n().get("cant_check_out", new Object[0])).color(TextColors.RED).build());
            return;
        }
        if (response != null) {
            this.player.sendMessage((Text)Text.builder((String)"                                            ").style(new TextStyle[]{TextStyles.STRIKETHROUGH}).build());
            try {
                this.player.sendMessages(new Text[]{Text.builder((String)this.plugin.getI18n().get("to_buy_this_package", new Object[0])).color(TextColors.GREEN).build(), Text.builder((String)response.getUrl()).color(TextColors.BLUE).style(new TextStyle[]{TextStyles.UNDERLINE}).onClick((ClickAction)TextActions.openUrl((URL)new URL(response.getUrl()))).build()});
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            this.player.sendMessage((Text)Text.builder((String)"                                            ").style(new TextStyle[]{TextStyles.STRIKETHROUGH}).build());
        }
    }

    @ConstructorProperties(value={"plugin", "pkgId", "player"})
    public SendCheckoutLinkTask(@NonNull BuycraftPlugin plugin, int pkgId, @NonNull Player player) {
        if (plugin == null) {
            throw new NullPointerException("plugin");
        }
        if (player == null) {
            throw new NullPointerException("player");
        }
        this.plugin = plugin;
        this.pkgId = pkgId;
        this.player = player;
    }
}

