/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.sponge.tasks;

import com.google.common.collect.ImmutableList;
import java.beans.ConstructorProperties;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.buycraft.plugin.data.RecentPayment;
import net.buycraft.plugin.shared.config.signs.storage.RecentPurchaseSignPosition;
import net.buycraft.plugin.sponge.BuycraftPlugin;
import net.buycraft.plugin.sponge.util.SpongeSerializedBlockLocation;
import org.spongepowered.api.block.tileentity.Skull;
import org.spongepowered.api.block.tileentity.TileEntity;
import org.spongepowered.api.block.tileentity.TileEntityTypes;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.mutable.tileentity.SignData;
import org.spongepowered.api.data.type.SkullTypes;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.mutable.ListValue;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class SignUpdateApplication
implements Runnable {
    public static final List<Direction> SKULL_CHECK = ImmutableList.of((Object)Direction.NORTH, (Object)Direction.SOUTH, (Object)Direction.EAST, (Object)Direction.WEST, (Object)Direction.NONE);
    private final BuycraftPlugin plugin;
    private final Map<RecentPurchaseSignPosition, RecentPayment> paymentMap;
    private final Map<String, GameProfile> resolvedProfiles;

    private Optional<Skull> findSkull(Location<World> start) {
        for (Direction direction : SKULL_CHECK) {
            Optional entity = start.getRelative(direction).getTileEntity();
            if (!entity.isPresent() || !((TileEntity)entity.get()).getType().equals(TileEntityTypes.SKULL)) continue;
            return Optional.of((Skull)entity.get());
        }
        return Optional.empty();
    }

    @Override
    public void run() {
        for (Map.Entry<RecentPurchaseSignPosition, RecentPayment> entry : this.paymentMap.entrySet()) {
            Location<World> location = SpongeSerializedBlockLocation.toSponge(entry.getKey().getLocation());
            Optional entity = location.getTileEntity();
            if (entity.isPresent() && ((TileEntity)entity.get()).supports(SignData.class)) {
                GameProfile profile;
                SignData signData = (SignData)((TileEntity)entity.get()).getOrCreate(SignData.class).get();
                ListValue lines = signData.lines();
                if (entry.getValue() != null) {
                    lines.set(0, (Object)Text.EMPTY);
                    lines.set(1, (Object)Text.of((String)entry.getValue().getPlayer().getName()));
                    NumberFormat format = NumberFormat.getCurrencyInstance(Locale.US);
                    format.setCurrency(Currency.getInstance(entry.getValue().getCurrency().getIso4217()));
                    lines.set(2, (Object)Text.of((String)format.format(entry.getValue().getAmount())));
                    lines.set(3, (Object)Text.EMPTY);
                } else {
                    for (int i = 0; i < 4; ++i) {
                        lines.set(i, (Object)Text.EMPTY);
                    }
                }
                ((TileEntity)entity.get()).offer((BaseValue)lines);
                Location supportedBy = location.getRelative(Direction.UP);
                Optional<Skull> skullOptional = this.findSkull((Location<World>)supportedBy);
                if (!skullOptional.isPresent()) continue;
                Skull skull = skullOptional.get();
                if (!skull.supports(Keys.REPRESENTED_PLAYER)) {
                    skull.offer(Keys.SKULL_TYPE, (Object)SkullTypes.PLAYER);
                }
                if ((profile = entry.getValue() != null ? this.resolvedProfiles.getOrDefault(entry.getValue().getPlayer().getName(), this.resolvedProfiles.get("MHF_Question")) : this.resolvedProfiles.get("MHF_Question")) == null) continue;
                skull.offer(Keys.REPRESENTED_PLAYER, (Object)profile);
                continue;
            }
            this.plugin.getLogger().error("Location " + entry.getKey() + " doesn't have a tile entity! (Sign missing?)");
        }
    }

    @ConstructorProperties(value={"plugin", "paymentMap", "resolvedProfiles"})
    public SignUpdateApplication(BuycraftPlugin plugin, Map<RecentPurchaseSignPosition, RecentPayment> paymentMap, Map<String, GameProfile> resolvedProfiles) {
        this.plugin = plugin;
        this.paymentMap = paymentMap;
        this.resolvedProfiles = resolvedProfiles;
    }
}

