/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.sponge.tasks;

import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.buycraft.plugin.client.ApiException;
import net.buycraft.plugin.data.RecentPayment;
import net.buycraft.plugin.shared.config.signs.storage.RecentPurchaseSignPosition;
import net.buycraft.plugin.sponge.BuycraftPlugin;
import net.buycraft.plugin.sponge.tasks.SignUpdateApplication;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.profile.GameProfile;

public class SignUpdater
implements Runnable {
    private final BuycraftPlugin plugin;

    @Override
    public void run() {
        List<RecentPayment> payments;
        List<RecentPurchaseSignPosition> signs = this.plugin.getRecentPurchaseSignStorage().getSigns();
        OptionalInt maxPos = signs.stream().mapToInt(RecentPurchaseSignPosition::getPosition).max();
        if (!maxPos.isPresent()) {
            return;
        }
        if (this.plugin.getApiClient() == null) {
            return;
        }
        try {
            payments = this.plugin.getApiClient().getRecentPayments(Math.min(100, maxPos.getAsInt()));
        }
        catch (IOException | ApiException e) {
            this.plugin.getLogger().error("Could not fetch recent purchases", (Throwable)e);
            return;
        }
        HashMap<RecentPurchaseSignPosition, RecentPayment> signToPurchases = new HashMap<RecentPurchaseSignPosition, RecentPayment>();
        for (RecentPurchaseSignPosition sign : signs) {
            if (sign.getPosition() > payments.size()) {
                signToPurchases.put(sign, null);
                continue;
            }
            signToPurchases.put(sign, payments.get(sign.getPosition() - 1));
        }
        Set usernames = payments.stream().map(payment -> payment.getPlayer().getName()).collect(Collectors.toSet());
        usernames.add("MHF_Question");
        CompletableFuture future = Sponge.getServer().getGameProfileManager().getAllByName(usernames, true);
        future.whenComplete((result, throwable) -> {
            if (throwable != null) {
                this.plugin.getLogger().error("Unable to fetch player profiles", throwable);
                return;
            }
            Map<String, GameProfile> profileMap = result.stream().filter(p -> p.getName().isPresent()).collect(Collectors.toMap(p -> (String)p.getName().get(), Function.identity()));
            Sponge.getScheduler().createTaskBuilder().execute((Runnable)new SignUpdateApplication(this.plugin, signToPurchases, profileMap)).submit((Object)this.plugin);
        });
    }

    @ConstructorProperties(value={"plugin"})
    public SignUpdater(BuycraftPlugin plugin) {
        this.plugin = plugin;
    }
}

