/*
 * Decompiled with CFR 0.152.
 */
package org.gwmdevelopments.sponge_plugin.library;

import de.randombyte.holograms.api.HologramsService;
import java.io.File;
import java.util.Optional;
import javax.inject.Inject;
import org.gwmdevelopments.sponge_plugin.library.command.GWMLibraryCommandUtils;
import org.gwmdevelopments.sponge_plugin.library.utils.Config;
import org.gwmdevelopments.sponge_plugin.library.utils.Language;
import org.gwmdevelopments.sponge_plugin.library.utils.SpongePlugin;
import org.gwmdevelopments.sponge_plugin.library.utils.Version;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.event.game.GameReloadEvent;
import org.spongepowered.api.event.game.state.GameConstructionEvent;
import org.spongepowered.api.event.game.state.GameInitializationEvent;
import org.spongepowered.api.event.game.state.GamePostInitializationEvent;
import org.spongepowered.api.event.game.state.GamePreInitializationEvent;
import org.spongepowered.api.event.game.state.GameStoppingServerEvent;
import org.spongepowered.api.plugin.Dependency;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.plugin.PluginContainer;

@Plugin(id="gwm_library", name="GWMLibrary", version="1.3.4", description="Necessary library to run plugins developed by GWM!", dependencies={@Dependency(id="holograms", optional=true)}, authors={"GWM"})
public class GWMLibrary
extends SpongePlugin {
    public static final Version VERSION = new Version(null, 1, 3, 4);
    private static GWMLibrary instance = null;
    @Inject
    private Logger logger;
    @Inject
    private PluginContainer container;
    @Inject
    @ConfigDir(sharedRoot=false)
    private File configDirectory;
    private Cause cause;
    private Config config;
    private Config languageConfig;
    private Language language;
    private Optional<HologramsService> hologramsService = Optional.empty();
    private boolean checkUpdates = true;

    public static GWMLibrary getInstance() {
        if (instance == null) {
            throw new RuntimeException("GWMLibrary not initialized!");
        }
        return instance;
    }

    @Listener
    public void onConstruction(GameConstructionEvent event) {
        instance = this;
    }

    @Listener
    public void onPreInitialization(GamePreInitializationEvent event) {
        if (!this.configDirectory.exists()) {
            this.configDirectory.mkdirs();
        }
        this.cause = Cause.of((EventContext)EventContext.empty(), (Object)this.container);
        this.config = new Config(this, "config.conf", false);
        this.languageConfig = new Config(this, "language.conf", false);
        this.loadConfigValues();
        this.language = new Language(this);
        if (this.checkUpdates) {
            this.checkUpdates();
        }
        this.logger.info("\"GamePreInitialization\" completed!");
    }

    @Listener
    public void onInitialization(GameInitializationEvent event) {
        GWMLibraryCommandUtils.registerCommands();
        this.logger.info("\"GameInitialization\" completed!");
    }

    @Listener
    public void onPostInitialization(GamePostInitializationEvent event) {
        this.loadHologramsService();
        this.logger.info("\"GamePostInitialization\" completed!");
    }

    @Listener
    public void onStopping(GameStoppingServerEvent event) {
        this.save();
        this.logger.info("\"GameStopping\" completed!");
    }

    @Listener
    public void reloadListener(GameReloadEvent event) {
        this.reload();
        this.logger.info("\"GameReload\" completed!");
    }

    @Override
    public void save() {
        this.config.save();
        this.languageConfig.save();
        this.logger.info("All plugin configs have been saved!");
    }

    @Override
    public void reload() {
        this.config.reload();
        this.languageConfig.reload();
        this.loadConfigValues();
        this.cause = Cause.of((EventContext)EventContext.empty(), (Object)this.container);
        this.hologramsService = Optional.empty();
        this.loadHologramsService();
        if (this.checkUpdates) {
            this.checkUpdates();
        }
        this.logger.info("Plugin has been reloaded.");
    }

    private void loadConfigValues() {
        this.checkUpdates = this.config.getNode("CHECK_UPDATES").getBoolean(true);
    }

    private boolean loadHologramsService() {
        try {
            this.hologramsService = Sponge.getServiceManager().provide(HologramsService.class);
            if (this.hologramsService.isPresent()) {
                this.logger.info("Holograms Service found!");
                return true;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        this.logger.warn("Holograms Service does not found!");
        this.logger.info("Please install \"Holograms\" plugin (https://ore.spongepowered.org/RandomByte/Holograms) if you want use holograms!");
        return false;
    }

    public Optional<HologramsService> getHologramsService() {
        return this.hologramsService;
    }

    @Override
    public Version getVersion() {
        return VERSION;
    }

    @Override
    public Cause getCause() {
        return this.cause;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public PluginContainer getContainer() {
        return this.container;
    }

    @Override
    public File getConfigDirectory() {
        return this.configDirectory;
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public Config getLanguageConfig() {
        return this.languageConfig;
    }

    @Override
    public Language getLanguage() {
        return this.language;
    }

    public boolean isCheckUpdates() {
        return this.checkUpdates;
    }
}

