/*
 * Decompiled with CFR 0.152.
 */
package org.gwmdevelopments.sponge_plugin.library.utils;

import java.io.File;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import org.gwmdevelopments.sponge_plugin.library.utils.SpongePlugin;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.asset.Asset;
import org.spongepowered.api.asset.AssetManager;

public class Config {
    public static final int DEFAULT_AUTO_SAVE_INTERVAL = 600;
    private SpongePlugin plugin;
    private String name;
    private File file;
    private ConfigurationLoader<CommentedConfigurationNode> loader;
    private ConfigurationNode node;

    public Config(SpongePlugin plugin, String name, boolean auto_save) {
        this(plugin, name, auto_save, 600);
    }

    public Config(SpongePlugin plugin, String name, boolean auto_save, int auto_save_interval) {
        this.plugin = plugin;
        this.name = name;
        try {
            this.file = new File(plugin.getConfigDirectory(), name);
            if (!this.file.exists()) {
                AssetManager assetManager = Sponge.getAssetManager();
                Optional optionalAsset = assetManager.getAsset((Object)plugin, name);
                if (optionalAsset.isPresent()) {
                    Asset asset = (Asset)optionalAsset.get();
                    asset.copyToFile(this.file.toPath());
                } else {
                    plugin.getLogger().warn("Asset \"" + name + "\" not found!");
                    this.file.createNewFile();
                }
            }
            this.loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setFile(this.file)).build();
            this.node = this.loader.load();
            Sponge.getScheduler().createTaskBuilder().delayTicks(1L).execute(this::save).submit((Object)plugin);
            if (auto_save) {
                Sponge.getScheduler().createTaskBuilder().async().execute(this::save).interval((long)auto_save_interval, TimeUnit.SECONDS).submit((Object)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().warn("Failed to initialize config \"" + name + "\"!", (Throwable)e);
        }
    }

    public String getName() {
        return this.name;
    }

    public File getFile() {
        return this.file;
    }

    public ConfigurationLoader<CommentedConfigurationNode> getLoader() {
        return this.loader;
    }

    public ConfigurationNode getNode() {
        return this.node;
    }

    public ConfigurationNode getNode(Object ... objects) {
        return this.node.getNode(objects);
    }

    public void save() {
        try {
            this.loader.save(this.node);
            this.plugin.getLogger().debug("Config \"" + this.name + "\" successfully saved!");
        }
        catch (Exception e) {
            this.plugin.getLogger().warn("Fail saving config \"" + this.name + "\"!", (Throwable)e);
        }
    }

    public void reload() {
        try {
            this.node = this.loader.load();
            this.plugin.getLogger().debug("Config \"" + this.name + "\" successfully reloaded!");
        }
        catch (Exception e) {
            this.plugin.getLogger().warn("Fail reloading config \"" + this.name + "\"!", (Throwable)e);
        }
    }
}

