/*
 * Decompiled with CFR 0.152.
 */
package org.gwmdevelopments.sponge_plugin.library.utils;

import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import ninja.leaping.configurate.ConfigurationNode;
import org.gwmdevelopments.sponge_plugin.library.utils.Pair;
import org.gwmdevelopments.sponge_plugin.library.utils.SpongePlugin;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.serializer.FormattingCodeTextSerializer;
import org.spongepowered.api.text.serializer.TextSerializers;

public class Language {
    public static final String DEFAULT = "ERROR! Unable to get phrase \"%PATH%\"! Check your \"language.conf\"!";
    private final SpongePlugin plugin;

    public Language(SpongePlugin plugin) {
        this.plugin = plugin;
    }

    public boolean exists(String path) {
        return !this.plugin.getLanguageConfig().getNode(path).isVirtual();
    }

    public String getPhrase(String path, Pair<String, ?> ... pairs) {
        ConfigurationNode node = this.plugin.getLanguageConfig().getNode(path.toUpperCase());
        try {
            String phrase = (String)node.getValue(TypeToken.of(String.class), (Object)DEFAULT.replace("%PATH%", path));
            for (Pair<String, ?> pair : pairs) {
                phrase = phrase.replace(pair.getKey(), pair.getValue().toString());
            }
            return phrase;
        }
        catch (Exception e) {
            this.plugin.getLogger().warn("Failed to get phrase \"" + path + "\" from language config!", (Throwable)e);
            return DEFAULT.replace("%PATH%", path);
        }
    }

    public Text getText(String path, Pair<String, ?> ... pairs) {
        try {
            return TextSerializers.FORMATTING_CODE.deserialize(this.getPhrase(path, pairs));
        }
        catch (Exception e) {
            this.plugin.getLogger().warn("Failed to get text \"" + path + "\" from language config!", (Throwable)e);
            return Text.builder((String)DEFAULT.replace("%PATH%", path)).color(TextColors.RED).build();
        }
    }

    public List<String> getPhraseList(String path, Pair<String, ?> ... pairs) {
        ConfigurationNode node = this.plugin.getLanguageConfig().getNode(path.toUpperCase());
        try {
            List list = (List)node.getValue((TypeToken)new TypeToken<List<String>>(){}, new ArrayList());
            for (int i = 0; i < list.size(); ++i) {
                String phrase = (String)list.get(i);
                for (Pair<String, ?> pair : pairs) {
                    phrase = phrase.replace(pair.getKey(), pair.getValue().toString());
                }
                list.set(i, phrase);
            }
            return list;
        }
        catch (Exception e) {
            this.plugin.getLogger().warn("Failed to get phrase list \"" + path + "\" from language config!", (Throwable)e);
            ArrayList<String> list = new ArrayList<String>();
            list.add(DEFAULT.replace("%PATH%", path));
            return list;
        }
    }

    public List<Text> getTextList(String path, Pair<String, ?> ... pairs) {
        try {
            return this.getPhraseList(path, pairs).stream().map(arg_0 -> ((FormattingCodeTextSerializer)TextSerializers.FORMATTING_CODE).deserialize(arg_0)).collect(Collectors.toList());
        }
        catch (Exception e) {
            this.plugin.getLogger().warn("Failed to get text list \"" + path + "\" from language config!", (Throwable)e);
            ArrayList<Text> list = new ArrayList<Text>();
            list.add((Text)Text.builder((String)DEFAULT.replace("%PATH%", path)).color(TextColors.RED).build());
            return list;
        }
    }
}

