/*
 * Decompiled with CFR 0.152.
 */
package org.gwmdevelopments.sponge_plugin.library.utils;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.gwmdevelopments.sponge_plugin.library.utils.Config;
import org.gwmdevelopments.sponge_plugin.library.utils.Language;
import org.gwmdevelopments.sponge_plugin.library.utils.Version;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.plugin.PluginContainer;

public abstract class SpongePlugin {
    public void checkUpdates() {
        Sponge.getScheduler().createTaskBuilder().async().execute(() -> {
            try {
                InputStreamReader reader = new InputStreamReader(new URL("https://ore.spongepowered.org/api/projects/" + this.getContainer().getId()).openStream());
                JsonObject object = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
                Version oreVersion = Version.parse(object.get("recommended").getAsJsonObject().get("name").getAsJsonPrimitive().getAsString());
                if (oreVersion.compareTo(this.getVersion()) > 0) {
                    this.getLogger().warn("New version (" + oreVersion.toString() + ") available on Ore!");
                }
            }
            catch (Exception e) {
                this.getLogger().warn("Failed to check plugin updates on Ore!", (Throwable)e);
            }
        }).submit((Object)this);
    }

    public void save() {
    }

    public void reload() {
    }

    public abstract Version getVersion();

    public abstract Cause getCause();

    public abstract Logger getLogger();

    public abstract PluginContainer getContainer();

    public abstract File getConfigDirectory();

    public abstract Config getConfig();

    public abstract Config getLanguageConfig();

    public abstract Language getLanguage();
}

