/*
 * Decompiled with CFR 0.152.
 */
package baubles.common.event;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.IBauble;
import baubles.api.cap.BaublesCapabilities;
import baubles.api.cap.IBaublesItemHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class CommandBaubles
extends CommandBase {
    private List<String> aliases = new ArrayList<String>();

    public CommandBaubles() {
        this.aliases.add("baub");
        this.aliases.add("bau");
    }

    public String func_71517_b() {
        return "baubles";
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    public String func_71518_a(ICommandSender icommandsender) {
        return "/baubles <action> [<player> [<params>]]";
    }

    public int func_82362_a() {
        return 2;
    }

    public boolean func_82358_a(String[] astring, int i) {
        return i == 1;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 2 || args[0].equalsIgnoreCase("help")) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("\u00a73You can also use /baub or /bau instead of /baubles.", new Object[0]));
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("\u00a73Use this to view the baubles inventory of a player.", new Object[0]));
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("  /baubles view <player>", new Object[0]));
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("\u00a73Use this to clear a players baubles inventory. Default is everything or you can give a slot number", new Object[0]));
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("  /baubles clear <player> [<slot>]", new Object[0]));
        } else if (args.length >= 2) {
            EntityPlayerMP entityplayermp = CommandBaubles.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[1]);
            if (entityplayermp == null) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("\u00a7c" + args[1] + " not found", new Object[0]));
                return;
            }
            IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)entityplayermp);
            if (args[0].equalsIgnoreCase("view")) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("\u00a73Showing baubles for " + entityplayermp.func_70005_c_(), new Object[0]));
                for (int a = 0; a < baubles.getSlots(); ++a) {
                    ItemStack st = baubles.getStackInSlot(a);
                    if (st.func_190926_b() || !st.hasCapability(BaublesCapabilities.CAPABILITY_ITEM_BAUBLE, null)) continue;
                    IBauble bauble = (IBauble)st.getCapability(BaublesCapabilities.CAPABILITY_ITEM_BAUBLE, null);
                    BaubleType bt = bauble.getBaubleType(st);
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("\u00a73 [Slot " + a + "] " + (Object)((Object)bt) + " " + st.func_82833_r(), new Object[0]));
                }
            } else if (args[0].equalsIgnoreCase("clear")) {
                if (args.length >= 3) {
                    int slot = -1;
                    try {
                        slot = Integer.parseInt(args[2]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (slot < 0 || slot >= baubles.getSlots()) {
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("\u00a7cInvalid arguments", new Object[0]));
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("\u00a7cUse /baubles help to get help", new Object[0]));
                    } else {
                        baubles.setStackInSlot(slot, ItemStack.field_190927_a);
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("\u00a73Cleared baubles slot " + slot + " for " + entityplayermp.func_70005_c_(), new Object[0]));
                        entityplayermp.func_145747_a((ITextComponent)new TextComponentTranslation("\u00a74Your baubles slot " + slot + " has been cleared by admin " + sender.func_70005_c_(), new Object[0]));
                    }
                } else {
                    for (int a = 0; a < baubles.getSlots(); ++a) {
                        baubles.setStackInSlot(a, ItemStack.field_190927_a);
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("\u00a73Cleared all baubles slots for " + entityplayermp.func_70005_c_(), new Object[0]));
                    entityplayermp.func_145747_a((ITextComponent)new TextComponentTranslation("\u00a74All your baubles slots have been cleared by admin " + sender.func_70005_c_(), new Object[0]));
                }
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("\u00a7cInvalid arguments", new Object[0]));
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("\u00a7cUse /baubles help to get help", new Object[0]));
            }
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("\u00a7cInvalid arguments", new Object[0]));
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("\u00a7cUse /baubles help to get help", new Object[0]));
        }
    }
}

