/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.filter;

import java.io.IOException;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.client.gui.filter.GuiFilter;
import mekanism.common.Mekanism;
import mekanism.common.content.filter.IOreDictFilter;
import mekanism.common.content.transporter.TransporterFilter;
import mekanism.common.network.PacketEditFilter;
import mekanism.common.network.PacketNewFilter;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.LangUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class GuiOreDictFilter<FILTER extends IOreDictFilter, TILE extends TileEntityContainerBlock>
extends GuiFilter<TILE> {
    protected String status = (Object)((Object)EnumColor.DARK_GREEN) + LangUtils.localize("gui.allOK");
    protected ItemStack renderStack = ItemStack.field_190927_a;
    protected List<ItemStack> iterStacks;
    protected GuiTextField oreDictText;
    protected boolean isNew = false;
    protected int stackSwitch = 0;
    protected int stackIndex = 0;
    protected int ticker = 0;
    protected FILTER origFilter;
    protected FILTER filter;

    protected GuiOreDictFilter(EntityPlayer player, TILE tile) {
        super(player, tile);
    }

    protected abstract void updateStackList(String var1);

    public void func_73866_w_() {
        super.func_73866_w_();
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146292_n.clear();
        this.addButtons(guiWidth, guiHeight);
        if (this.isNew) {
            ((GuiButton)this.field_146292_n.get((int)1)).field_146124_l = false;
        }
        this.oreDictText = new GuiTextField(2, this.field_146289_q, guiWidth + 35, guiHeight + 47, 95, 12);
        this.oreDictText.func_146203_f(24);
        this.oreDictText.func_146195_b(true);
    }

    public void func_73869_a(char c, int i) throws IOException {
        if (!this.oreDictText.func_146206_l() || i == 1) {
            super.func_73869_a(c, i);
        }
        if (this.oreDictText.func_146206_l() && i == 28) {
            this.setOreDictKey();
            return;
        }
        if (Character.isLetter(c) || Character.isDigit(c) || TransporterFilter.SPECIAL_CHARS.contains(Character.valueOf(c)) || GuiOreDictFilter.isTextboxKey(c, i)) {
            this.oreDictText.func_146201_a(c, i);
        }
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        if (guibutton.field_146127_k == 0) {
            if (!this.oreDictText.func_146179_b().isEmpty()) {
                this.setOreDictKey();
            }
            if (this.filter.getOreDictName() != null && !this.filter.getOreDictName().isEmpty()) {
                if (this.isNew) {
                    Mekanism.packetHandler.sendToServer(new PacketNewFilter.NewFilterMessage(Coord4D.get(this.tileEntity), this.filter));
                } else {
                    Mekanism.packetHandler.sendToServer(new PacketEditFilter.EditFilterMessage(Coord4D.get(this.tileEntity), false, this.origFilter, this.filter));
                }
                this.sendPacketToServer(0);
            } else {
                this.status = (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.oredictFilter.noKey");
                this.ticker = 20;
            }
        } else if (guibutton.field_146127_k == 1) {
            Mekanism.packetHandler.sendToServer(new PacketEditFilter.EditFilterMessage(Coord4D.get(this.tileEntity), true, this.origFilter, null));
            this.sendPacketToServer(0);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.oreDictText.func_146178_a();
        if (this.ticker > 0) {
            --this.ticker;
        } else {
            this.status = (Object)((Object)EnumColor.DARK_GREEN) + LangUtils.localize("gui.allOK");
        }
        if (this.stackSwitch > 0) {
            --this.stackSwitch;
        }
        if (this.stackSwitch == 0 && this.iterStacks != null && this.iterStacks.size() > 0) {
            this.stackSwitch = 20;
            if (this.stackIndex == -1 || this.stackIndex == this.iterStacks.size() - 1) {
                this.stackIndex = 0;
            } else if (this.stackIndex < this.iterStacks.size() - 1) {
                ++this.stackIndex;
            }
            this.renderStack = this.iterStacks.get(this.stackIndex);
        } else if (this.iterStacks != null && this.iterStacks.size() == 0) {
            this.renderStack = ItemStack.field_190927_a;
        }
    }

    protected void setOreDictKey() {
        String oreName = this.oreDictText.func_146179_b();
        if (oreName.isEmpty()) {
            this.status = (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.oredictFilter.noKey");
            return;
        }
        if (oreName.equals(this.filter.getOreDictName())) {
            this.status = (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.oredictFilter.sameKey");
            return;
        }
        this.updateStackList(oreName);
        this.filter.setOreDictName(oreName);
        this.oreDictText.func_146180_a("");
    }
}

