/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.villagers;

import com.google.common.collect.HashMultimap;
import com.rwtema.extrautils2.compatibility.CompatHelper112;
import com.rwtema.extrautils2.compatibility.VillagerTradeCompat;
import com.rwtema.extrautils2.utils.helpers.CollectionHelper;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.procedure.TObjectIntProcedure;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionHelper;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.common.brewing.AbstractBrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;

public class EmeraldForPotions
implements VillagerTradeCompat {
    private static final TObjectIntHashMap<Item> potionItemCost;
    private static final Item[] potionItems;
    static TObjectIntHashMap<PotionType> potionLevels;
    static int size;
    final boolean buyingPotions;

    public EmeraldForPotions(boolean buyingPotions) {
        this.buyingPotions = buyingPotions;
    }

    public static TObjectIntHashMap<PotionType> getCraftLevels() {
        PotionType type;
        List recipes = BrewingRecipeRegistry.getRecipes();
        TObjectIntHashMap potionLevels = EmeraldForPotions.potionLevels;
        if (potionLevels != null && size == recipes.size()) {
            return potionLevels;
        }
        potionLevels = new TObjectIntHashMap();
        potionLevels.put((Object)PotionTypes.field_185229_a, 0);
        potionLevels.put((Object)PotionTypes.field_185230_b, 0);
        HashMultimap potionChildren = HashMultimap.create();
        for (PotionHelper.MixPredicate predicate : PotionHelper.field_185213_a) {
            potionChildren.put(CompatHelper112.getPotionInput(predicate), CompatHelper112.getPotionOutput(predicate));
        }
        for (IBrewingRecipe recipe : recipes) {
            AbstractBrewingRecipe brewingRecipe;
            if (!(recipe instanceof AbstractBrewingRecipe) || !PotionHelper.field_185216_d.apply((Object)(brewingRecipe = (AbstractBrewingRecipe)recipe).getInput())) continue;
            PotionType typeInput = PotionUtils.func_185191_c((ItemStack)brewingRecipe.getInput());
            if (!PotionHelper.field_185216_d.apply((Object)brewingRecipe.getOutput())) continue;
            PotionType typeOutput = PotionUtils.func_185191_c((ItemStack)brewingRecipe.getInput());
            potionChildren.put((Object)typeInput, (Object)typeOutput);
        }
        LinkedList<PotionType> toProcess = new LinkedList<PotionType>();
        toProcess.add(PotionTypes.field_185230_b);
        while ((type = (PotionType)toProcess.poll()) != null) {
            int i = potionLevels.get((Object)type);
            for (PotionType child : potionChildren.get((Object)type)) {
                if (potionLevels.containsKey((Object)child)) continue;
                potionLevels.put((Object)child, i + 1);
                toProcess.add(child);
            }
        }
        potionLevels.retainEntries((TObjectIntProcedure)new TObjectIntProcedure<PotionType>(){

            public boolean execute(PotionType a, int b) {
                return b > 0;
            }
        });
        EmeraldForPotions.potionLevels = potionLevels;
        size = recipes.size();
        return potionLevels;
    }

    @Override
    public void addMerchantRecipeBase(MerchantRecipeList recipeList, Random random) {
        TObjectIntHashMap<PotionType> craftLevels = EmeraldForPotions.getCraftLevels();
        PotionType potionType = (PotionType)CollectionHelper.getRandomElement(craftLevels.keySet(), random);
        Item potionItem = potionItems[random.nextInt(potionItems.length)];
        ItemStack result = PotionUtils.func_185188_a((ItemStack)new ItemStack(potionItem), (PotionType)potionType);
        int level = craftLevels.get((Object)potionType);
        if (this.buyingPotions) {
            int i = level >> 1;
            if (i == 0) {
                return;
            }
            if ((i = i + random.nextInt(i) + (potionItemCost.get((Object)potionItem) >> 1)) > 0) {
                recipeList.add((Object)new MerchantRecipe(result, new ItemStack(Items.field_151166_bC, i)));
            }
        } else {
            int i = 1 + level;
            i = i + random.nextInt(i) + potionItemCost.get((Object)potionItem);
            recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, i), result));
        }
    }

    static {
        potionItems = new Item[]{Items.field_151068_bn, Items.field_151068_bn, Items.field_151068_bn, Items.field_151068_bn, Items.field_185155_bH, Items.field_185155_bH, Items.field_185156_bI};
        size = 0;
        potionItemCost = new TObjectIntHashMap();
        potionItemCost.put((Object)Items.field_151068_bn, 0);
        potionItemCost.put((Object)Items.field_185155_bH, 2);
        potionItemCost.put((Object)Items.field_185156_bI, 8);
    }
}

