/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.api.entities;

import io.github.aquerr.eaglefactions.api.entities.Claim;
import io.github.aquerr.eaglefactions.api.entities.FactionChest;
import io.github.aquerr.eaglefactions.api.entities.FactionFlagTypes;
import io.github.aquerr.eaglefactions.api.entities.FactionHome;
import io.github.aquerr.eaglefactions.api.entities.FactionMemberType;
import java.time.Instant;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.spongepowered.api.text.Text;

public interface Faction {
    public String getName();

    public Text getTag();

    public String getDescription();

    public String getMessageOfTheDay();

    public FactionHome getHome();

    public UUID getLeader();

    public Set<String> getAlliances();

    public Set<Claim> getClaims();

    public Set<String> getEnemies();

    public Set<UUID> getMembers();

    public Set<UUID> getOfficers();

    public Set<UUID> getRecruits();

    public Set<UUID> getPlayers();

    public Map<FactionMemberType, Map<FactionFlagTypes, Boolean>> getFlags();

    public Instant getLastOnline();

    public FactionMemberType getPlayerMemberType(UUID var1);

    public FactionChest getChest();

    public boolean isPublic();

    public boolean containsPlayer(UUID var1);

    public Builder toBuilder();

    public static interface Builder {
        public Builder setName(String var1);

        public Builder setTag(Text var1);

        public Builder setDescription(String var1);

        public Builder setMessageOfTheDay(String var1);

        public Builder setLeader(UUID var1);

        public Builder setRecruits(Set<UUID> var1);

        public Builder setMembers(Set<UUID> var1);

        public Builder setOfficers(Set<UUID> var1);

        public Builder setAlliances(Set<String> var1);

        public Builder setEnemies(Set<String> var1);

        public Builder setClaims(Set<Claim> var1);

        public Builder setHome(FactionHome var1);

        public Builder setLastOnline(Instant var1);

        public Builder setFlags(Map<FactionMemberType, Map<FactionFlagTypes, Boolean>> var1);

        public Builder setChest(FactionChest var1);

        public Builder setIsPublic(boolean var1);

        public Faction build();
    }
}

