/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.api.managers;

import com.google.inject.Singleton;
import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.entities.FactionFlagTypes;
import io.github.aquerr.eaglefactions.api.entities.FactionMemberType;
import io.github.aquerr.eaglefactions.api.managers.FlagManager;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;

@Singleton
public class FlagManagerImpl
implements FlagManager {
    private static FlagManagerImpl INSTANCE = null;
    private final EagleFactions plugin;

    private FlagManagerImpl(EagleFactions plugin) {
        this.plugin = plugin;
        INSTANCE = this;
    }

    public static FlagManagerImpl getInstance(EagleFactions eagleFactions) {
        if (INSTANCE == null) {
            return new FlagManagerImpl(eagleFactions);
        }
        return INSTANCE;
    }

    @Override
    public boolean canBreakBlock(UUID playerUUID, Faction playerFaction, Faction chunkFaction) {
        return this.checkFlag(playerUUID, playerFaction, chunkFaction, FactionFlagTypes.DESTROY);
    }

    @Override
    public boolean canPlaceBlock(UUID playerUUID, Faction playerFaction, Faction chunkFaction) {
        return this.checkFlag(playerUUID, playerFaction, chunkFaction, FactionFlagTypes.PLACE);
    }

    @Override
    public boolean canInteract(UUID playerUUID, Faction playerFaction, Faction chunkFaction) {
        return this.checkFlag(playerUUID, playerFaction, chunkFaction, FactionFlagTypes.USE);
    }

    @Override
    public boolean canClaim(UUID playerUUID, Faction playerFaction) {
        return this.checkFlag(playerUUID, playerFaction, FactionFlagTypes.CLAIM);
    }

    @Override
    public boolean canAttack(UUID playerUUID, Faction playerFaction) {
        return this.checkFlag(playerUUID, playerFaction, FactionFlagTypes.CLAIM);
    }

    @Override
    public boolean canInvite(UUID playerUUID, Faction playerFaction) {
        return this.checkFlag(playerUUID, playerFaction, FactionFlagTypes.INVITE);
    }

    private boolean checkFlag(UUID playerUUID, Faction playerFaction, FactionFlagTypes flagTypes) {
        FactionMemberType memberType = this.plugin.getPlayerManager().getFactionMemberType(playerUUID, playerFaction);
        return playerFaction.getFlags().get((Object)memberType).get((Object)flagTypes);
    }

    private boolean checkFlag(UUID playerUUID, Faction playerFaction, Faction chunkFaction, FactionFlagTypes flagType) {
        if (playerFaction.getName().equals(chunkFaction.getName())) {
            FactionMemberType memberType = this.plugin.getPlayerManager().getFactionMemberType(playerUUID, playerFaction);
            return chunkFaction.getFlags().get((Object)memberType).get((Object)flagType);
        }
        if (playerFaction.getAlliances().contains(chunkFaction.getName())) {
            return chunkFaction.getFlags().get((Object)FactionMemberType.ALLY).get((Object)flagType);
        }
        return false;
    }

    public static Map<FactionMemberType, Map<FactionFlagTypes, Boolean>> getDefaultFactionFlags() {
        LinkedHashMap<FactionMemberType, Map<FactionFlagTypes, Boolean>> map = new LinkedHashMap<FactionMemberType, Map<FactionFlagTypes, Boolean>>();
        LinkedHashMap<FactionFlagTypes, Boolean> leaderMap = new LinkedHashMap<FactionFlagTypes, Boolean>();
        LinkedHashMap<FactionFlagTypes, Boolean> officerMap = new LinkedHashMap<FactionFlagTypes, Boolean>();
        LinkedHashMap<FactionFlagTypes, Boolean> membersMap = new LinkedHashMap<FactionFlagTypes, Boolean>();
        LinkedHashMap<FactionFlagTypes, Boolean> recruitsMap = new LinkedHashMap<FactionFlagTypes, Boolean>();
        LinkedHashMap<FactionFlagTypes, Boolean> allyMap = new LinkedHashMap<FactionFlagTypes, Boolean>();
        leaderMap.put(FactionFlagTypes.USE, true);
        leaderMap.put(FactionFlagTypes.PLACE, true);
        leaderMap.put(FactionFlagTypes.DESTROY, true);
        leaderMap.put(FactionFlagTypes.CLAIM, true);
        leaderMap.put(FactionFlagTypes.ATTACK, true);
        leaderMap.put(FactionFlagTypes.INVITE, true);
        officerMap.put(FactionFlagTypes.USE, true);
        officerMap.put(FactionFlagTypes.PLACE, true);
        officerMap.put(FactionFlagTypes.DESTROY, true);
        officerMap.put(FactionFlagTypes.CLAIM, true);
        officerMap.put(FactionFlagTypes.ATTACK, true);
        officerMap.put(FactionFlagTypes.INVITE, true);
        membersMap.put(FactionFlagTypes.USE, true);
        membersMap.put(FactionFlagTypes.PLACE, true);
        membersMap.put(FactionFlagTypes.DESTROY, true);
        membersMap.put(FactionFlagTypes.CLAIM, false);
        membersMap.put(FactionFlagTypes.ATTACK, false);
        membersMap.put(FactionFlagTypes.INVITE, true);
        recruitsMap.put(FactionFlagTypes.USE, true);
        recruitsMap.put(FactionFlagTypes.PLACE, true);
        recruitsMap.put(FactionFlagTypes.DESTROY, true);
        recruitsMap.put(FactionFlagTypes.CLAIM, false);
        recruitsMap.put(FactionFlagTypes.ATTACK, false);
        recruitsMap.put(FactionFlagTypes.INVITE, false);
        allyMap.put(FactionFlagTypes.USE, true);
        allyMap.put(FactionFlagTypes.PLACE, false);
        allyMap.put(FactionFlagTypes.DESTROY, false);
        map.put(FactionMemberType.LEADER, leaderMap);
        map.put(FactionMemberType.OFFICER, officerMap);
        map.put(FactionMemberType.MEMBER, membersMap);
        map.put(FactionMemberType.RECRUIT, recruitsMap);
        map.put(FactionMemberType.ALLY, allyMap);
        return map;
    }
}

