/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common;

import com.google.inject.Inject;
import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.config.Configuration;
import io.github.aquerr.eaglefactions.api.entities.AllyRequest;
import io.github.aquerr.eaglefactions.api.entities.ArmisticeRequest;
import io.github.aquerr.eaglefactions.api.entities.ChatEnum;
import io.github.aquerr.eaglefactions.api.entities.Invite;
import io.github.aquerr.eaglefactions.api.logic.AttackLogic;
import io.github.aquerr.eaglefactions.api.logic.FactionLogic;
import io.github.aquerr.eaglefactions.api.logic.PVPLogger;
import io.github.aquerr.eaglefactions.api.managers.FlagManagerImpl;
import io.github.aquerr.eaglefactions.api.managers.PowerManager;
import io.github.aquerr.eaglefactions.api.managers.ProtectionManager;
import io.github.aquerr.eaglefactions.api.storage.StorageManager;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.commands.AdminCommand;
import io.github.aquerr.eaglefactions.common.commands.AllyCommand;
import io.github.aquerr.eaglefactions.common.commands.AttackCommand;
import io.github.aquerr.eaglefactions.common.commands.AutoClaimCommand;
import io.github.aquerr.eaglefactions.common.commands.AutoMapCommand;
import io.github.aquerr.eaglefactions.common.commands.ChatCommand;
import io.github.aquerr.eaglefactions.common.commands.ChestCommand;
import io.github.aquerr.eaglefactions.common.commands.ClaimCommand;
import io.github.aquerr.eaglefactions.common.commands.CoordsCommand;
import io.github.aquerr.eaglefactions.common.commands.CreateCommand;
import io.github.aquerr.eaglefactions.common.commands.DebugCommand;
import io.github.aquerr.eaglefactions.common.commands.DemoteCommand;
import io.github.aquerr.eaglefactions.common.commands.DescriptionCommand;
import io.github.aquerr.eaglefactions.common.commands.DisbandCommand;
import io.github.aquerr.eaglefactions.common.commands.EagleFeatherCommand;
import io.github.aquerr.eaglefactions.common.commands.EnemyCommand;
import io.github.aquerr.eaglefactions.common.commands.FlagsCommand;
import io.github.aquerr.eaglefactions.common.commands.HelpCommand;
import io.github.aquerr.eaglefactions.common.commands.HomeCommand;
import io.github.aquerr.eaglefactions.common.commands.InfoCommand;
import io.github.aquerr.eaglefactions.common.commands.InviteCommand;
import io.github.aquerr.eaglefactions.common.commands.JoinCommand;
import io.github.aquerr.eaglefactions.common.commands.KickCommand;
import io.github.aquerr.eaglefactions.common.commands.LeaveCommand;
import io.github.aquerr.eaglefactions.common.commands.ListCommand;
import io.github.aquerr.eaglefactions.common.commands.MapCommand;
import io.github.aquerr.eaglefactions.common.commands.MaxPowerCommand;
import io.github.aquerr.eaglefactions.common.commands.MotdCommand;
import io.github.aquerr.eaglefactions.common.commands.PlayerCommand;
import io.github.aquerr.eaglefactions.common.commands.PromoteCommand;
import io.github.aquerr.eaglefactions.common.commands.PublicCommand;
import io.github.aquerr.eaglefactions.common.commands.ReloadCommand;
import io.github.aquerr.eaglefactions.common.commands.RenameCommand;
import io.github.aquerr.eaglefactions.common.commands.SetHomeCommand;
import io.github.aquerr.eaglefactions.common.commands.SetLeaderCommand;
import io.github.aquerr.eaglefactions.common.commands.SetPowerCommand;
import io.github.aquerr.eaglefactions.common.commands.SquareClaimCommand;
import io.github.aquerr.eaglefactions.common.commands.TagColorCommand;
import io.github.aquerr.eaglefactions.common.commands.TagCommand;
import io.github.aquerr.eaglefactions.common.commands.TopCommand;
import io.github.aquerr.eaglefactions.common.commands.UnclaimCommand;
import io.github.aquerr.eaglefactions.common.commands.UnclaimallCommand;
import io.github.aquerr.eaglefactions.common.commands.VersionCommand;
import io.github.aquerr.eaglefactions.common.commands.args.FactionNameArgument;
import io.github.aquerr.eaglefactions.common.commands.args.FactionPlayerArgument;
import io.github.aquerr.eaglefactions.common.config.ConfigurationImpl;
import io.github.aquerr.eaglefactions.common.dynmap.DynmapMain;
import io.github.aquerr.eaglefactions.common.listeners.BlockBreakListener;
import io.github.aquerr.eaglefactions.common.listeners.BlockPlaceListener;
import io.github.aquerr.eaglefactions.common.listeners.ChatMessageListener;
import io.github.aquerr.eaglefactions.common.listeners.EntityDamageListener;
import io.github.aquerr.eaglefactions.common.listeners.EntitySpawnListener;
import io.github.aquerr.eaglefactions.common.listeners.ExplosionListener;
import io.github.aquerr.eaglefactions.common.listeners.FactionJoinListener;
import io.github.aquerr.eaglefactions.common.listeners.FactionKickListener;
import io.github.aquerr.eaglefactions.common.listeners.FactionLeaveListener;
import io.github.aquerr.eaglefactions.common.listeners.ModifyBlockListener;
import io.github.aquerr.eaglefactions.common.listeners.NotifyNeighborBlockEventListener;
import io.github.aquerr.eaglefactions.common.listeners.PlayerDeathListener;
import io.github.aquerr.eaglefactions.common.listeners.PlayerDisconnectListener;
import io.github.aquerr.eaglefactions.common.listeners.PlayerInteractListener;
import io.github.aquerr.eaglefactions.common.listeners.PlayerJoinListener;
import io.github.aquerr.eaglefactions.common.listeners.PlayerMoveListener;
import io.github.aquerr.eaglefactions.common.listeners.SendCommandListener;
import io.github.aquerr.eaglefactions.common.logic.AttackLogicImpl;
import io.github.aquerr.eaglefactions.common.logic.FactionLogicImpl;
import io.github.aquerr.eaglefactions.common.logic.PVPLoggerImpl;
import io.github.aquerr.eaglefactions.common.managers.PlayerManagerImpl;
import io.github.aquerr.eaglefactions.common.managers.PowerManagerImpl;
import io.github.aquerr.eaglefactions.common.managers.ProtectionManagerImpl;
import io.github.aquerr.eaglefactions.common.message.MessageLoader;
import io.github.aquerr.eaglefactions.common.message.PluginMessages;
import io.github.aquerr.eaglefactions.common.placeholders.EFPlaceholderService;
import io.github.aquerr.eaglefactions.common.scheduling.EagleFactionsScheduler;
import io.github.aquerr.eaglefactions.common.scheduling.FactionRemoverTask;
import io.github.aquerr.eaglefactions.common.storage.StorageManagerImpl;
import io.github.aquerr.eaglefactions.common.version.VersionChecker;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.asset.Asset;
import org.spongepowered.api.asset.AssetId;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.GameReloadEvent;
import org.spongepowered.api.event.game.state.GameInitializationEvent;
import org.spongepowered.api.event.game.state.GamePostInitializationEvent;
import org.spongepowered.api.event.game.state.GameStartingServerEvent;
import org.spongepowered.api.plugin.Dependency;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.SubjectData;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.Tristate;

@Plugin(id="eaglefactions", name="Eagle Factions", version="0.13.1", description="A factions plugin that will make managing your battle-server easier. :)", authors={"Aquerr"}, dependencies={@Dependency(id="placeholderapi", optional=true)})
public class EagleFactionsPlugin
implements EagleFactions {
    public static final Map<List<String>, CommandSpec> SUBCOMMANDS = new HashMap<List<String>, CommandSpec>();
    public static final List<Invite> INVITE_LIST = new ArrayList<Invite>();
    public static final List<AllyRequest> ALLY_INVITE_LIST = new ArrayList<AllyRequest>();
    public static final List<ArmisticeRequest> ARMISTICE_REQUEST_LIST = new ArrayList<ArmisticeRequest>();
    public static final List<UUID> AUTO_CLAIM_LIST = new ArrayList<UUID>();
    public static final List<UUID> AUTO_MAP_LIST = new ArrayList<UUID>();
    public static final List<UUID> ADMIN_MODE_PLAYERS = new ArrayList<UUID>();
    public static final Map<String, Integer> ATTACKED_FACTIONS = new HashMap<String, Integer>();
    public static final Map<UUID, Integer> BLOCKED_HOME = new HashMap<UUID, Integer>();
    public static final Map<UUID, ChatEnum> CHAT_LIST = new HashMap<UUID, ChatEnum>();
    public static final Map<UUID, Integer> HOME_COOLDOWN_PLAYERS = new HashMap<UUID, Integer>();
    public static final List<UUID> DEBUG_MODE_PLAYERS = new ArrayList<UUID>();
    private static EagleFactionsPlugin eagleFactions;
    private Configuration _configuration;
    private PVPLogger _pvpLogger;
    private PlayerManagerImpl _playerManager;
    private FlagManagerImpl _flagManager;
    private ProtectionManager _protectionManager;
    private PowerManagerImpl _powerManager;
    private AttackLogic _attackLogic;
    private FactionLogic _factionLogic;
    private StorageManager _storageManager;
    private EFPlaceholderService _efPlaceholderService;
    private DynmapMain _dynmapMain;
    @Inject
    @ConfigDir(sharedRoot=false)
    private Path _configDir;
    @Inject
    @AssetId(value="Settings.conf")
    private Asset configAsset;

    public static EagleFactionsPlugin getPlugin() {
        return eagleFactions;
    }

    @Override
    public Path getConfigDir() {
        return this._configDir;
    }

    @Listener
    public void onServerInitialization(GameInitializationEvent event) {
        eagleFactions = this;
        Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.AQUA, "Preparing wings..."}));
        this.setupConfigs();
        Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.AQUA, "Configs loaded..."}));
        Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.AQUA, "Loading managers and cache..."}));
        this.setupManagers();
        this.registerAPI();
        Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.AQUA, "Managers loaded..."}));
        this.initializeCommands();
        Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.AQUA, "Commands loaded..."}));
        this.registerListeners();
        Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "=========================================="}));
        Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{TextColors.AQUA, "Eagle Factions", TextColors.WHITE, " is ready to use!"}));
        Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{TextColors.WHITE, "Thank you for choosing this plugin!"}));
        Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{TextColors.WHITE, "Current version: 0.13.1"}));
        Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{TextColors.WHITE, "Have a great time with Eagle Factions! :D"}));
        Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "=========================================="}));
        CompletableFuture.runAsync(() -> {
            if (!VersionChecker.isLatest("0.13.1")) {
                Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{TextColors.GOLD, "Hey! A new version of ", TextColors.AQUA, "Eagle Factions", TextColors.GOLD, " is available online!"}));
                Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "=========================================="}));
            }
        });
    }

    private void registerAPI() {
        Sponge.getServiceManager().setProvider((Object)this, FactionLogic.class, (Object)this._factionLogic);
        Sponge.getServiceManager().setProvider((Object)this, PowerManager.class, (Object)this._powerManager);
    }

    @Listener
    public void onGameStarting(GameStartingServerEvent event) {
        try {
            Class<?> placeholderInterface = Class.forName("me.rojo8399.placeholderapi.PlaceholderService");
            Optional placeholderService1 = Sponge.getServiceManager().provide(placeholderInterface);
            placeholderService1.ifPresent(placeholderService -> {
                this.printInfo("Found PlaceholderAPI! Registering placeholders...");
                this._efPlaceholderService = EFPlaceholderService.getInstance(this, placeholderService);
                this.printInfo("Registered Eagle Factions' placeholders.");
            });
        }
        catch (ClassNotFoundException | NoClassDefFoundError error) {
            this.printInfo("PlaceholderAPI could not be found. Skipping addition of placeholders.");
        }
        Optional permissionService = Sponge.getServiceManager().provide(PermissionService.class);
        if (permissionService.isPresent()) {
            ((PermissionService)permissionService.get()).getDefaults().getSubjectData().setPermission(SubjectData.GLOBAL_CONTEXT, "eaglefactions.player", Tristate.TRUE);
        }
        if (this._configuration.getDynmapConfig().isDynmapIntegrationEnabled()) {
            try {
                Class.forName("org.dynmap.DynmapCommonAPI");
                this._dynmapMain = new DynmapMain(this);
                this._dynmapMain.activate();
                this.printInfo("Dynmap Integration is active!");
            }
            catch (ClassNotFoundException error) {
                this.printInfo("Dynmap could not be found. Dynmap integration will not be available.");
            }
        }
    }

    @Listener
    public void onServerPostInitialization(GamePostInitializationEvent event) {
        this.startFactionsRemover();
    }

    @Listener
    public void onReload(GameReloadEvent event) {
        this._configuration.reloadConfiguration();
        this._storageManager.reloadStorage();
        if (event.getSource() instanceof Player) {
            Player player = (Player)event.getSource();
            player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, PluginMessages.CONFIGS_HAS_BEEN_RELOADED}));
        }
    }

    private void initializeCommands() {
        SUBCOMMANDS.put(Collections.singletonList("help"), CommandSpec.builder().description((Text)Text.of((String)"Help")).permission("eaglefactions.player.help").executor((CommandExecutor)new HelpCommand(this)).build());
        SUBCOMMANDS.put(Arrays.asList("c", "create"), CommandSpec.builder().description((Text)Text.of((String)"Create Faction Command")).permission("eaglefactions.player.create").arguments(new CommandElement[]{GenericArguments.string((Text)Text.of((String)"tag")), GenericArguments.string((Text)Text.of((String)"faction name"))}).executor((CommandExecutor)new CreateCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("disband"), CommandSpec.builder().description((Text)Text.of((String)"Disband Faction Command")).permission("eaglefactions.player.disband").arguments(GenericArguments.optional((CommandElement)new FactionNameArgument(this, (Text)Text.of((String)"faction name")))).executor((CommandExecutor)new DisbandCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("list"), CommandSpec.builder().description((Text)Text.of((String)"List all factions")).permission("eaglefactions.player.list").executor((CommandExecutor)new ListCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("invite"), CommandSpec.builder().description((Text)Text.of((String)"Invites a player to the faction")).permission("eaglefactions.player.invite").arguments(GenericArguments.onlyOne((CommandElement)GenericArguments.player((Text)Text.of((String)"player")))).executor((CommandExecutor)new InviteCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("kick"), CommandSpec.builder().description((Text)Text.of((String)"Kicks a player from the faction")).permission("eaglefactions.player.kick").arguments(GenericArguments.onlyOne((CommandElement)new FactionPlayerArgument(this, (Text)Text.of((String)"player")))).executor((CommandExecutor)new KickCommand(this)).build());
        SUBCOMMANDS.put(Arrays.asList("j", "join"), CommandSpec.builder().description((Text)Text.of((String)"Join a specific faction")).permission("eaglefactions.player.join").arguments((CommandElement)new FactionNameArgument(this, (Text)Text.of((String)"faction name"))).executor((CommandExecutor)new JoinCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("leave"), CommandSpec.builder().description((Text)Text.of((String)"Leave a faction")).permission("eaglefactions.player.leave").executor((CommandExecutor)new LeaveCommand(this)).build());
        SUBCOMMANDS.put(Arrays.asList("v", "version"), CommandSpec.builder().description((Text)Text.of((String)"Shows plugin version")).permission("eaglefactions.player.version").executor((CommandExecutor)new VersionCommand(this)).build());
        SUBCOMMANDS.put(Arrays.asList("i", "info"), CommandSpec.builder().description((Text)Text.of((String)"Show info about a faction")).arguments(GenericArguments.optional((CommandElement)new FactionNameArgument(this, (Text)Text.of((String)"faction name")))).executor((CommandExecutor)new InfoCommand(this)).build());
        SUBCOMMANDS.put(Arrays.asList("p", "player"), CommandSpec.builder().description((Text)Text.of((String)"Show info about a player")).permission("eaglefactions.player.player").arguments(GenericArguments.optional((CommandElement)GenericArguments.player((Text)Text.of((String)"player")))).executor((CommandExecutor)new PlayerCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("ally"), CommandSpec.builder().description((Text)Text.of((String)"Invite or remove faction from the alliance")).permission("eaglefactions.player.ally").arguments(GenericArguments.onlyOne((CommandElement)new FactionNameArgument(this, (Text)Text.of((String)"faction name")))).executor((CommandExecutor)new AllyCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("enemy"), CommandSpec.builder().description((Text)Text.of((String)"Declare or remove faction from war")).permission("eaglefactions.player.enemy").arguments(GenericArguments.onlyOne((CommandElement)new FactionNameArgument(this, (Text)Text.of((String)"faction name")))).executor((CommandExecutor)new EnemyCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("promote"), CommandSpec.builder().description((Text)Text.of((String)"Promotes the player to a higher rank")).arguments(GenericArguments.onlyOne((CommandElement)new FactionPlayerArgument(this, (Text)Text.of((String)"player")))).permission("eaglefactions.player.promote").executor((CommandExecutor)new PromoteCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("demote"), CommandSpec.builder().description((Text)Text.of((String)"Demotes the player to a lower rank")).arguments(GenericArguments.onlyOne((CommandElement)new FactionPlayerArgument(this, (Text)Text.of((String)"player")))).permission("eaglefactions.player.demote").executor((CommandExecutor)new DemoteCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("claim"), CommandSpec.builder().description((Text)Text.of((String)"Claim a land for your faction")).permission("eaglefactions.player.claim").executor((CommandExecutor)new ClaimCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("squareclaim"), CommandSpec.builder().description((Text)Text.of((String)"Claim land in form of square with a given radius")).permission("eaglefactions.player.radiusclaim").arguments(GenericArguments.integer((Text)Text.of((String)"radius"))).executor((CommandExecutor)new SquareClaimCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("unclaim"), CommandSpec.builder().description((Text)Text.of((String)"Unclaim a land captured by your faction.")).permission("eaglefactions.player.unclaim").executor((CommandExecutor)new UnclaimCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("unclaimall"), CommandSpec.builder().description((Text)Text.of((String)"Remove all claims")).permission("eaglefactions.player.unclaimall").executor((CommandExecutor)new UnclaimallCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("map"), CommandSpec.builder().description((Text)Text.of((String)"Turn on/off factions map")).permission("eaglefactions.player.map").executor((CommandExecutor)new MapCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("sethome"), CommandSpec.builder().description((Text)Text.of((String)"Set faction's home")).permission("eaglefactions.player.sethome").executor((CommandExecutor)new SetHomeCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("home"), CommandSpec.builder().description((Text)Text.of((String)"Teleport to faction's home")).permission("eaglefactions.player.home").arguments(GenericArguments.optional((CommandElement)new FactionNameArgument(this, (Text)Text.of((String)"faction name")))).executor((CommandExecutor)new HomeCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("autoclaim"), CommandSpec.builder().description((Text)Text.of((String)"Autoclaim Command")).permission("eaglefactions.player.autoclaim").executor((CommandExecutor)new AutoClaimCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("automap"), CommandSpec.builder().description((Text)Text.of((String)"Automap command")).permission("eaglefactions.player.automap").executor((CommandExecutor)new AutoMapCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("admin"), CommandSpec.builder().description((Text)Text.of((String)"Toggle admin mode")).permission("eaglefactions.admin.adminmode").executor((CommandExecutor)new AdminCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("coords"), CommandSpec.builder().description((Text)Text.of((String)"Show your teammates coords")).permission("eaglefactions.player.coords").executor((CommandExecutor)new CoordsCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("setpower"), CommandSpec.builder().description((Text)Text.of((String)"Set player's power")).permission("eaglefactions.admin.setpower").arguments(new CommandElement[]{GenericArguments.player((Text)Text.of((String)"player")), GenericArguments.string((Text)Text.of((String)"power"))}).executor((CommandExecutor)new SetPowerCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("maxpower"), CommandSpec.builder().description((Text)Text.of((String)"Set player's maxpower")).permission("eaglefactions.admin.maxpower").arguments(new CommandElement[]{GenericArguments.player((Text)Text.of((String)"player")), GenericArguments.string((Text)Text.of((String)"power"))}).executor((CommandExecutor)new MaxPowerCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("attack"), CommandSpec.builder().description((Text)Text.of((String)"Destroy a claim")).permission("eaglefactions.player.attack").executor((CommandExecutor)new AttackCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("reload"), CommandSpec.builder().description((Text)Text.of((String)"Reload config file")).permission("eaglefactions.admin.reload").executor((CommandExecutor)new ReloadCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("chat"), CommandSpec.builder().description((Text)Text.of((String)"Chat command")).permission("eaglefactions.player.chat").arguments(GenericArguments.optional((CommandElement)GenericArguments.enumValue((Text)Text.of((String)"chat"), ChatEnum.class))).executor((CommandExecutor)new ChatCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("top"), CommandSpec.builder().description((Text)Text.of((String)"Top Command")).permission("eaglefactions.player.top").executor((CommandExecutor)new TopCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("setleader"), CommandSpec.builder().description((Text)Text.of((String)"Set someone as leader (removes you as a leader if you are one)")).permission("eaglefactions.player.setleader").arguments(GenericArguments.onlyOne((CommandElement)new FactionPlayerArgument(this, (Text)Text.of((String)"player")))).executor((CommandExecutor)new SetLeaderCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("flags"), CommandSpec.builder().description((Text)Text.of((String)"Set flags/privileges for members in faction.")).permission("eaglefactions.player.flags").executor((CommandExecutor)new FlagsCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("tagcolor"), CommandSpec.builder().description((Text)Text.of((String)"Change faction's tag color")).permission("eaglefactions.player.tagcolor").arguments(GenericArguments.catalogedElement((Text)Text.of((String)"color"), TextColor.class)).executor((CommandExecutor)new TagColorCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("rename"), CommandSpec.builder().description((Text)Text.of((String)"Rename faction")).permission("eaglefactions.player.rename").arguments(GenericArguments.string((Text)Text.of((String)"faction name"))).executor((CommandExecutor)new RenameCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("tag"), CommandSpec.builder().description((Text)Text.of((String)"Change faction's tag")).permission("eaglefactions.player.tag").arguments(GenericArguments.string((Text)Text.of((String)"tag"))).executor((CommandExecutor)new TagCommand(this)).build());
        SUBCOMMANDS.put(Arrays.asList("desc", "description"), CommandSpec.builder().description((Text)Text.of((String)"Set faction's description.")).permission("eaglefactions.player.description").arguments(GenericArguments.remainingJoinedStrings((Text)Text.of((String)"description"))).executor((CommandExecutor)new DescriptionCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("motd"), CommandSpec.builder().description((Text)Text.of((String)"Set faction's message of the day.")).permission("eaglefactions.player.motd").arguments(GenericArguments.remainingJoinedStrings((Text)Text.of((String)"motd"))).executor((CommandExecutor)new MotdCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("feather"), CommandSpec.builder().description((Text)Text.of((String)"Spawns mystical eagle's feather")).permission("eaglefactions.admin.feather").executor((CommandExecutor)new EagleFeatherCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("chest"), CommandSpec.builder().description((Text)Text.of((String)"Opens faction's chest")).permission("eaglefactions.player.chest").arguments(GenericArguments.optional((CommandElement)new FactionNameArgument(this, (Text)Text.of((String)"faction name")))).executor((CommandExecutor)new ChestCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("public"), CommandSpec.builder().description((Text)Text.of((String)"Sets faction as public or not")).permission("eaglefactions.player.public").arguments(GenericArguments.optional((CommandElement)new FactionNameArgument(this, (Text)Text.of((String)"faction name")))).executor((CommandExecutor)new PublicCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("debug"), CommandSpec.builder().description((Text)Text.of((String)"Toggles debug mode")).permission("eaglefactions.admin.debug").executor((CommandExecutor)new DebugCommand(this)).build());
        CommandSpec commandEagleFactions = CommandSpec.builder().description((Text)Text.of((String)"Help Command")).executor((CommandExecutor)new HelpCommand(this)).children(SUBCOMMANDS).build();
        Sponge.getCommandManager().register((Object)this, (CommandCallable)commandEagleFactions, new String[]{"factions", "faction", "f"});
    }

    private void registerListeners() {
        Sponge.getEventManager().registerListeners((Object)this, (Object)new EntityDamageListener(this));
        Sponge.getEventManager().registerListeners((Object)this, (Object)new PlayerJoinListener(this));
        Sponge.getEventManager().registerListeners((Object)this, (Object)new PlayerDeathListener(this));
        Sponge.getEventManager().registerListeners((Object)this, (Object)new BlockPlaceListener(this));
        Sponge.getEventManager().registerListeners((Object)this, (Object)new BlockBreakListener(this));
        Sponge.getEventManager().registerListeners((Object)this, (Object)new PlayerInteractListener(this));
        Sponge.getEventManager().registerListeners((Object)this, (Object)new PlayerMoveListener(this));
        Sponge.getEventManager().registerListeners((Object)this, (Object)new ChatMessageListener(this));
        Sponge.getEventManager().registerListeners((Object)this, (Object)new EntitySpawnListener(this));
        Sponge.getEventManager().registerListeners((Object)this, (Object)new PlayerDisconnectListener(this));
        Sponge.getEventManager().registerListeners((Object)this, (Object)new SendCommandListener(this));
        Sponge.getEventManager().registerListeners((Object)this, (Object)new ExplosionListener(this));
        Sponge.getEventManager().registerListeners((Object)this, (Object)new ModifyBlockListener(this));
        Sponge.getEventManager().registerListeners((Object)this, (Object)new NotifyNeighborBlockEventListener(this));
        Sponge.getEventManager().registerListeners((Object)this, (Object)new FactionKickListener(this));
        Sponge.getEventManager().registerListeners((Object)this, (Object)new FactionLeaveListener(this));
        Sponge.getEventManager().registerListeners((Object)this, (Object)new FactionJoinListener(this));
    }

    @Override
    public Configuration getConfiguration() {
        return this._configuration;
    }

    @Override
    public PVPLogger getPVPLogger() {
        return this._pvpLogger;
    }

    @Override
    public FlagManagerImpl getFlagManager() {
        return this._flagManager;
    }

    @Override
    public PlayerManagerImpl getPlayerManager() {
        return this._playerManager;
    }

    @Override
    public PowerManagerImpl getPowerManager() {
        return this._powerManager;
    }

    @Override
    public ProtectionManager getProtectionManager() {
        return this._protectionManager;
    }

    @Override
    public AttackLogic getAttackLogic() {
        return this._attackLogic;
    }

    @Override
    public FactionLogic getFactionLogic() {
        return this._factionLogic;
    }

    @Override
    public StorageManager getStorageManager() {
        return this._storageManager;
    }

    public InputStream getResourceAsStream(String fileName) {
        return this.getClass().getClassLoader().getResourceAsStream(fileName);
    }

    @Override
    public URL getResource(String fileName) {
        return this.getClass().getResource(fileName);
    }

    @Override
    public void printInfo(String message) {
        Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.YELLOW, message}));
    }

    private void setupConfigs() {
        this._configuration = new ConfigurationImpl(this._configDir, this.configAsset);
        MessageLoader messageLoader = MessageLoader.getInstance(this);
        this._pvpLogger = new PVPLoggerImpl(this.getConfiguration());
    }

    private void setupManagers() {
        this._storageManager = StorageManagerImpl.getInstance(this);
        this._playerManager = PlayerManagerImpl.getInstance(this);
        this._powerManager = PowerManagerImpl.getInstance(this);
        this._flagManager = FlagManagerImpl.getInstance(this);
        this._factionLogic = FactionLogicImpl.getInstance(this);
        this._attackLogic = AttackLogicImpl.getInstance(this);
        this._protectionManager = ProtectionManagerImpl.getInstance(this);
    }

    private void startFactionsRemover() {
        if (this.getConfiguration().getFactionsConfig().getMaxInactiveTime() == 0L) {
            return;
        }
        EagleFactionsScheduler.getInstance().scheduleWithDelayedInterval(new FactionRemoverTask(eagleFactions), 0L, TimeUnit.SECONDS, 1L, TimeUnit.HOURS);
    }

    public EFPlaceholderService getEfPlaceholderService() {
        return this._efPlaceholderService;
    }
}

