/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.config.FactionsConfig;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.commands.AbstractCommand;
import io.github.aquerr.eaglefactions.common.events.EventRunner;
import io.github.aquerr.eaglefactions.common.message.PluginMessages;
import java.util.Optional;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class ChestCommand
extends AbstractCommand {
    private final FactionsConfig factionsConfig;

    public ChestCommand(EagleFactions plugin) {
        super(plugin);
        this.factionsConfig = plugin.getConfiguration().getFactionsConfig();
    }

    @Override
    public CommandResult execute(CommandSource source, CommandContext context) throws CommandException {
        Optional optionalFactionName = context.getOne("faction name");
        if (!(source instanceof Player)) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.ONLY_IN_GAME_PLAYERS_CAN_USE_THIS_COMMAND}));
        }
        if (!this.factionsConfig.canUseFactionChest()) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, "Factions' chests are turned off on this server."}));
        }
        Player player = (Player)source;
        Optional<Faction> optionalPlayerFaction = super.getPlugin().getFactionLogic().getFactionByPlayerUUID(player.getUniqueId());
        if (optionalFactionName.isPresent()) {
            if (optionalPlayerFaction.isPresent() && optionalPlayerFaction.get().getName().equals(optionalFactionName.get())) {
                boolean isCancelled = EventRunner.runFactionChestEvent(player, optionalPlayerFaction.get());
                if (isCancelled) {
                    return CommandResult.success();
                }
                this.openFactionChest(player, optionalPlayerFaction.get());
                return CommandResult.success();
            }
            if (!EagleFactionsPlugin.ADMIN_MODE_PLAYERS.contains(player.getUniqueId())) {
                throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, "You need to toggle faction's admin-mode first to view other faction's chest."}));
            }
            Faction nullableFaction = super.getPlugin().getFactionLogic().getFactionByName((String)optionalFactionName.get());
            if (nullableFaction != null) {
                boolean isCancelled = EventRunner.runFactionChestEvent(player, nullableFaction);
                if (isCancelled) {
                    return CommandResult.success();
                }
                this.openFactionChest(player, nullableFaction);
                return CommandResult.success();
            }
        }
        if (!optionalPlayerFaction.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.YOU_MUST_BE_IN_FACTION_IN_ORDER_TO_USE_THIS_COMMAND}));
        }
        Faction faction = optionalPlayerFaction.get();
        boolean isCancelled = EventRunner.runFactionChestEvent(player, faction);
        if (isCancelled) {
            return CommandResult.success();
        }
        this.openFactionChest(player, faction);
        return CommandResult.success();
    }

    private void openFactionChest(Player player, Faction faction) {
        Optional optionalContainer = player.openInventory(faction.getChest().getInventory());
        if (optionalContainer.isPresent()) {
            player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.GREEN, Text.of((String)("You opened " + faction.getName() + " faction's chest!"))}));
        }
    }
}

