/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.commands.AbstractCommand;
import io.github.aquerr.eaglefactions.common.message.PluginMessages;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;

public class CoordsCommand
extends AbstractCommand {
    public CoordsCommand(EagleFactions plugin) {
        super(plugin);
    }

    @Override
    public CommandResult execute(CommandSource source, CommandContext context) throws CommandException {
        if (source instanceof Player) {
            Player player = (Player)source;
            Optional<Faction> optionalPlayerFaction = this.getPlugin().getFactionLogic().getFactionByPlayerUUID(player.getUniqueId());
            ArrayList<Text> teamCoords = new ArrayList<Text>();
            if (optionalPlayerFaction.isPresent()) {
                Text textBuilder;
                Iterator<UUID> leader;
                Faction playerFaction = optionalPlayerFaction.get();
                if (playerFaction.getHome() != null) {
                    Text textBuilder2 = Text.builder().append(new Text[]{Text.of((String)(PluginMessages.FACTIONS_HOME + ": " + playerFaction.getHome().getWorldUUID().toString() + '|' + playerFaction.getHome().getBlockPosition().toString()))}).build();
                    teamCoords.add(textBuilder2);
                }
                if (!playerFaction.getLeader().toString().equals("") && ((Optional)((Object)(leader = this.getPlugin().getPlayerManager().getPlayer(playerFaction.getLeader())))).isPresent()) {
                    Text textBuilder3 = Text.builder().append(new Text[]{Text.of((String)(PluginMessages.LEADER + ": " + ((Player)((Optional)((Object)leader)).get()).getName() + " " + ((Player)((Optional)((Object)leader)).get()).getLocation().getBlockPosition().toString()))}).build();
                    teamCoords.add(textBuilder3);
                }
                if (!playerFaction.getOfficers().isEmpty()) {
                    for (UUID officerUUID : playerFaction.getOfficers()) {
                        Optional<Player> officer = this.getPlugin().getPlayerManager().getPlayer(officerUUID);
                        if (!officer.isPresent()) continue;
                        textBuilder = Text.builder().append(new Text[]{Text.of((String)(PluginMessages.OFFICER + ": " + officer.get().getName() + " " + officer.get().getLocation().getBlockPosition().toString()))}).build();
                        teamCoords.add(textBuilder);
                    }
                }
                if (!playerFaction.getMembers().isEmpty()) {
                    for (UUID memberUUID : playerFaction.getMembers()) {
                        Optional<Player> member = this.getPlugin().getPlayerManager().getPlayer(memberUUID);
                        if (!member.isPresent()) continue;
                        textBuilder = Text.builder().append(new Text[]{Text.of((String)(PluginMessages.MEMBER + ": " + member.get().getName() + " " + member.get().getLocation().getBlockPosition().toString()))}).build();
                        teamCoords.add(textBuilder);
                    }
                }
                if (!playerFaction.getRecruits().isEmpty()) {
                    for (UUID recruitUUID : playerFaction.getRecruits()) {
                        Optional<Player> recruit = this.getPlugin().getPlayerManager().getPlayer(recruitUUID);
                        if (!recruit.isPresent()) continue;
                        textBuilder = Text.builder().append(new Text[]{Text.of((String)(PluginMessages.RECRUIT + ": " + recruit.get().getName() + " " + recruit.get().getLocation().getBlockPosition().toString()))}).build();
                        teamCoords.add(textBuilder);
                    }
                }
                PaginationService paginationService = (PaginationService)Sponge.getServiceManager().provide(PaginationService.class).get();
                PaginationList.Builder paginationBuilder = paginationService.builder().title(Text.of((Object[])new Object[]{TextColors.GREEN, PluginMessages.TEAM_COORDS})).contents(teamCoords);
                paginationBuilder.sendTo((MessageReceiver)source);
            } else {
                source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.YOU_MUST_BE_IN_FACTION_IN_ORDER_TO_USE_THIS_COMMAND}));
            }
        } else {
            source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.ONLY_IN_GAME_PLAYERS_CAN_USE_THIS_COMMAND}));
        }
        return CommandResult.success();
    }
}

