/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.config.FactionsConfig;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.commands.AbstractCommand;
import io.github.aquerr.eaglefactions.common.entities.FactionImpl;
import io.github.aquerr.eaglefactions.common.events.EventRunner;
import io.github.aquerr.eaglefactions.common.message.PluginMessages;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.query.QueryOperation;
import org.spongepowered.api.item.inventory.query.QueryOperationTypes;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class CreateCommand
extends AbstractCommand {
    private final FactionsConfig factionsConfig;

    public CreateCommand(EagleFactions plugin) {
        super(plugin);
        this.factionsConfig = plugin.getConfiguration().getFactionsConfig();
    }

    @Override
    public CommandResult execute(CommandSource source, CommandContext context) throws CommandException {
        Optional optionalFactionName = context.getOne("faction name");
        Optional optionalFactionTag = context.getOne("tag");
        if (!(source instanceof Player)) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.ONLY_IN_GAME_PLAYERS_CAN_USE_THIS_COMMAND}));
        }
        if (!optionalFactionName.isPresent() || !optionalFactionTag.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.WRONG_COMMAND_ARGUMENTS}), true);
        }
        Player player = (Player)source;
        String factionName = (String)optionalFactionName.get();
        String factionTag = (String)optionalFactionTag.get();
        if (!factionName.matches("^[A-Za-z][A-Za-z0-9]*$") || !factionTag.matches("^[A-Za-z][A-Za-z0-9]*$")) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, "Faction name and tag must be alphanumeric!"}));
        }
        if (factionName.equalsIgnoreCase("SafeZone") || factionName.equalsIgnoreCase("WarZone")) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.YOU_CANT_USE_THIS_FACTION_NAME}));
        }
        Optional<Faction> optionalPlayerFaction = this.getPlugin().getFactionLogic().getFactionByPlayerUUID(player.getUniqueId());
        if (optionalPlayerFaction.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.YOU_ARE_ALREADY_IN_A_FACTION}));
        }
        if (this.getPlugin().getFactionLogic().getFactionsTags().stream().anyMatch(x -> x.equalsIgnoreCase(factionTag))) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.PROVIDED_FACTION_TAG_IS_ALREADY_TAKEN}));
        }
        if (factionTag.length() > this.factionsConfig.getMaxTagLength()) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.PROVIDED_FACTION_TAG_IS_TOO_LONG + " (" + PluginMessages.MAX + " " + this.factionsConfig.getMaxTagLength() + " " + PluginMessages.CHARS + ")"}));
        }
        if (factionTag.length() < this.factionsConfig.getMinTagLength()) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.PROVIDED_FACTION_TAG_IS_TOO_SHORT + " (" + PluginMessages.MIN + " " + this.factionsConfig.getMinTagLength() + " " + PluginMessages.CHARS + ")"}));
        }
        if (this.getPlugin().getFactionLogic().getFactionsNames().contains(factionName.toLowerCase())) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.FACTION_WITH_THE_SAME_NAME_ALREADY_EXISTS}));
        }
        if (factionName.length() > this.factionsConfig.getMaxNameLength()) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.PROVIDED_FACTION_NAME_IS_TOO_LONG + " (" + PluginMessages.MAX + " " + this.factionsConfig.getMaxNameLength() + " " + PluginMessages.CHARS + ")"}));
        }
        if (factionName.length() < this.factionsConfig.getMinNameLength()) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.PROVIDED_FACTION_NAME_IS_TOO_SHORT + " (" + PluginMessages.MIN + " " + this.factionsConfig.getMinNameLength() + " " + PluginMessages.CHARS + ")"}));
        }
        if (this.factionsConfig.getFactionCreationByItems()) {
            return this.createByItems(factionName, factionTag, player);
        }
        Faction faction = FactionImpl.builder(factionName, Text.of((Object[])new Object[]{TextColors.GREEN, factionTag}), player.getUniqueId()).build();
        boolean isCancelled = EventRunner.runFactionCreateEvent(player, faction);
        if (isCancelled) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, "Something prevented faction from creating..."}));
        }
        super.getPlugin().getFactionLogic().addFaction(faction);
        player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.GREEN, PluginMessages.FACTION + " " + factionName + " " + PluginMessages.HAS_BEEN_CREATED}));
        return CommandResult.success();
    }

    private CommandResult createByItems(String factionName, String factionTag, Player player) throws CommandException {
        BlockState blockState;
        int variant;
        ItemStack itemStack;
        Optional itemType;
        String itemId;
        String[] idAndVariant;
        Map<String, Integer> requiredItems = this.factionsConfig.getRequiredItemsToCreateFaction();
        CarriedInventory inventory = player.getInventory();
        int allRequiredItems = requiredItems.size();
        int foundItems = 0;
        for (String requiredItem : requiredItems.keySet()) {
            idAndVariant = requiredItem.split(":");
            itemId = idAndVariant[0] + ":" + idAndVariant[1];
            itemType = Sponge.getRegistry().getType(ItemType.class, itemId);
            if (!itemType.isPresent()) continue;
            itemStack = ItemStack.builder().itemType((ItemType)itemType.get()).build();
            itemStack.setQuantity(requiredItems.get(requiredItem).intValue());
            if (idAndVariant.length == 3 && ((ItemType)itemType.get()).getBlock().isPresent()) {
                variant = Integer.parseInt(idAndVariant[2]);
                blockState = (BlockState)((BlockType)((ItemType)itemType.get()).getBlock().get()).getAllBlockStates().toArray()[variant];
                itemStack = ItemStack.builder().fromBlockState(blockState).build();
            }
            if (!inventory.contains(itemStack)) {
                throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.YOU_DONT_HAVE_ENOUGH_RESOURCES_TO_CREATE_A_FACTION}));
            }
            if (!inventory.contains(itemStack)) continue;
            ++foundItems;
        }
        if (allRequiredItems != foundItems) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.YOU_DONT_HAVE_ENOUGH_RESOURCES_TO_CREATE_A_FACTION}));
        }
        for (String requiredItem : requiredItems.keySet()) {
            idAndVariant = requiredItem.split(":");
            itemId = idAndVariant[0] + ":" + idAndVariant[1];
            itemType = Sponge.getRegistry().getType(ItemType.class, itemId);
            if (!itemType.isPresent()) continue;
            itemStack = ItemStack.builder().itemType((ItemType)itemType.get()).build();
            itemStack.setQuantity(requiredItems.get(requiredItem).intValue());
            if (idAndVariant.length == 3 && ((ItemType)itemType.get()).getBlock().isPresent()) {
                variant = Integer.parseInt(idAndVariant[2]);
                blockState = (BlockState)((BlockType)((ItemType)itemType.get()).getBlock().get()).getAllBlockStates().toArray()[variant];
                itemStack = ItemStack.builder().fromBlockState(blockState).build();
            }
            inventory.query(new QueryOperation[]{QueryOperationTypes.ITEM_TYPE.of(itemType.get())}).poll(itemStack.getQuantity());
        }
        Faction faction = FactionImpl.builder(factionName, Text.of((Object[])new Object[]{TextColors.GREEN, factionTag}), player.getUniqueId()).build();
        boolean isCancelled = EventRunner.runFactionCreateEvent(player, faction);
        if (isCancelled) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, "Something prevented faction from creating..."}));
        }
        super.getPlugin().getFactionLogic().addFaction(faction);
        player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.GREEN, PluginMessages.FACTION + " " + factionName + " " + PluginMessages.HAS_BEEN_CREATED}));
        return CommandResult.success();
    }
}

